<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<%@ page import="oracle.sysman.emo.adm.workspacemgr.WorkspaceConstants" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        viewWorkspace.jsp
  -- Created:     vimgupta 09/11/04
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  --
  -- Description: The screen gives overview of selected workspace.It provides following details: 
  -- Differences with Parent workspace for the specified workspace (not available for LIVE workspace). 
  -- Savepoints list
  -- Workspace privileges
  -- Workspace Sessions details
  --%>


<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="viewWorkspaces" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType,cancelURL">
                <uix:formValue name="pageName" value="/database/workspace/viewWorkspace" />
                <uix:formValue name="oname" valueBinding="workspaceName@objectBean@servletRequest" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <uix:pageButtons>
				    <uix:pageButtonBar>
				        <uix:contents>
				        	<uix:messageChoice name="selectedOperationChoice" promptBinding="ACTIONS@uixDBObjectBundle">
								    <uix:contents childDataBinding="actionItemsList@objectBean@servletRequest">
        	                    	<uix:option textBinding="textKey" valueBinding="valueKey"/>
            		                </uix:contents>
							</uix:messageChoice>
                            <uix:submitButton name="event" value="operationsGo" textBinding="GO@uixDBObjectBundle" shortDescBinding="GO@uixDBObjectBundle" />
				            <uix:spacer width="5" height="10" />
                            <uix:submitButton textBinding="EDIT@uixDBObjectBundle" name="event" value="edit" shortDescBinding="EDIT@uixDBObjectBundle"/>	                                           
                            <uix:submitButton textBinding="OK@uixDBObjectBundle" name="event" value="cancel" shortDescBinding="OK@uixDBObjectBundle"/>	         
				        </uix:contents>
				    </uix:pageButtonBar>
				</uix:pageButtons>
                   <uix:contents>
                        <uix:spacer height="10" width="10" />
<%--  				    <uix:header textBinding="GENERAL_TAB@uixWorkspaceObjectBundle">
						    <uix:contents>
--%>						    
						 <uix:labeledFieldLayout columns="2" >
						    
						    <uix:messagePrompt promptBinding="NAME_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />
						    
						    <uix:messagePrompt promptBinding="CONTINUALLY_REFRESH_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="continuallyRefreshedTxt@objectBean@servletRequest" />

						    <uix:messagePrompt promptBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="description@objectBean@servletRequest" />
						    
						   
						    
						    <uix:messagePrompt promptBinding="PARENT_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="parentWorkspace@objectBean@servletRequest" />
							
							 <uix:messagePrompt promptBinding="OWNER_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="owner@objectBean@servletRequest" />

						    <uix:messagePrompt promptBinding="FREEZE_MODE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="freezeModeDetails@objectBean@servletRequest" />
						    

						    <uix:messagePrompt promptBinding="PARENT_SP_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="parentSavepoint@objectBean@servletRequest" />
						    
						    <uix:messagePrompt promptBinding="TIME_CREATED_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="createTime@objectBean@servletRequest" />
						    
						</uix:labeledFieldLayout>

<%--  						  </uix:contents>
						</uix:header>
--%>

<%-- FREEZE TAB 
-- Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
--%>
<%--						
						<uix:header textBinding="FREEZE_TAB@uixWorkspaceObjectBundle">
							    <uix:contents>
							        <uix:tableLayout>
							            <uix:contents>
							                <uix:spacer height="10" width="10" />
							                <uix:rowLayout>
							                    <uix:contents>
							                        <uix:cellFormat hAlign="right">
							                            <uix:contents>
							                                <uix:styledText styleClass="OraInstructionText" textBinding="FREEZE_IS_FROZEN@uixWorkspaceObjectBundle" />
							                                <uix:spacer height="10" width="10" />
							                            </uix:contents>
							                        </uix:cellFormat>
							                        <uix:cellFormat>
							                            <uix:contents>
							                                <uix:messageTextInput name="messageTextInput1" styleClass="OraDataText" readOnly="true" textBinding="freezeStatusTxt@objectBean@servletRequest" />
							                            </uix:contents>
							                        </uix:cellFormat>
							                    </uix:contents>
							                </uix:rowLayout>
							                <uix:rowLayout>
							                    <uix:contents>
							                        <uix:spacer height="5" width="10" />
							                    </uix:contents>
							                </uix:rowLayout>
							                <uix:rowLayout>
							                    <uix:contents>
							                        <uix:cellFormat hAlign="right">
							                            <uix:contents>
							                                <uix:styledText styleClass="OraInstructionText" textBinding="FREEZE_MODE_HEADER@uixWorkspaceObjectBundle" />
							                                <uix:spacer height="10" width="10" />
							                            </uix:contents>
							                        </uix:cellFormat>
							                        <uix:cellFormat>
							                            <uix:contents>
							                                <uix:styledText styleClass="OraDataText" textBinding="freezeModeDetails@objectBean@servletRequest" />
							                            </uix:contents>
							                        </uix:cellFormat>
							                    </uix:contents>
							                </uix:rowLayout>
							            </uix:contents>
							        </uix:tableLayout>
							    </uix:contents>
							</uix:header>
							
--%>							
<%-- DIFF_WITH_PARENT TAB 
-- Bean: oracle.sysman.emo.adm.workspacemgr.DiffWithParentListUI
--%>
							<uix:header textBinding="DIFF_WITH_PARENT_TAB@uixWorkspaceObjectBundle">
							    <uix:contents>
							        <uix:table name="<%=WorkspaceConstants.DIFFERINGTABLES_UI_TABLE%>" 
										id="diffParentListUI" 
										alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
										summaryBinding="DIFF_WITH_PARENT_TAB@uixWorkspaceObjectBundle"
										formSubmitted="true" 
										width="100%" 
										showAll="yes" 
										tableDataBinding="rowData@diffparentbean@servletRequest"
										blockSizeBinding="blockSize@diffparentbean@servletRequest" 
										maxValueBinding="numRows@diffparentbean@servletRequest"
										valueBinding="startIndex@diffparentbean@servletRequest" >
							            <uix:tableFormat tableBanding="rowBanding" />
							            <uix:column>
							                <uix:columnHeader>
							                    <uix:sortableHeader textBinding="SCHEMA_HEADER@uixWorkspaceObjectBundle" />
							                </uix:columnHeader>
							                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
							                <uix:text textBinding="SCHEMA_HEADER" />
							            </uix:column>
							            <uix:column>
							                <uix:columnHeader>
							                    <uix:sortableHeader textBinding="TABLE_HEADER@uixWorkspaceObjectBundle" />
							                </uix:columnHeader>
							                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
							                <uix:text textBinding="TABLE_HEADER" />
							            </uix:column>
							            <uix:column>
							                <uix:columnHeader>
							                    <uix:sortableHeader textBinding="DIFF_LINK_HEADER@uixWorkspaceObjectBundle" />
							                </uix:columnHeader>
							                <uix:columnFormat columnDataFormat="textFormat" width="40%" />
							                <db:link textBinding="VIEW_DETAILS_TEXT@uixWorkspaceObjectBundle" destinationBinding="DIFF_LINK_HEADER" />
							            </uix:column>
							            </uix:table>
							    </uix:contents>
							</uix:header>
<%-- SAVEPOINT TAB
-- Bean: oracle.sysman.emo.adm.workspacemgr.SavePointListUI
--%>							
						<uix:header textBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle">
						    <uix:contents>
								<uix:table name="<%=WorkspaceConstants.SAVEPOINT_TABLE%>"
								alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
								summaryBinding="SAVEPOINT_TAB@uixWorkspaceObjectBundle"
								formSubmitted="true" 
								width="100%" 
								showAll="yes"
								tableDataBinding="rowData@savepointbean@servletRequest"
								blockSizeBinding="blockSize@savepointbean@servletRequest" 
					            maxValueBinding="numRows@savepointbean@servletRequest"
		            			valueBinding="startIndex@savepointbean@servletRequest" >
								    <uix:tableFormat tableBanding="rowBanding" />
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="NAME_HEADER@uixWorkspaceObjectBundle"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								        <uix:text textBinding="NAME_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								        <uix:text textBinding="DESCRIPTION_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="TYPE_HEADER@uixWorkspaceObjectBundle"  />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" />
								        <uix:text textBinding="TYPE_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="OWNER_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="10%" />
								        <uix:text textBinding="OWNER_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="POSITION_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="numberFormat" width="10%" />
								        <uix:text textBinding="POSITION_HEADER" />
								    </uix:column>
								    <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="TIME_CREATED_HEADER@uixWorkspaceObjectBundle" />
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								            <uix:text textBinding="TIME_CREATED_HEADER" />
								    </uix:column>
								</uix:table>
						    </uix:contents>
						</uix:header>
<%-- PRIVILEGE TAB 
-- Bean: oracle.sysman.emo.adm.workspacemgr.PrivilegesListUI
--%>													
						<uix:header textBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle">
						    <uix:contents>
								<uix:table name="<%=WorkspaceConstants.PRIVILEGE_TABLE%>"
								alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
								summaryBinding="PRIVILEGE_TAB@uixWorkspaceObjectBundle"
								formSubmitted="true" 
								width="100%" 
								showAll="yes" 
								tableDataBinding="rowData@privilegebean@servletRequest"
								blockSizeBinding="blockSize@privilegebean@servletRequest" 
					            maxValueBinding="numRows@privilegebean@servletRequest"
		            			valueBinding="startIndex@privilegebean@servletRequest" >
								    <uix:tableFormat tableBanding="rowBanding" />
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="USER_NAME_HEADER@uixWorkspaceObjectBundle"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="16%" />
								        <uix:text textBinding="USER_NAME_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="ACCESS_WORKSPACE_HEADER@uixWorkspaceObjectBundle"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:text textBinding="ACCESS_WORKSPACE_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="CREATE_WORKSPACE_HEADER@uixWorkspaceObjectBundle"  />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:text textBinding="CREATE_WORKSPACE_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="FREEZE_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:text textBinding="FREEZE_WORKSPACE_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="MERGE_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								        <uix:text textBinding="MERGE_WORKSPACE_HEADER" />
								    </uix:column>
								    
								    <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="REMOVE_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								            <uix:text textBinding="REMOVE_WORKSPACE_HEADER" />
								    </uix:column>
								    
								        <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="ROLLBACK_WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="13%" />
								            <uix:text textBinding="ROLLBACK_WORKSPACE_HEADER" />
								    </uix:column>
								</uix:table>
						    </uix:contents>
						</uix:header>
<%-- SESSION TAB 
-- Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceSessionListUI
--%>						
						<uix:header textBinding="SESSION_TAB@uixWorkspaceObjectBundle">
						    <uix:contents>
									<uix:table name="<%=WorkspaceConstants.SESSION_TABLE%>"
									id="sessionsListUI" 
									alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
									summaryBinding="SESSION_TAB@uixWorkspaceObjectBundle"
									formSubmitted="true" 
									width="100%" 
									showAll="yes" 
									tableDataBinding="rowData@sessionbean@servletRequest"
									blockSizeBinding="blockSize@sessionbean@servletRequest" 
									maxValueBinding="numRows@sessionbean@servletRequest"
									valueBinding="startIndex@sessionbean@servletRequest" >
						        
						            <uix:tableFormat tableBanding="rowBanding" />
						            <uix:column>
						                <uix:columnHeader>
						                    <uix:sortableHeader textBinding="SESSIONID_HEADER@uixWorkspaceObjectBundle" />
						                </uix:columnHeader>
						                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                <uix:text textBinding="SESSIONID_HEADER" />
						            </uix:column>
						            <uix:column>
						                <uix:columnHeader>
						                    <uix:sortableHeader textBinding="USER_NAME_HEADER@uixWorkspaceObjectBundle" />
						                </uix:columnHeader>
						                <uix:columnFormat columnDataFormat="textFormat" width="30%" />
						                <uix:text textBinding="USER_NAME_HEADER" />
						            </uix:column>
						            <uix:column>
						                <uix:columnHeader>
						                    <uix:sortableHeader textBinding="STATUS_HEADER@uixWorkspaceObjectBundle" />
						                </uix:columnHeader>
						                <uix:columnFormat columnDataFormat="textFormat" width="40%" />
						                <uix:text textBinding="STATUS_HEADER" />
						            </uix:column>
						            </uix:table>
						    </uix:contents>
						</uix:header>
                    </uix:contents>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
