<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<%-- Page:        workspaceSavepoints.jsp
  -- Created:     vimgupta 
  -- Controller:  db/adm/workspacemgr/WorkspaceController.java (oracle.sysman.db.adm.workspacemgr)
  -- Main Bean: oracle.sysman.emo.adm.workspacemgr.WorkspaceObject
  -- Description: This is the central screen to manage Savepoint functionality.
  --%>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext" />
    <db:script src="/database/utils.js" />
    <uix:bundle name="uixDBObjectBundle" class="oracle.sysman.db.rsc.DBObjectMsg" />
    <uix:bundle name="uixDBMsgBundle"  class="oracle.sysman.db.rsc.inst.DBMsg"/>
    <uix:bundle name="uixWorkspaceObjectBundle" class="oracle.sysman.db.rsc.workspacemgr.WorkspaceObjectMsg" />
    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="title@objectBean@servletRequest" />
        </uix:metaContainer>
        <uix:body>
            <db:form name="workspaceSavepoints" method="post" destination="/console/database/workspacemgr/workspace" copyParams="target,type,otype,oname,objectType">
                <uix:formValue name="pageName" value="/database/workspace/workspaceSavepoints" />
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%@ include file="/database/global.jspf" %>
                    <oem:messageBox messageType="info" errorTableBinding="info@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />
                    <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest" titleTextKey="titleText" mainTextKey="mainText" />

                    <uix:styledText styleClass="OraInstructionText" textBinding="SAVEPOINT_INFO@uixWorkspaceObjectBundle"  />
                  	<uix:spacer width="10" height="10"/>
                    
                    <uix:contents>
                        <uix:spacer height="10" width="10" />
                        <uix:labeledFieldLayout >
						    <uix:messagePrompt promptBinding="WORKSPACE_HEADER@uixWorkspaceObjectBundle" />
						    <uix:styledText styleClass="OraDataText" textBinding="workspaceName@objectBean@servletRequest" />
						</uix:labeledFieldLayout>
						
                        <uix:spacer height="10" width="10" />
						 
						
						 <uix:header textBinding="SEARCH@uixDBObjectBundle" styleClass="OraInstructionText"/>
						  <uix:tableLayout cellSpacing="5">
						
                            <uix:rowLayout>
                              <uix:spacer width="10"/>
                              <uix:styledText styleClass="OraPromptText"
                                              textBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"/>
                              <uix:messageChoice name="selectedSearchBy"
                                          shortDescBinding="SEARCH_BY@uixDBObjectBundle@servletRequest"
                                          selectedValueBinding="searchOption@objectBean@servletRequest">
                                <uix:contents>
                                  <uix:option textBinding="OWNER_HEADER@uixWorkspaceObjectBundle" value="owner"/>
                                  <uix:option textBinding="SAVEPOINT_NAME@uixWorkspaceObjectBundle" value="savepoint"/>
                                  <uix:option textBinding="POSITION_HEADER@uixWorkspaceObjectBundle" value="position"/>
                                </uix:contents>
                              </uix:messageChoice>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:spacer width="10"/>
                              <uix:styledText styleClass="OraPromptText"  id="searchString" labeledNodeId="searchString"
                                              textBinding="NAME_HEADER@uixWorkspaceObjectBundle"/>
                              <uix:messageTextInput name="searchString" id="searchString" shortDescBinding="NAME_HEADER@uixWorkspaceObjectBundle" labeledNodeId="searchString" textBinding="searchString@objectBean@servletRequest"/>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:spacer width="10"/>
                              <uix:spacer width="10"/>
                              <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest"
                                                name="event"
                                                value="searchsavepoint"/>
                            </uix:rowLayout>
                           
  </uix:tableLayout> 
  

                      
                        <uix:tableLayout width="100%">
						    <uix:contents>
						        <uix:rowLayout hAlign="right">
						            <uix:contents>
											<uix:submitButton textBinding="CREATE@uixDBObjectBundle" name="event" value="WORKSPACE_CREATE_SAVEPOINT_ACTION" shortDescBinding="CREATE@uixDBObjectBundle"/>
						            </uix:contents>
						        </uix:rowLayout>
						        <uix:rowLayout >
						            <uix:contents>
										<uix:spacer width="10" height="10"/>
						            </uix:contents>
						        </uix:rowLayout>
                                <uix:rowLayout>
                                    <uix:contents>
		                                <uix:table name="savepointsListTable"
										alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle" 
										summaryBinding="WORKSPACE_SAVEPOINT_HDR@uixWorkspaceObjectBundle"
										formSubmitted="true" 
										width="100%" 
										tableDataBinding="rowData@savepointbean@servletRequest"
										blockSizeBinding="blockSize@savepointbean@servletRequest" 
							            maxValueBinding="numRows@savepointbean@servletRequest"
				            			valueBinding="startIndex@savepointbean@servletRequest" >
										    <uix:tableFormat tableBanding="rowBanding" />
										    <uix:tableSelection>
						                       <uix:singleSelection
											  
selectedIndexBinding="selectedIndexUI@savepointbean@servletRequest" shortDescBinding="WORKSPACE_SAVEPOINT_HDR@uixWorkspaceObjectBundle">
							                         <uix:contents>
			                                           <uix:submitButton textBinding="DELETE_SAVEPOINT_ACTION@uixWorkspaceObjectBundle" name="event" value="DELETE_SAVEPOINT_ACTION" shortDescBinding="DELETE_SAVEPOINT_ACTION@uixWorkspaceObjectBundle"/>	                                           
													   <uix:spacer width="5" height="5"/>
			                                           <uix:submitButton textBinding="ROLLBACK_WORKSPACE_HEADER@uixWorkspaceObjectBundle" value="ROLLBACK_TO_SAVEPOINT_ACTION" name="event" shortDescBinding="ROLLBACK_WORKSPACE_HEADER@uixWorkspaceObjectBundle"/>	                                           
							                         </uix:contents>
							                       </uix:singleSelection>
								            </uix:tableSelection>
										    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="NAME_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiNameSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="objectNameFormat" width="15%"/>
								        <uix:text textBinding="NAME_HEADER" />
								    </uix:column>
									
									 <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="ROLLBACKTO_HDR@uixWorkspaceObjectBundle" sortableBinding="uiTimeCreatedSort@savepointbean@servletRequest"/>
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
								            <uix:text textBinding="ROLLBACKTO_HDR" />
								    </uix:column>
								    
								    
								     <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="REMOVABLE_HDR@uixWorkspaceObjectBundle" sortableBinding="uiTimeCreatedSort@savepointbean@servletRequest"/>
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
								            <uix:text textBinding="REMOVABLE_HDR" />
								    </uix:column>
									
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="DESCRIPTION_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiDescriptionSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								        <uix:text textBinding="DESCRIPTION_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="TYPE_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTypeSort@savepointbean@servletRequest" />
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
								        <uix:text textBinding="TYPE_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="OWNER_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiOwnerSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="textFormat" width="10%" />
								        <uix:text textBinding="OWNER_HEADER" />
								    </uix:column>
								    <uix:column>
								        <uix:columnHeader>
								            <uix:sortableHeader textBinding="POSITION_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiPositionSort@savepointbean@servletRequest"/>
								        </uix:columnHeader>
								        <uix:columnFormat columnDataFormat="numberFormat" width="5%" />
								        <uix:text textBinding="POSITION_HEADER" />
								    </uix:column>
								    <uix:column>
								            <uix:columnHeader>
								                <uix:sortableHeader textBinding="TIME_CREATED_HEADER@uixWorkspaceObjectBundle" sortableBinding="uiTimeCreatedSort@savepointbean@servletRequest"/>
								            </uix:columnHeader>
								            <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
								            <uix:text textBinding="TIME_CREATED_HEADER" />
								    </uix:column>
								    
								    
								    
										</uix:table>
                                    </uix:contents>
                                </uix:rowLayout>
                            </uix:contents>
                        </uix:tableLayout>
                    </uix:contents>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
