<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        createPage.jsp
  -- Controller:  db/adm/xdb/XDBACLController.java
  --
  -- Description: Create General Page for XDB ACL Create
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.acls.XDBACEUIXConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
        
        <uix:body>
            <%-- Table Data Binding --%>
            <uix:dataScope currentDataBinding="aceBean@servletRequest">
            
                <%-- HTML form --%>
                <db:form    name="aclCreate"
                            method="post"
                            destination="/console/database/xdb/XDBACL"
                            copyParams="target,type,otype,cancelURL">
                    <uix:formValue name="pageName" value="<%= XDBConstants.XDBACLS_CREATE_PAGE %>" />
                    <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                        <%--- Include global tabs --%>
                        <%@ include file="/database/global.jspf" %>        

                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>   

                        <%-- Contents --%>
                        <uix:header textBinding="GENERAL@dbMsgs">
                            <uix:tableLayout cellSpacing="10">
                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                        <uix:messagePrompt      promptBinding="OWNER@dbMsgs"
                                                                shortDescBinding="OWNER@dbMsgs"
                                                                required="yes"
								labeledNodeId="schemaName"/>
                                    </uix:cellFormat>

                                    <uix:cellFormat hAlign="left">
                                        <uix:messageLovField    name="schemaName"
                                                                id="schemaName"
                                                                shortDescBinding="OWNER@dbMsgs"
                                                                searchDescBinding="OWNER@dbMsgs"
                                                                textBinding="schemaName@objectBean@servletRequest"
                                                                onClick="startLov('schemaName', 'ListSchema')"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>

                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                        <uix:messagePrompt      promptBinding="XDBRES_ACL_FOLDER@xdbMsgs"
                                                                shortDescBinding="XDBRES_ACL_FOLDER@xdbMsgs"
                                                                required="yes"
								labeledNodeId="ACLFileLocation"/>
                                    </uix:cellFormat>
                                
                                    <uix:cellFormat hAlign="left">
                                        <uix:messageLovField    name="ACLFileLocation"
                                                                id="ACLFileLocation"
                                                                shortDescBinding="XDBRES_ACL_FOLDER@xdbMsgs"
                                                                searchDescBinding="XDBRES_ACL_FOLDER@xdbMsgs"
                                                                textBinding="ACLFileLocation@objectBean@servletRequest"
                                                                onClick="preserveCase();startLov('ACLFileLocation','ListXDBResourceFolder')"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                                    
                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                        <uix:messagePrompt      promptBinding="XDBRES_ACL_FILENAME@xdbMsgs"
                                                                shortDescBinding="XDBRES_ACL_FILENAME@xdbMsgs"
                                                                required="yes"/>
                                    </uix:cellFormat>
                                
                                    <uix:cellFormat hAlign="left">
                                        <uix:messageTextInput   name="ACLFileName"
                                                                id="ACLFileName"
                                                                shortDescBinding="XDBRES_ACL_FILENAME@xdbMsgs"
                                                                textBinding="ACLFileName@objectBean@servletRequest"/>
    		  	                <uix:styledText styleClass="OraInlineInfoText"
                                               textBinding="XDBRES_ACL_FILENAME_HINT@xdbMsgs"/>								
                                    </uix:cellFormat>
                                </uix:rowLayout>    
                                
                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                        <uix:messagePrompt      promptBinding="XDBRES_ACL_DESCRIPTION@xdbMsgs"
                                                                shortDescBinding="XDBRES_ACL_DESCRIPTION@xdbMsgs"/>
                                    </uix:cellFormat>

                                    <uix:cellFormat hAlign="left">
                                        <uix:messageTextInput   name="ACLDescription"
                                                                id="ACLDescription"
                                                                shortDescBinding="XDBRES_ACL_DESCRIPTION@xdbMsgs"
                                                                textBinding="ACLDescription@objectBean@servletRequest"/>                                                        
                                    </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                        </uix:header>

                        <uix:header textBinding="XDBRES_ACL_ACE_PLURAL@xdbMsgs">
                            <uix:table  name="aceDetailsTable"
                                        blockSizeBinding="<%= XDBACEUIXConstants.XDBACE_TABLE_BLOCKSIZEBINDING %>"
                                        formSubmitted="true"
                                        width="70%"
                                        tableDataBinding="rowData"
                                        valueBinding="startIndex"
                                        maxValueBinding="<%= XDBACEUIXConstants.XDBACE_NUM_ROWS_ATTR %>"
                                        summaryBinding="<%= XDBACEUIXConstants.XDBACE_TABLE_SUMMARYBINDING %>">
                                <%-- Principal column --%>
                                <uix:column>
                                    <uix:columnHeader>
                                        <uix:sortableHeader textBinding="XDBRES_ACL_PRINCIPAL@xdbMsgs"/>
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="textFormat" width="50%"/>
                                    <uix:messageLovField    name="principal"
                                                            textBinding="<%= XDBACEUIXConstants.XDBACE_PRINCIPAL_COL %>"
                                                            onClickBinding="<%= XDBACEUIXConstants.XDBACE_PRINCIPAL_LOV_LINK %>"
                                                            shortDescBinding="XDBRES_ACL_PRINCIPAL@xdbMsgs"
                                                            searchDescBinding="XDBRES_ACL_PRINCIPAL@xdbMsgs"/>
                                </uix:column>
                                
                                <%-- Privilege column --%>
                                <uix:column>
                                    <uix:columnHeader>
                                        <uix:sortableHeader textBinding="XDBRES_ACL_PRIVILEGE@xdbMsgs"/>
                                    </uix:columnHeader>                                
                                    <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                    <uix:messageChoice  name="privilege"
                                                        selectedValueBinding="<%= XDBACEUIXConstants.XDBACE_PRIVILEGE_COL %>"
                                                        shortDescBinding="XDBRES_ACL_PRIVILEGE@xdbMsgs">                                                       
                                        <%-- Keep value the same as Resource ID, it is easy to look up --%>
                                        <uix:option text="all"
                                                    value="XDBRES_ACL_ALL"/>
                                        <uix:option text="dav:all"
                                                    value="XDBRES_ACL_DAVALL"/>
                                        <uix:option text="dav:read"
                                                    value="XDBRES_ACL_DAVREAD"/>
                                        <uix:option text="dav:write"
                                                    value="XDBRES_ACL_DAVWRITE"/>
                                        <uix:option text="dav:read-acl"
                                                    value="XDBRES_ACL_DAVREADACL"/>
                                        <uix:option text="dav:write-acl"
                                                    value="XDBRES_ACL_DAVWRITEACL"/>
                                        <uix:option text="read-properties"
                                                    value="XDBRES_ACL_READPROPS"/>
                                        <uix:option text="read-contents"
                                                    value="XDBRES_ACL_READCONTENTS"/>
                                        <uix:option text="resolve"
                                                    value="XDBRES_ACL_RESOLVE"/> 
                                        <uix:option text="update"
                                                    value="XDBRES_ACL_UPDATE"/>
                                        <uix:option text="link"
                                                    value="XDBRES_ACL_LINK"/>
                                        <uix:option text="unlink"
                                                    value="XDBRES_ACL_UNLINK"/>
                                        <uix:option text="link-to"
                                                    value="XDBRES_ACL_LINKTO"/>
                                        <uix:option text="unlink-from"
                                                    value="XDBRES_ACL_UNLINKFROM"/>
                                        <uix:option text="read-acl"
                                                    value="XDBRES_ACL_READACL"/>
                                        <uix:option text="write-acl-ref"
                                                    value="XDBRES_ACL_WRITEACL_REF"/>                                                    
                                        <uix:option text="update-acl"
                                                    value="XDBRES_ACL_UPDATEACL"/>                                                    
                                        <uix:option text="dav:lock"
                                                    value="XDBRES_ACL_DAVLOCK"/>                                                    
                                        <uix:option text="dav:unlock"
                                                    value="XDBRES_ACL_DAVUNLOCK"/>                                                                                                        
                                    </uix:messageChoice>
                                </uix:column>
                                
                                <%-- Granted column --%>
                                <uix:column>
                                    <uix:columnHeader>
                                        <uix:sortableHeader textBinding="XDBRES_ACL_GRANTED@xdbMsgs"/>
                                    </uix:columnHeader>
                                    <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                                    <uix:messageCheckBox name="granted" value="true" 
                                                  checkedBinding="<%= XDBACEUIXConstants.XDBACE_GRANTED_COL %>"
                                                  shortDescBinding="XDBRES_ACL_GRANTED@xdbMsgs"/>
                                </uix:column>
                                
                                <%-- Remove column --%>
                                <uix:column>
                                    <uix:columnHeader>
                                        <uix:sortableHeader textBinding="REMOVE@dbMsgs"/>
                                    </uix:columnHeader>                                
                                    <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                                    <uix:image sourceBinding="<%= XDBACEUIXConstants.XDBACE_REMOVE_COL %>"
                                                onClickBinding="<%= XDBACEUIXConstants.XDBACE_DELETEROW_CLICKBINDING %>"
                                                shortDescBinding="REMOVE@dbMsgs"/>
                                </uix:column>
                                
                                <%-- Column footer --%>
                                <uix:footer>
                                    <uix:submitButton   textBinding="XDBRES_ACL_ADD_ACES@xdbMsgs"
                                                        shortDescBinding="XDBRES_ACL_ADD_ACES@xdbMsgs"
                                                        name="event"
                                                        value="<%= XDBConstants.XDBCONFIG_ADDROWS %>"/>
                                </uix:footer>                                
                            </uix:table>
                        </uix:header>
                        <%-- Page Buttons --%>
                        <uix:pageButtons>
                            <uix:pageButtonBar>
                                <uix:submitButton textBinding="SHOWSQL@dbMsgs" 
                                                  shortDescBinding="SHOWSQL@dbMsgs"
                                                  name="event" 
                                                  value="showSql" />
                                <uix:submitButton textBinding="CANCEL@dbMsgs" 
                                                  shortDescBinding="CANCEL@dbMsgs"
                                                  name="event" 
                                                  value="cancel"/>
                                <uix:submitButton textBinding="OK@dbMsgs" 
                                                  shortDescBinding="OK@dbMsgs"
                                                  name="event" 
                                                  value="apply"/>                    
                            </uix:pageButtonBar>
                        </uix:pageButtons>

                    </uix:pageLayout>
                </db:form>
            </uix:dataScope>
        </uix:body>
    </uix:document>
</uix:renderingContext>
