<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        searchPage.jsp
  -- Controller:  db/adm/xdb/XDBACLSearchController.java
  --
  -- Description: Page for searching XDB ACLS based on ACL name, owner.  
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.acls.XDBACLSearchUIXConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>

        <%-- HTML form --%>
        <uix:body>
            <%-- Table binding --%>
            <uix:dataScope currentDataBinding="showResSearchBean@servletRequest">
                <db:form    name="searchPage" 
                            method="post" 
                            destinationBinding="<%= XDBACLSearchUIXConstants.XDBACL_PAGE_DESTINATION %>"
                            copyParams="target,type,otype,objectType">
                    <uix:formValue name="pageName" value="<%= XDBConstants.XDBACLS_SEARCH_PAGE %>"/>
                    <uix:pageLayout titleBinding="XDBACLS@dbMsgs">
                        <%--- Include global tabs --%>
                        <%@ include file="/database/global.jspf" %>        

                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  

                        <%-- Header tab for Search --%>
                        <uix:header textBinding="SEARCH@dbMsgs">
                            <%-- table layout for controls --%>
                            <uix:tableLayout cellSpacing="5">
                                <%-- First row --%>
                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="right">
                                        <uix:styledText styleClass="OraInstructionText"
                                                        textBinding="SCHEMA@dbMsgs"
							labeledNodeId="schemaName"/>                  
                                    </uix:cellFormat>       

                                    <uix:cellFormat>
                                        <uix:messageLovField    name="schemaName" 
                                                                id="schemaName"
                                                                textBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCHATTR_SCHEMANAME %>"
                                                                shortDescBinding="XDBRES_RESOURCE_OWNER@xdbMsgs"
                                                                searchDescBinding="XDBRES_RESOURCE_OWNER@xdbMsgs"
                                                                onClick="startLov('schemaName','ListSchema')"
                                                                columns="25"/>                      
                                    </uix:cellFormat>             
                                </uix:rowLayout>
                                
                                <%-- Second Row --%>
                                <uix:rowLayout>
                                    <uix:cellFormat hAlign="right"> 
                                        <uix:styledText styleClass="OraPromptText" textBinding="OBJECT_NAME_COLON@dbMsgs"/>
                                    </uix:cellFormat>

                                    <uix:cellFormat>
                                        <uix:messageTextInput   name="ACLName" 
                                                                id="ACLName"
                                                                textBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCHATTR_ACLNAME %>"
                                                                shortDescBinding="NAME@dbMsgs"
                                                                columns="25"/>                      
                                    </uix:cellFormat>                                             
                                </uix:rowLayout>
                                
                                <%-- Third row --%>
                                <uix:rowLayout>
                                    <uix:cellFormat/>
                                    <uix:cellFormat>
                                        <uix:submitButton   textBinding="GO@dbMsgs" 
                                                            onFocus="true" 
                                                            selected="true" 
                                                            name="event" 
                                                            value="search"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>
                            </uix:tableLayout>
                            
                            <%-- tip info text --%>
                            <uix:tableLayout>
                                <uix:rowLayout>
                                    <uix:cellFormat>
                                        <uix:styledText styleClass="OraInlineInfoText"
                                                        textBinding="SEARCH_HINT@dbMsgs"/>
                                    </uix:cellFormat>
                                </uix:rowLayout>                                
                            </uix:tableLayout>
                        </uix:header>
      
                        <%-- Separator b/w Search and Results --%>
                        <uix:separator>
                            <uix:spacer height="10"/>
                        </uix:separator>                        
                        
                        <%-- Results --%>
                        <%-- CREATE Button --%>
                        <uix:tableLayout cellSpacing="5">
                            <uix:rowLayout width="100%">
                                <uix:cellFormat hAlign="left" width="100%"> 
                                    <uix:styledText styleClass="OraPromptText" 
                                                    textBinding="SELECTION_MODE@dbMsgs"
                                                    labeledNodeId="selectionMode"
                                                    renderedBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCH_SHOWMULTIPLE_SEL %>"/>
                                    <uix:spacer width="5"/>
                                    <uix:choice name="selectionMode"
                                                id="selectionMode"
                                                renderedBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCH_SHOWMULTIPLE_SEL %>"
                                                selectedValueBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCH_SELECT_MODE %>"
                                                onChangeBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCH_SWITCHMODEACTION %>"
                                                shortDescBinding="SELECTION_MODE@dbMsgs">
                                        <uix:option textBinding="SINGLE@dbMsgs" value="SINGLE_SELECTION"/>
                                        <uix:option textBinding="MULTIPLE@dbMsgs" value="MULTIPLE_SELECTION"/>
                                    </uix:choice>
                                </uix:cellFormat>                                                            
                                <uix:cellFormat hAlign="right" vAlign="top" width="100%">
                                    <uix:submitButton textBinding="CREATE@dbMsgs" 
                                                        name="event" 
                                                        value="create"
                                                        shortDescBinding="CREATE@dbMsgs"/>
                                </uix:cellFormat>
                            </uix:rowLayout>                
                        </uix:tableLayout>

                        <uix:switcher childNameBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCH_ENABLEMULTIPLE_SEL %>">
                            <uix:case name="true">
                                <%-- Multiple selection Selection mode --%>
                                <uix:table  name="resSearchResultsTable"
                                            alternateTextBinding="<%= XDBACLSearchUIXConstants.XDBACL_TABLE_ALTERNATEBINDING %>"
                                            blockSizeBinding="<%= XDBACLSearchUIXConstants.XDBACL_TABLE_BLOCKSIZEBINDING %>"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="rowData"
                                            valueBinding="startIndex"
                                            maxValueBinding="<%= XDBACLSearchUIXConstants.XDBACL_NUM_ROWS_ATTR %>"
                                            summaryBinding="<%= XDBACLSearchUIXConstants.XDBACL_TABLE_SUMMARYBINDING %>">
                                    <uix:tableFormat tableBanding="rowBanding"/>

                                    <%-- Table Selection --%>
                                    <uix:tableSelection>
                                        <uix:multipleSelection 
                                                selectedBinding="<%= XDBACLSearchUIXConstants.XDBACL_SEARCH_SELECTED %>"
                                                shortDescBinding="SELECT@dbMsgs">
                                            <uix:flowLayout>
                                                <uix:submitButton textBinding="DELETE@dbMsgs" 
                                                                    name="event" 
                                                                    value="delete"
                                                                    shortDescBinding="DELETE@dbMsgs"/>
                                            </uix:flowLayout>
                                        </uix:multipleSelection>
                                    </uix:tableSelection>

                                    <%-- ACL owner column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="OWNER@dbMsgs" 
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLOWNER_SORT_COL %>" />                    
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                        <uix:styledText textBinding="<%= XDBACLSearchUIXConstants.XDBACLOWNER_COL %>" />
                                    </uix:column>

                                    <%-- ACL name column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="NAME@dbMsgs" 
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLNAME_SORT_COL %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:link   textBinding="<%= XDBACLSearchUIXConstants.XDBACLNAME_COL %>" 
                                                    destinationBinding="<%= XDBACLSearchUIXConstants.XDBACL_LINKATTR_OBJECTS %>"/>                    
                                    </uix:column>

                                    <%-- ACL created date column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CREATED@dbMsgs"
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLDATECREATED_SORT_COL %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                        <uix:styledText textBinding="<%= XDBACLSearchUIXConstants.XDBACLDATECREATED_COL %>"/>
                                    </uix:column>

                                    <%-- ACL modified date column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="LAST_MODIFIED@dbMsgs"
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLDATEMODIFIED_SORT_COL %>" />                                            
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                        <uix:styledText textBinding="<%= XDBACLSearchUIXConstants.XDBACLDATEMODIFIED_COL %>"/>
                                    </uix:column>
                                </uix:table>                            
                            </uix:case>
                            
                            <uix:case name="false">
                                <%-- Single Selection mode --%>
                                <uix:table  name="resSearchResultsTable"
                                            alternateTextBinding="<%= XDBACLSearchUIXConstants.XDBACL_TABLE_ALTERNATEBINDING %>"
                                            blockSizeBinding="<%= XDBACLSearchUIXConstants.XDBACL_TABLE_BLOCKSIZEBINDING %>"
                                            formSubmitted="true"
                                            width="100%"
                                            tableDataBinding="rowData"
                                            valueBinding="startIndex"
                                            maxValueBinding="<%= XDBACLSearchUIXConstants.XDBACL_NUM_ROWS_ATTR %>"
                                            summaryBinding="<%= XDBACLSearchUIXConstants.XDBACL_TABLE_SUMMARYBINDING %>">
                                    <uix:tableFormat tableBanding="rowBanding"/>

                                    <%-- Table Selection --%>
                                    <uix:tableSelection>
                                        <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbMsgs">
                                            <uix:flowLayout>
                                                <uix:submitButton textBinding="EDIT@dbMsgs" 
                                                                    name="event" 
                                                                    value="edit"
                                                                    shortDescBinding="EDIT@dbMsgs"/>
                                                <uix:spacer width="2"/>
                                                <uix:submitButton textBinding="VIEW_BUTTON@dbMsgs" 
                                                                    name="event" 
                                                                    value="view"
                                                                    shortDescBinding="VIEW_BUTTON@dbMsgs"/>
                                                <uix:spacer width="2"/>                                        
                                                <uix:submitButton textBinding="DELETE@dbMsgs" 
                                                                    name="event" 
                                                                    value="delete"
                                                                    shortDescBinding="DELETE@dbMsgs"/>
                                                <%--
                                                <uix:spacer width="2"/>
                                                <uix:submitButton textBinding="SHOW_DEPENDENCIES@dbMsgs" name="event" value="showDependents"/>                        
                                                --%>
                                            </uix:flowLayout>
                                        </uix:singleSelection>
                                    </uix:tableSelection>

                                    <%-- ACL owner column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="OWNER@dbMsgs" 
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLOWNER_SORT_COL %>" />                    
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                        <uix:styledText textBinding="<%= XDBACLSearchUIXConstants.XDBACLOWNER_COL %>" />
                                    </uix:column>

                                    <%-- ACL name column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="NAME@dbMsgs" 
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLNAME_SORT_COL %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                        <uix:link   textBinding="<%= XDBACLSearchUIXConstants.XDBACLNAME_COL %>" 
                                                    destinationBinding="<%= XDBACLSearchUIXConstants.XDBACL_LINKATTR_OBJECTS %>"/>                    
                                    </uix:column>

                                    <%-- ACL created date column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="CREATED@dbMsgs"
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLDATECREATED_SORT_COL %>" />
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                        <uix:styledText textBinding="<%= XDBACLSearchUIXConstants.XDBACLDATECREATED_COL %>"/>
                                    </uix:column>

                                    <%-- ACL modified date column --%>
                                    <uix:column>
                                        <uix:columnHeader>
                                            <uix:sortableHeader textBinding="LAST_MODIFIED@dbMsgs"
                                                                sortableBinding="<%= XDBACLSearchUIXConstants.XDBACLDATEMODIFIED_SORT_COL %>" />                                            
                                        </uix:columnHeader>
                                        <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                        <uix:styledText textBinding="<%= XDBACLSearchUIXConstants.XDBACLDATEMODIFIED_COL %>"/>
                                    </uix:column>
                                </uix:table>                            
                            </uix:case>
                        </uix:switcher>
                    </uix:pageLayout>
                </db:form>
            </uix:dataScope>
        </uix:body>
    </uix:document>
</uix:renderingContext>
