<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        showDepPage.jsp
  -- Controller:  db/adm/xdb/XDBACLController.java
  --
  -- Description: Show Dependent resources for a ACL
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.acls.XDBACLShowDepUIXConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
<uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
  
    <uix:body>
        <%-- Table Data Binding --%>
        <uix:dataScope currentDataBinding="showDepBean@servletRequest">  
            <%-- HTML Form --%>
            <db:form  name="aclShowDep"
                    method="post"
                    destination="/console/database/xdb/XDBACL"
                    copyParams="target,type,otype,cancelURL,sname,oname,showDepSource" >
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBACLS_SHOWDEP_PAGE %>"/> 
                <uix:pageLayout titleBinding="<%= XDBACLShowDepUIXConstants.SHOWDEP_HEADER_ATTR %>">
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  
                    
                    <%-- Contents --%>
                    <uix:table  name="aceDetailsTable"
                                blockSizeBinding="<%= XDBACLShowDepUIXConstants.SHOWDEP_TABLE_BLOCKSIZEBINDING %>"
                                formSubmitted="true"
                                width="60%"
                                tableDataBinding="rowData"
                                valueBinding="startIndex"
                                maxValueBinding="<%= XDBACLShowDepUIXConstants.SHOWDEP_NUM_ROWS_ATTR %>"
                                summaryBinding="<%= XDBACLShowDepUIXConstants.SHOWDEP_TABLE_SUMMARYBINDING %>">
                        <%-- XML Database Resource name column --%>
                        <uix:column>
                            <uix:columnHeader>
                                <uix:sortableHeader textBinding="XDBRES_NAME_COL_HEADER@xdbMsgs"/>
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat" width="70%"/>
                            <uix:styledText textBinding="<%= XDBACLShowDepUIXConstants.SHOWDEP_RESNAME_COLNAME %>"/>
                        </uix:column>

                        <%-- Type column --%>
                        <uix:column>
                            <uix:columnHeader>
                                <uix:sortableHeader textBinding="XDBRES_TYPE_COL_HEADER@xdbMsgs"/>
                            </uix:columnHeader>                                
                            <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                            <uix:styledText textBinding="<%= XDBACLShowDepUIXConstants.SHOWDEP_RESTYPE_COLNAME %>"/>
                        </uix:column>
                    </uix:table>                    
                    
                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="OK@dbMsgs" 
                                              shortDescBinding="OK@dbMsgs"
                                              name="event" 
                                              value="showDepOK"/>                    
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:dataScope>
    </uix:body>
</uix:document>
</uix:renderingContext>