<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        viewPage.jsp
  -- Controller:  db/adm/xdb/XDBACLController.java
  --
  -- Description: XDB ACL View Page
  --%>
 
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.acls.XDBACEUIXConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
<uix:bundle name="configMsgs" class="oracle.sysman.db.rsc.xdb.XDBConfigMsg"/>
<uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>

<oem:setURLEncoder id="renderingContext"/>

<uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
        <%-- Table Data Binding --%>
        <uix:dataScope currentDataBinding="aceBean@servletRequest">
    
            <%-- HTML form --%>
            <db:form  name="aclView"
                    method="post"
                    destination="/console/database/xdb/XDBACL"
                    copyParams="target,type,otype,cancelURL,oname,sname" >
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBACLS_VIEW_PAGE %>"/>
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>

                    <%-- contents --%>
                    <uix:header textBinding="GENERAL@dbMsgs">
                        <uix:labeledFieldLayout width="35%" columns="1">
                            <uix:messageStyledText  promptBinding="OWNER@dbMsgs"
                                                    styleClass="OraDataText"
                                                    shortDescBinding="OWNER@dbMsgs"
                                                    textBinding="schemaName@objectBean@servletRequest"/>

                            <uix:messageStyledText  promptBinding="XDBRES_ACL_FILENAME@xdbMsgs"
                                                    styleClass="OraDataText"
                                                    shortDescBinding="XDBRES_ACL_FILENAME@xdbMsgs"
                                                    textBinding="ACLFileName@objectBean@servletRequest"/>                                                                                                
                        </uix:labeledFieldLayout>
                    </uix:header>


                    <%-- ACE Entries --%>
                    <uix:header textBinding="XDBRES_ACL_ACE_PLURAL@xdbMsgs">
                        <uix:table  name="aceDetailsTable"
                                    blockSize="25"
                                    formSubmitted="true"
                                    width="60%"
                                    tableDataBinding="rowData"
                                    valueBinding="startIndex"
                                    maxValueBinding="<%= XDBACEUIXConstants.XDBACE_NUM_ROWS_ATTR %>"
                                    summaryBinding="<%= XDBACEUIXConstants.XDBACE_TABLE_SUMMARYBINDING %>">
                            <%-- Principal column --%>
                            <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="XDBRES_ACL_PRINCIPAL@xdbMsgs"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat" width="50%"/>
                                <uix:styledText textBinding="<%= XDBACEUIXConstants.XDBACE_PRINCIPAL_COL %>"/>
                            </uix:column>

                            <%-- Privilege column --%>
                            <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="XDBRES_ACL_PRIVILEGE@xdbMsgs"/>
                                </uix:columnHeader>                                
                                <uix:columnFormat columnDataFormat="textFormat" width="30%"/>
                                <uix:styledText textBinding="<%= XDBACEUIXConstants.XDBACE_PRIVILEGE_COL %>"/>
                            </uix:column>

                            <%-- Granted column --%>
                            <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="XDBRES_ACL_GRANTED@xdbMsgs"/>
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="iconButtonFormat" width="10%"/>
                                <uix:image sourceBinding="<%= XDBACEUIXConstants.XDBACL_GRANTED_IMAGE %>" 
                                            shortDescBinding="XDBRES_ACL_GRANTED@xdbMsgs"/>
                            </uix:column>
                        </uix:table>
                    </uix:header>

                    <%-- Related Links --%>
                    <uix:tableLayout width="30%">
                        <uix:header textBinding="XDBCONFIG_RELATEDLINKS@configMsgs">
                                <uix:link textBinding="XDBRES_ACL_SHOWDEPRESOURCES@xdbMsgs" 
                                          onClick="submitForm('aclView', true, {event:'showDependents'})"/>
                        </uix:header>
                    </uix:tableLayout>

                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton   textBinding="EDIT@dbMsgs" 
                                                shortDescBinding="EDIT@dbMsgs"
                                                name="event" 
                                                value="edit"/>
                            <uix:submitButton   textBinding="OK@dbMsgs" 
                                                shortDescBinding="OK@dbMsgs"
                                                name="event" 
                                                value="cancel"/>                    
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:dataScope>
    </uix:body>
</uix:document>
</uix:renderingContext>