<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        mainPage.jsp
  -- Controller:  db/adm/xdb/XDBConfigController.java
  --
  -- Description:  Main Page for configuring Oracle XML DB Server protocol parameters
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Note: For now the styleClass is hard-coded to x3s for *. For DBControl, this is ok and will be fixed in 
           GC once the config screen is redone. --%>
           
<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
     <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBConfigMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
  
        <%-- HTML form --%>
        <uix:body>
            <db:form  name="configMainPage" 
                method="post" 
                destination="/console/database/xdb/XDBConfig" 
                copyParams="target,type,cancelURL">
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBCONFIG_MAIN_PAGE %>"/>
                <uix:pageLayout titleBinding="XDBCONFIG_TITLE@xdbConfigResBundle@servletRequest">
        
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        
					

					<%-- Page Buttons --%>
                         
                         
                         <uix:pageButtons>
								<uix:pageButtonBar>
									<uix:button
										textBinding="CANCEL@uixDBObjectBundle@servletRequest"
										destinationBinding="cancelURL@servletRequest"
										renderedBinding="updateAllowed@objectBean@servletRequest" />
									<uix:switcher
										childNameBinding="updateAllowed@objectBean@servletRequest">
										<uix:case name="true">
											<uix:submitButton
												textBinding="OK@uixDBObjectBundle@servletRequest"
												name="event" value="apply" />
										</uix:case>
										<uix:case name="false">
											<uix:button textBinding="OK@uixDBObjectBundle@servletRequest"
												destinationBinding="cancelURL@servletRequest" />
										</uix:case>
									</uix:switcher>
								</uix:pageButtonBar>
							</uix:pageButtons>
                         
                      
                    
                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>
         
                    <%-- Page Layout Contents --%>
                    <uix:contents>
					<%-- Info Text --%>
                        <uix:tableLayout>
                            <uix:styledText textBinding="XDBCONFIG_PAGEINFO@xdbConfigResBundle@servletRequest" 
                            styleClass="OraInstructionText"/>              
                        </uix:tableLayout>
                        <uix:tableLayout cellSpacing="5">
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                        <uix:case name="true">
                                            <uix:tip>
                                                <uix:styledText textBinding="XDBCONFIG_DYNAMICPARAM_INFO@xdbConfigResBundle@servletRequest"/>
                                            </uix:tip>                                        
                                        </uix:case>
                                        <uix:case name="false">
                                            <uix:messagePrompt messageType="warning" promptBinding="XDBCONFIG_NOUPDATE_MSG@xdbConfigResBundle@servletRequest"/>
                                        </uix:case>
                                    </uix:switcher>
                                </uix:cellFormat>
                                <uix:cellFormat>
                                </uix:cellFormat>                
                            </uix:rowLayout>
                        </uix:tableLayout>
            
                        <%-- Common to All Protocols data --%>
                        <uix:header textBinding="XDBCONFIG_COMMONPROTOCOLS_HDR@xdbConfigResBundle@servletRequest">
                            <%-- Common parameters --%>
                            <uix:tableLayout cellSpacing="5">
                                <%-- first row of parameters --%>
                                <%-- Because of the way switcher works, the whole rowLayout has to be included under uix:case --%>
                                <%-- Also labeledNodeId attribute should be specified for read-write scenario alone --%>
                                <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSION_POOL_SIZE@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="commonSessionPoolSize"/>
                                            </uix:cellFormat>
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>
                                            </uix:cellFormat>                                                              
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="commonSessionPoolSize" 
                                                name="commonSessionPoolSize" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_SESSION_POOL_SIZE@xdbConfigResBundle@servletRequest"
                                                textBinding="commonSessionPoolSize@objectBean@servletRequest"
                                                tipBinding="XDBCONFIG_SESSPOOLSIZE_INFO@xdbConfigResBundle@servletRequest"/>                                            
                                            </uix:cellFormat>
                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>                                    
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_CALLTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="commonCallTimeout"/>
                                            </uix:cellFormat>                  
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                     
                                            </uix:cellFormat>                                                                                    
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="commonCallTimeout" 
                                                name="commonCallTimeout" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_CALLTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="commonCallTimeout@objectBean@servletRequest"/>                                                          		
                                            </uix:cellFormat>                                            
                                        </uix:rowLayout>
                                    </uix:case>
                                        
                                    <uix:case name="false">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSION_POOL_SIZE@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>
                                            </uix:cellFormat>                                                              
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="commonSessionPoolSize" 
                                                shortDescBinding="XDBCONFIG_SESSION_POOL_SIZE@xdbConfigResBundle@servletRequest"
                                                textBinding="commonSessionPoolSize@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                            
                                            </uix:cellFormat>                                                    
                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>                                    
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_CALLTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>                  
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                     
                                            </uix:cellFormat>                                                                                    
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="commonCallTimeout" 
                                                shortDescBinding="XDBCONFIG_CALLTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="commonCallTimeout@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                                          		                                    		
                                            </uix:cellFormat>
                                        </uix:rowLayout>
                                    </uix:case>
                                </uix:switcher>                                                                        

                                <%-- second row of parameters --%>                
                                <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                        
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="commonSessionTimeout"/>
                                            </uix:cellFormat>
                  
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                     
                                            </uix:cellFormat>                
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageTextInput id="commonSessionTimeout" 
                                                name="commonSessionTimeout" 
                                                columns="25"
                                                shortDescBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="commonSessionTimeout@objectBean@servletRequest"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat>
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                    		
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_DEFLOCKTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="commonLockTimeout"/>
                                            </uix:cellFormat>                                    
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                     
                                            </uix:cellFormat>                                            
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="commonLockTimeout" 
                                                name="commonLockTimeout" 
                                                columns="25"
                                                shortDescBinding="XDBCONFIG_DEFLOCKTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="commonLockTimeout@objectBean@servletRequest"/>                                                          
                                            </uix:cellFormat>
                                            
                                        </uix:rowLayout>             
                                    </uix:case>
                                    <uix:case name="false">
                                        <uix:rowLayout>
                                        
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                     
                                            </uix:cellFormat>                
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="commonSessionTimeout" 
                                                shortDescBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="commonSessionTimeout@objectBean@servletRequest"
                                                styleClass="OraDataText"/>
                                            </uix:cellFormat>		
                                            
                                            <uix:cellFormat>
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_DEFLOCKTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>                                    
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                     
                                            </uix:cellFormat>                                            
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="commonLockTimeout" 
                                                shortDescBinding="XDBCONFIG_DEFLOCKTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="commonLockTimeout@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                                         
                                            </uix:cellFormat>
                                            
                                        </uix:rowLayout>                                                 
                                    </uix:case>
                                </uix:switcher>                                                                                                                                                

                                <%-- tip info 1st row for second row of parameters --%>
                                <uix:rowLayout>
                                    <uix:cellFormat>
                                    </uix:cellFormat>                
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>      
                                    <uix:cellFormat>
                                    </uix:cellFormat>                  
                                </uix:rowLayout>

                                <%-- tip info 2nd row for second row of parameters --%>
                                <uix:rowLayout>
                                    <uix:cellFormat>
                                    </uix:cellFormat>                
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>  
                                    <uix:cellFormat>
                                    </uix:cellFormat>                                  
                                </uix:rowLayout>
                
                            </uix:tableLayout>              
                        </uix:header>

                        <%-- FTP Protocol data --%>
                        <uix:header textBinding="XDBCONFIG_FTPPROTOCOL_HDR@xdbConfigResBundle@servletRequest">
                            <uix:tableLayout cellSpacing="5">
                                <%-- first row of parameters --%>
                                <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                        
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="ftpSessionTimeout"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageTextInput id="ftpSessionTimeout" 
                                                name="ftpSessionTimeout" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="ftpSessionTimeout@objectBean@servletRequest"/>                                    		
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_FTPPORT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="ftpPort"/>
                                            </uix:cellFormat>                  
                                            
                                            <%-- Bug fix for 4052163 - ftp Port can be zero --%>
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                rendered="false"/>                    
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="ftpPort" 
                                                name="ftpPort" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_FTPPORT@xdbConfigResBundle@servletRequest"
                                                textBinding="ftpPort@objectBean@servletRequest"/>                                                          		
                                            </uix:cellFormat>
                                            
                                        </uix:rowLayout>                                                
                                    </uix:case>
                                    
                                    <uix:case name="false">                                    		
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageStyledText id="ftpSessionTimeout" 
                                                shortDescBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="ftpSessionTimeout@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                    		
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_FTPPORT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                renderedBinding="updateAllowed@objectBean@servletRequest"/>                    
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="ftpPort" 
                                                shortDescBinding="XDBCONFIG_FTPPORT@xdbConfigResBundle@servletRequest"
                                                textBinding="ftpPort@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                                          		
                                            </uix:cellFormat>
                                            
                                        </uix:rowLayout>                                                
                                    </uix:case>
                                </uix:switcher>                                    
                            </uix:tableLayout>                
                        </uix:header>

                        <%-- Http Protocol data --%>
                        <uix:header textBinding="XDBCONFIG_HTTPPROTOCOL_HDR@xdbConfigResBundle@servletRequest">
                            <%-- Parameters --%>
                            <uix:tableLayout cellSpacing="5">
                                <%-- First row of parameters --%>
                                <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">                                        
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SERVERNAME@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="httpServerName"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat>                      
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageTextInput id="httpServerName" 
                                                name="httpServerName" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_SERVERNAME@xdbConfigResBundle@servletRequest"
                                                textBinding="httpServerName@objectBean@servletRequest"/>                                    		
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="httpSessionTimeout"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top">
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="httpSessionTimeout" 
                                                name="httpSessionTimeout" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="httpSessionTimeout@objectBean@servletRequest"/>                                    		
                                            </uix:cellFormat>
                                            
                                        </uix:rowLayout>                                    
                                    </uix:case>
                                    
                                    <uix:case name="false">
                                        <uix:rowLayout>
                                        
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SERVERNAME@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat>                      
                                            </uix:cellFormat>                  
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageStyledText id="httpServerName" 
                                                shortDescBinding="XDBCONFIG_SERVERNAME@xdbConfigResBundle@servletRequest"
                                                textBinding="httpServerName@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                    		
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top">
                                            </uix:cellFormat>                  

                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageStyledText id="httpSessionTimeout" 
                                                shortDescBinding="XDBCONFIG_SESSIONTIMEOUT@xdbConfigResBundle@servletRequest"
                                                textBinding="httpSessionTimeout@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                    		
                                            </uix:cellFormat>

                                        </uix:rowLayout>
                                    </uix:case>                                
                                </uix:switcher>                                    
                                    
                                <%-- Second row of parameters --%>                                
                                <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_MAXREQBODY@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="httpMaxReqBody"/>
                                            </uix:cellFormat>
                                    
                                            <uix:cellFormat vAlign="top">
                                            </uix:cellFormat>                  
                                    
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageTextInput id="httpMaxReqBody" 
                                                name="httpMaxReqBody" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_MAXREQBODY@xdbConfigResBundle@servletRequest"
                                                textBinding="httpMaxReqBody@objectBean@servletRequest"/>                                    		
                                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="XDBCONFIG_MAXREQBODY_INFO@xdbConfigResBundle@servletRequest" renderedBinding="updateAllowed@objectBean@servletRequest"/> 
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_MAXHDRSIZE@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="httpMaxHdrSize"/>
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat> 
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="httpMaxHdrSize" 
                                                name="httpMaxHdrSize" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_MAXHDRSIZE@xdbConfigResBundle@servletRequest"
                                                textBinding="httpMaxHdrSize@objectBean@servletRequest"/>                                                          		
                                            </uix:cellFormat>
                                        </uix:rowLayout>                                                
                                    </uix:case>
                                    
                                    <uix:case name="false">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_MAXREQBODY@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>
                                    
                                            <uix:cellFormat vAlign="top">
                                            </uix:cellFormat>                  
                                    
                                            <uix:cellFormat vAlign="top" hAlign="left">                                            
                                                <uix:messageStyledText id="httpMaxReqBody" 
                                                shortDescBinding="XDBCONFIG_MAXREQBODY@xdbConfigResBundle@servletRequest"
                                                textBinding="httpMaxReqBody@objectBean@servletRequest"
                                                styleClass="OraDataText"/> 
                                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="XDBCONFIG_MAXREQBODY_INFO@xdbConfigResBundle@servletRequest" renderedBinding="updateAllowed@objectBean@servletRequest"/> 
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top">
                                                <uix:spacer width="10" height="10"/>
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_MAXHDRSIZE@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>

                                            <uix:cellFormat> 
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="httpMaxHdrSize" 
                                                shortDescBinding="XDBCONFIG_MAXHDRSIZE@xdbConfigResBundle@servletRequest"
                                                textBinding="httpMaxHdrSize@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                                          		
                                            </uix:cellFormat>
                                        
                                        </uix:rowLayout>                                                
                                    </uix:case>
                                </uix:switcher>    
                                
                                <%-- Third row of parameters --%>
                                <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                    <uix:case name="true">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_HTTPPORT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"
                                                labeledNodeId="httpPort"/>
                                            </uix:cellFormat>
                                            
                                            <%-- HTTP Port can be zero --%>
                                            <uix:cellFormat vAlign="top" hAlign="left">                                        
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                rendered="false"/>                                      
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageTextInput id="httpPort" 
                                                name="httpPort" 
                                                columns="25"                                          
                                                shortDescBinding="XDBCONFIG_HTTPPORT@xdbConfigResBundle@servletRequest"
                                                textBinding="httpPort@objectBean@servletRequest"/>                                                          		
                                            </uix:cellFormat>                                        

                                            <uix:cellFormat> 
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:switcher childNameBinding="ifVersion10GR2OrHigher@objectBean@servletRequest"> 
                                                    <uix:case name="true">                                            
                                                        <uix:styledText textBinding="XDBCONFIG_HTTPPROTOCOL@xdbConfigResBundle@servletRequest"
                                                        styleClass="OraInstructionText"
                                                        labeledNodeId="httpProtocol"/>
                                                    </uix:case>
                                                </uix:switcher>
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top">
                                            </uix:cellFormat> 

                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:switcher childNameBinding="ifVersion10GR2OrHigher@objectBean@servletRequest"> 
                                                    <uix:case name="true">                                                                                        
                                                        <uix:messageTextInput id="httpProtocol" 
                                                        name="httpProtocol" 
                                                        columns="25"                                          
                                                        shortDescBinding="XDBCONFIG_HTTPPROTOCOL@xdbConfigResBundle@servletRequest"
                                                        textBinding="httpProtocol@objectBean@servletRequest"/>
                                                    </uix:case>
                                                </uix:switcher>                                                
                                            </uix:cellFormat> 

                                        </uix:rowLayout>                                                
                                    </uix:case>
                                            
                                    <uix:case name="false">
                                        <uix:rowLayout>
                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:styledText textBinding="XDBCONFIG_HTTPPORT@xdbConfigResBundle@servletRequest"
                                                styleClass="OraInstructionText"/>
                                            </uix:cellFormat>
                                            
                                            <%-- HTTP Port can be zero --%>
                                            <uix:cellFormat vAlign="top" hAlign="left">                                        
                                                <uix:styledText styleClass="x3s" 
                                                textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                rendered="false"/>                                      
                                            </uix:cellFormat>
                                            
                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:messageStyledText id="httpPort" 
                                                shortDescBinding="XDBCONFIG_HTTPPORT@xdbConfigResBundle@servletRequest"
                                                textBinding="httpPort@objectBean@servletRequest"
                                                styleClass="OraDataText"/>                                                          		
                                            </uix:cellFormat>
                                            <uix:cellFormat> 
                                            </uix:cellFormat>


                                            <uix:cellFormat vAlign="top" hAlign="right">
                                                <uix:switcher childNameBinding="ifVersion10GR2OrHigher@objectBean@servletRequest"> 
                                                    <uix:case name="true">                                            
                                                        <uix:styledText textBinding="XDBCONFIG_HTTPPROTOCOL@xdbConfigResBundle@servletRequest"
                                                        styleClass="OraInstructionText"/>
                                                    </uix:case>
                                                </uix:switcher>
                                            </uix:cellFormat>

                                            <uix:cellFormat vAlign="top">
                                            </uix:cellFormat> 

                                            <uix:cellFormat vAlign="top" hAlign="left">
                                                <uix:switcher childNameBinding="ifVersion10GR2OrHigher@objectBean@servletRequest"> 
                                                    <uix:case name="true">                                            
                                                        <uix:messageStyledText id="httpProtocol" 
                                                        shortDescBinding="XDBCONFIG_HTTPPROTOCOL@xdbConfigResBundle@servletRequest"
                                                        textBinding="httpProtocol@objectBean@servletRequest"
                                                        styleClass="OraDataText"/>                                                          		
                                                    </uix:case>
                                                </uix:switcher>
                                            </uix:cellFormat>

                                        </uix:rowLayout>                                                
                                    </uix:case>
                                </uix:switcher>                                    
                                <%-- Third row of parameters --%>

                                <%-- Fourth row of parameters --%>
                                <uix:switcher childNameBinding="ifVersion10GR2OrHigher@objectBean@servletRequest"> 
                                    <uix:case name="true">
                                        <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                            <uix:case name="true">
                                                <uix:rowLayout>
                                                    <uix:cellFormat vAlign="top" hAlign="right">
                                                        <uix:styledText textBinding="XDBCONFIG_HTTP2PORT@xdbConfigResBundle@servletRequest"
                                                        styleClass="OraInstructionText"
                                                        labeledNodeId="http2Port"/>
                                                    </uix:cellFormat>
                                            
                                                    <%-- HTTP2 Port can be zero --%>
                                                    <uix:cellFormat vAlign="top" hAlign="left">                                        
                                                        <uix:styledText styleClass="x3s" 
                                                        textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                        rendered="false"/>                                      
                                                    </uix:cellFormat>
                                            
                                                    <uix:cellFormat vAlign="top" hAlign="left">
                                                        <uix:messageTextInput id="http2Port" 
                                                        name="http2Port" 
                                                        columns="25"                                          
                                                        shortDescBinding="XDBCONFIG_HTTP2PORT@xdbConfigResBundle@servletRequest"
                                                        textBinding="http2Port@objectBean@servletRequest"/>                                                          		
                                                    </uix:cellFormat>                                        

                                                    <uix:cellFormat> 
                                                    </uix:cellFormat>

                                                    <uix:cellFormat vAlign="top" hAlign="right">
                                                        <uix:styledText textBinding="XDBCONFIG_HTTP2PROTOCOL@xdbConfigResBundle@servletRequest"
                                                        styleClass="OraInstructionText"
                                                        labeledNodeId="http2Protocol"/>
                                                    </uix:cellFormat>
                                            
													<uix:cellFormat vAlign="top">
                                                    </uix:cellFormat>           
                                            
                                                    <uix:cellFormat vAlign="top" hAlign="left">
                                                        <uix:messageTextInput id="http2Protocol" 
                                                        name="http2Protocol" 
                                                        columns="25"                                          
                                                        shortDescBinding="XDBCONFIG_HTTP2PROTOCOL@xdbConfigResBundle@servletRequest"
                                                        textBinding="http2Protocol@objectBean@servletRequest"/>                                                          		
                                                    </uix:cellFormat> 
                                                </uix:rowLayout>                                            
                                                </uix:case>

											

											<uix:case name="false">
                                                <uix:rowLayout>
                                                    <uix:cellFormat vAlign="top" hAlign="right">
                                                        <uix:styledText textBinding="XDBCONFIG_HTTP2PORT@xdbConfigResBundle@servletRequest"
                                                        styleClass="OraInstructionText"/>
                                                    </uix:cellFormat>
                                            
                                                    <%-- HTTP2 Port can be zero --%>
                                                    <uix:cellFormat vAlign="top" hAlign="left">                                        
                                                        <uix:styledText styleClass="x3s" 
                                                        textBinding="XDBCONFIG_STATIC_PARAMTOKEN@xdbConfigResBundle@servletRequest"
                                                        rendered="false"/>                                      
                                                    </uix:cellFormat>
                                            
                                                    <uix:cellFormat vAlign="top" hAlign="left">
                                                        <uix:messageStyledText id="http2Port" 
                                                        shortDescBinding="XDBCONFIG_HTTP2PORT@xdbConfigResBundle@servletRequest"
                                                        textBinding="http2Port@objectBean@servletRequest"
                                                        styleClass="OraDataText"/>                                                          		
                                                    </uix:cellFormat>
                                                    <uix:cellFormat> 
                                                    </uix:cellFormat>

                                                    <uix:cellFormat vAlign="top" hAlign="right">
                                                        <uix:styledText textBinding="XDBCONFIG_HTTP2PROTOCOL@xdbConfigResBundle@servletRequest"
                                                        styleClass="OraInstructionText"/>
                                                    </uix:cellFormat>
                                            
                                                    <uix:cellFormat vAlign="top">
                                                    </uix:cellFormat> 
                                            
                                                    <uix:cellFormat vAlign="top" hAlign="left">
                                                        <uix:messageStyledText id="http2Protocol" 
                                                        shortDescBinding="XDBCONFIG_HTTP2PROTOCOL@xdbConfigResBundle@servletRequest"
                                                        textBinding="http2Protocol@objectBean@servletRequest"
                                                        styleClass="OraDataText"/>                                                          		
                                                    </uix:cellFormat>
                                                </uix:rowLayout>                               
                                            </uix:case>
                                        </uix:switcher>
                                    </uix:case> 
                                </uix:switcher>
								<uix:switcher
									childNameBinding="ifVersion10GR2OrHigher@objectBean@servletRequest">
									<uix:case name="true">
										<uix:switcher
											childNameBinding="updateAllowed@objectBean@servletRequest">
											<uix:case name="true">
												<uix:rowLayout>
													<uix:cellFormat />
													<uix:cellFormat />
													<uix:cellFormat>
														<uix:checkBox name="disableHttp2PortAndProtocol"
															textBinding="DISABLE_HTTP2@xdbConfigResBundle@servletRequest"
															checkedBinding="disableHttp2PortAndProtocol@objectBean@servletRequest" 
															renderedBinding="disableHttp2Required@objectBean@servletRequest"/>
													</uix:cellFormat>
													<uix:cellFormat />
													<uix:cellFormat />
													<uix:cellFormat />
													<uix:cellFormat />
												</uix:rowLayout>
											</uix:case>
										</uix:switcher>
									</uix:case>
								</uix:switcher>

                                <%-- row for displaying button for Welcome file list --%>
                                <uix:rowLayout>
                                    <uix:cellFormat>
                                    </uix:cellFormat>                
                                    <uix:cellFormat>                    
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                        <uix:submitButton textBinding="XDBCONFIG_WELCOMELIST@xdbConfigResBundle@servletRequest"
                                        name="event"
                                        value="xdbCfgWelcomeFile"/>                  
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>
                                    <uix:cellFormat>
                                    </uix:cellFormat>                                                    
                                    <uix:cellFormat>
                                    </uix:cellFormat>                                                                      
                                    <uix:cellFormat hAlign="left">
                                    </uix:cellFormat>                
                                </uix:rowLayout>                
                            </uix:tableLayout>              
                        </uix:header>
                        
                        <%-- NFS Parameters--%>
						<%-- NFS config is being enabled for 11.2--%>
						<uix:header textBinding="XDBCONFIG_NFS_PARAMETERS@xdbMsgs">
							<uix:tableLayout cellSpacing="5">
								
								<uix:rowLayout>
									<uix:cellFormat renderedBinding="NFSParameterExisits@objectBean@servletRequest">
										<uix:submitButton textBinding="DISABLE_NFS_PARAMETERS@xdbMsgs"
                                        name="event"
                                        value="<%=XDBConstants.DISABLE_NFS_PARAMETERS_EVENT%>"
                                        renderedBinding="NFSParameterExisits@objectBean@servletRequest"/>
									</uix:cellFormat>
									<uix:cellFormat renderedBinding="NFSParameterNotExisits@objectBean@servletRequest">
										<uix:submitButton textBinding="ENABLE_NFS_PARAMETERS@xdbMsgs"
                                        name="event"
                                        value="<%=XDBConstants.NFS_PARAMETERS_EVENT%>"
                                        renderedBinding="NFSParameterNotExisits@objectBean@servletRequest"/>
									</uix:cellFormat>
									<uix:cellFormat>
										<uix:submitButton textBinding="ALL_NFS_PARAMETERS@xdbMsgs"
                                        name="event"
                                        value="<%=XDBConstants.NFS_PARAMETERS_EVENT%>"
                                        renderedBinding="NFSParameterExisits@objectBean@servletRequest"/>
									</uix:cellFormat>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:cellFormat>
										<uix:messageTextInput id="NFSPort" name="NFSPort" columns="25"
											shortDescBinding="NFS_PORT_TOOL_TIP@xdbMsgs"
											textBinding="NFSPort@objectBean@servletRequest"
											disabledBinding="NFSParameterNotExisits@objectBean@servletRequest"
											promptBinding="NFS_PORT@xdbMsgs" />
									</uix:cellFormat>
								</uix:rowLayout>

							</uix:tableLayout>
						</uix:header>
						

						<%-- Related links header --%>
                        <uix:header textBinding="XDBCONFIG_RELATEDLINKS@xdbConfigResBundle@servletRequest">
                            <uix:stackLayout>
                                <uix:link textBinding="XDBCONFIG_MIMEMAPPINGS@xdbConfigResBundle@servletRequest" 
                                destinationBinding="mimeMappingURL@objectBean@servletRequest"/>
                                <uix:link textBinding="XDBCONFIG_OTHERMAPPINGS@xdbConfigResBundle@servletRequest" 
                                destinationBinding="otherMappingURL@objectBean@servletRequest"/>
                            </uix:stackLayout>
                        </uix:header>
            
                    </uix:contents>
                    
                </uix:pageLayout>               
            </db:form>
        </uix:body>
  
    </uix:document>
</uix:renderingContext>


