<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page			:	nfsParameters.jsp
  -- Controller		:	db/adm/xdb/XDBConfigController.java
  -- Author			:	Vijayan Srinivasan		
  -- Since			:  	from proj 21831
  -- Description	:  	Page for displaying nfsParameters
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBConfigMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
  
        <%-- HTML form --%>
        <uix:body>
            <db:form  name="nfsParametersPage" 
                method="post" 
                destination="/console/database/xdb/XDBConfig" 
                copyParams="target,type,cancelURL ">
                <uix:formValue name="pageName" value="<%= XDBConstants.NFS_PARAMETERS_PAGE %>"/>
                <uix:pageLayout titleBinding="XDBCONFIG_NFS_PARAMETERS@xdbMsgs">
        
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  
        
                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                            destinationBinding="cancelURL@servletRequest" 
                            renderedBinding="updateAllowed@objectBean@servletRequest"/>
                            <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                <uix:case name="true">
                                    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                                    name="event" value="apply"/>                                           
                                </uix:case>
                                <uix:case name="false">
                                    <uix:button textBinding="OK@uixDBObjectBundle@servletRequest"
                                    destinationBinding="cancelURL@servletRequest"/>                                           
                                </uix:case>
                            </uix:switcher>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
          
                    <%-- Page Layout Contents --%>
                    <uix:contents>
					
					 <uix:styledText textBinding="NFS_PARAMETERS_PAGEINFO@xdbConfigResBundle@servletRequest" 
                            styleClass="OraInstructionText"/> 


                    	<%--Text Boxs --%>
                    	<uix:header textBinding="NFS_COMMON_PARAMETERS@xdbMsgs">
							<uix:tableLayout cellSpacing="5">
								<uix:rowLayout>
									<uix:cellFormat vAlign="top" hAlign="left">
										<uix:styledText styleClass="OraInstructionText"
											textBinding="NFS_PORT@xdbMsgs"
											renderedBinding="updateAllowed@objectBean@servletRequest" />
									</uix:cellFormat>
									<uix:cellFormat>
										<uix:messageTextInput id="NFSPort" name="NFSPort" columns="25"
											shortDescBinding="NFS_PORT_TOOL_TIP@xdbMsgs"
											textBinding="NFSPort@objectBean@servletRequest" />
									</uix:cellFormat>
								</uix:rowLayout>
							</uix:tableLayout>
						</uix:header>
                    
						<%-- NFS Clients --%>
						<uix:header textBinding="NFS_CLIENTS_HEADER@xdbMsgs">
							<uix:tableLayout cellSpacing="5" width="100%">
								<uix:rowLayout>
									<uix:cellFormat>
										<uix:styledText
											textBinding="NFS_CLIENTS_INFO@xdbMsgs"
											styleClass="OraInstructionText" />
									</uix:cellFormat>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:cellFormat>
										<oem:table  name="<%= XDBConstants.NFS_CLIENTS_DS_UI %>" 
                                        beanKey="objectBean" 
                                        blockSize="5"
                                        destinationBinding="destination@objectBean@servletRequest" 
                                        formSubmitted="true"
                                        dataSourceProp="<%= XDBConstants.NFS_CLIENTS_DS_UI %>" 
                                        width="100%" 
                                        summaryBinding="RESULT@dbMsgs"
                                        alternateTextBinding="NO_CLIENTS_FOUND@xdbMsgs"
                                        >    
	                                        <uix:columnFooter>                                
	                                            <uix:addTableRow  textBinding="ADD_ROW@xdbMsgs" 
	                                            rowsBinding="addRows@objectBean@servletRequest"
	                                            renderedBinding="updateAllowed@objectBean@servletRequest"/>                                
	                                        </uix:columnFooter>                        
                                    	</oem:table>         
									</uix:cellFormat>
								</uix:rowLayout>
								
							</uix:tableLayout>
						</uix:header>
						
						<%-- NFS Export Paths --%>
						<uix:header textBinding="NFS_EXPORT_PATHS_HEADER@xdbMsgs">
							<uix:tableLayout cellSpacing="5" width="100%">
								<uix:rowLayout>
									<uix:cellFormat>
										<uix:styledText
											textBinding="NFS_EXPORT_PATHS_INFO@xdbMsgs"
											styleClass="OraInstructionText" />
									</uix:cellFormat>
								</uix:rowLayout>

								<uix:rowLayout>
									<uix:cellFormat>
										<oem:table  name="<%= XDBConstants.NFS_EXPORT_PATHS_DS_UI %>" 
                                        beanKey="objectBean" 
                                        blockSize="5"
                                        destinationBinding="destination@objectBean@servletRequest" 
                                        formSubmitted="true"
                                        dataSourceProp="<%= XDBConstants.NFS_EXPORT_PATHS_DS_UI %>" 
                                        width="100%" 
                                        summaryBinding="RESULT@dbMsgs"
                                        alternateTextBinding="NO_EXPORT_PATHS_FOUND@xdbMsgs"
                                        >    
	                                        <uix:columnFooter>                                
	                                            <uix:addTableRow  textBinding="ADD_ROW@xdbMsgs" 
	                                            rowsBinding="addRows@objectBean@servletRequest"
	                                            renderedBinding="updateAllowed@objectBean@servletRequest"/>                                
	                                        </uix:columnFooter>                        
                                    	</oem:table>         
									</uix:cellFormat>
								</uix:rowLayout>
								
							</uix:tableLayout>
						</uix:header>
						
					</uix:contents>
                </uix:pageLayout>               
            </db:form>
        </uix:body>
  
    </uix:document>
</uix:renderingContext>

