<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        mimeMapping.jsp
  -- Controller:  db/adm/xdb/XDBConfigController.java
  --
  -- Description:  Page for displaying the mime mappings
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBConfigMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
  
        <%-- HTML form --%>
        <uix:body>
            <db:form  name="otherMappingsPage" 
                method="post" 
                destination="/console/database/xdb/XDBConfig" 
                copyParams="target,type,cancelURL">
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBCONFIG_WELCOMEFILE_PAGE %>"/>
                <uix:pageLayout titleBinding="XDBCONFIG_WELCOMELIST@xdbMsgs">
        
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                    <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>   
        
                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                            destinationBinding="cancelURL@servletRequest" 
                            renderedBinding="updateAllowed@objectBean@servletRequest"/>
                            <uix:switcher childNameBinding="updateAllowed@objectBean@servletRequest">
                                <uix:case name="true">
                                    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                                    name="event" value="apply"/>                                           
                                </uix:case>
                                <uix:case name="false">
                                    <uix:button textBinding="OK@uixDBObjectBundle@servletRequest"
                                    destinationBinding="cancelURL@servletRequest"/>                                           
                                </uix:case>
                            </uix:switcher>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
          
                    <%-- Page Layout Contents --%>
                    <uix:contents>
                        <uix:tableLayout cellSpacing="5">
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:styledText textBinding="XDBCONFIG_WELCOMEFILE_INFO@xdbMsgs" styleClass="OraInstructionText"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <oem:table  name="welcomeFileUI" 
                                        beanKey="objectBean" 
                                        blockSize="10"
                                        destinationBinding="destination@objectBean@servletRequest" 
                                        formSubmitted="true"
                                        dataSourceProp="welcomeFileUI" 
                                        width="100%" 
                                        summaryBinding="RESULT@dbMsgs"
                                        alternateTextBinding="XDBCONFIG_NOFILES_FOUND@xdbMsgs">                                          
                                        <uix:columnFooter> 
                                            <uix:addTableRow textBinding="XDBCONFIG_WELCOMEFILEADD@xdbMsgs" 
                                            renderedBinding="updateAllowed@objectBean@servletRequest"/>                                
                                        </uix:columnFooter>                                                        
                                    </oem:table>                                
                                </uix:cellFormat>
                            </uix:rowLayout>
                        </uix:tableLayout>
                    </uix:contents>
                </uix:pageLayout>               
            </db:form>
        </uix:body>
  
    </uix:document>
</uix:renderingContext>

