<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        createGeneral.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: Create General Page for XDB Resource Create
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
<uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
  
  <uix:body>
      <%-- HTML Form --%>
      <db:form  name="resCreateGeneral"
                method="post"
                destination="/console/database/xdb/XDBResource"
                copyParams="target,type,otype,cancelURL"
                usesUploadBinding="fileUpload@objectBean@servletRequest">
        <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_CREATE_GENERAL_PAGE %>" />                       
        <uix:pageLayout titleBinding="header@objectBean@servletRequest">
            <%--- Include global tabs --%>
            <%@ include file="/database/global.jspf" %>        

            <%-- Information/Error display --%>
			<%@ include file="/database/informationError.jspf" %>  

			<uix:rowLayout>
				<uix:styledText textBinding="RESOURCE_CREATE_INFO@xdbMsgs"  styleClass="OraInstructionText"/>
			</uix:rowLayout>
			<uix:rowLayout>
				<uix:spacer width="10" height="10"/>
			</uix:rowLayout>
	
            <%-- Sub Tabs --%>
            <uix:subTabLayout>
                <%-- Specify tabs --%>
                <uix:subTabs>
                    <uix:subTabBar selectedIndexBinding="currentTab@objectBean@servletRequest">
                        <db:link textBinding="GENERAL@dbMsgs"
                                 shortDescBinding="GENERAL@dbMsgs"
                                 onClick="submitForm('resCreateGeneral', true, {event:'subTabResGeneral'})"
                                 copyParams="target,type,otype,cancelURL"/>
                        <db:link textBinding="XDBRES_SECURITY@xdbMsgs"
                                 shortDescBinding="XDBRES_SECURITY@xdbMsgs"
                                 onClick="submitForm('resCreateGeneral', true, {event:'subTabResSecurity'})"
                                 copyParams="target,type,otype,cancelURL"/>                             
                     </uix:subTabBar>
                </uix:subTabs>

                <%-- Specify contents --%>                                
                <uix:tableLayout cellSpacing="10">
                    <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="OWNER@dbMsgs"
                                                    shortDescBinding="OWNER@dbMsgs"
                                                    required="yes"
						    labeledNodeId="schemaName"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageLovField    name="schemaName" 
                                                    id="schemaName"
                                                    shortDescBinding="OWNER@dbMsgs"
                                                    searchDescBinding="OWNER@dbMsgs"                                                    
                                                    textBinding="schemaName@objectBean@servletRequest"
                                                    onClick="startLov('schemaName','ListSchema')"/>                        
                        </uix:cellFormat>                        
                    </uix:rowLayout>

                    <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="NAME@dbMsgs"
                                                    shortDescBinding="NAME@dbMsgs"
                                                    required="yes"/>                        
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageTextInput   name="resName" 
                                                    id="resName"
                                                    shortDescBinding="NAME@dbMsgs" 
                                                    textBinding="resName@objectBean@servletRequest"/>                        
                        </uix:cellFormat>                        
                    </uix:rowLayout>

                    <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="XDBRES_LOCATION@xdbMsgs"
                                                    shortDescBinding="XDBRES_LOCATION@xdbMsgs"
                                                    required="yes"
						    labeledNodeId="resLocation"/>                                                
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageLovField    name="resLocation" 
                                                    id="resLocation"
                                                    shortDescBinding="XDBRES_LOCATION@xdbMsgs"
                                                    searchDescBinding="XDBRES_LOCATION@xdbMsgs"
                                                    textBinding="resLocation@objectBean@servletRequest"
                                                    onClick="preserveCase();startLov('resLocation','ListXDBResourceFolder')"/>                        
                        </uix:cellFormat>                        
                    </uix:rowLayout>

                    <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="center">
                            <uix:messagePrompt      promptBinding="TYPE@dbMsgs"
                                                    shortDescBinding="TYPE@dbMsgs"
						    labeledNodeId="resType"/>                                                                        
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageChoice      name="resType"
                                                    id="resType"
                                                    shortDescBinding="TYPE@dbMsgs"
                                                    selectedValueBinding="resType@objectBean@servletRequest"
                                                    onChange="submitForm('resCreateGeneral', true, {event:'resTypeChangeEvent'})">
                                <uix:option textBinding="XDBRES_SEARCH_FILE@xdbMsgs"
                                            value="RESFILE"/>     
                                <uix:option textBinding="XDBRES_SEARCH_FOLDER@xdbMsgs"
                                            value="RESFOLDER"/>
                            </uix:messageChoice>
			    <uix:styledText styleClass="OraInlineInfoText"
                                 textBinding="XDBRES_CREATE_RES_TYPE_HINT@xdbMsgs"/>
                        </uix:cellFormat>                        
                    </uix:rowLayout>
		    
                    <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="XDBRES_SOURCE_OF_RESOURCE@xdbMsgs"
                                                    shortDescBinding="XDBRES_SOURCE_OF_RESOURCE@xdbMsgs"
                                                    renderedBinding="resFileType@objectBean@servletRequest"/>                                                                                                
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageChoice      name="resSource"
                                                    id="resTextSource"
                                                    shortDescBinding="XDBRES_SOURCE_OF_RESOURCE@xdbMsgs"
                                                    selectedValueBinding="resSource@objectBean@servletRequest"
                                                    onChange="submitForm('resCreateGeneral', true, {event:'resSourceChangeEvent'})"
                                                    renderedBinding="resFileType@objectBean@servletRequest">
                                <uix:option textBinding="XDBRES_USEFILEATURL@xdbMsgs"
                                            value="URLSOURCE"/>
                                <uix:option textBinding="XDBRES_USEFILEINFS@xdbMsgs"
                                            value="FILESOURCE"/>
                                <uix:option textBinding="XDBRES_SPECIFY_FILECONTENTS@xdbMsgs"
                                            value="USERSOURCE"/>                                            
                            </uix:messageChoice>
			    <uix:styledText styleClass="OraInlineInfoText" renderedBinding="resFileType@objectBean@servletRequest"
                                 textBinding="XDBRES_CREATE_RES_SOURCE_HINT@xdbMsgs"/>                        
                        </uix:cellFormat>                        
                    </uix:rowLayout>

                    <uix:rowLayout renderedBinding="fromURLRendered@objectBean@servletRequest">
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="XDBRES_URL@xdbMsgs"
                                                    shortDescBinding="XDBRES_URL@xdbMsgs"
                                                    renderedBinding="fromURLRendered@objectBean@servletRequest"/>                                                                                                                        
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageTextInput   name="resURL"
                                                    id="resURL"
                                                    textBinding="resURL@objectBean@servletRequest"
                                                    shortDescBinding="XDBRES_URL@xdbMsgs"
                                                    renderedBinding="fromURLRendered@objectBean@servletRequest"/>                        
                        </uix:cellFormat>                        
                    </uix:rowLayout>                    
                    
                    <uix:rowLayout renderedBinding="fromFileRendered@objectBean@servletRequest">
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="XDBRES_PATHTOFILE@xdbMsgs"
                                                    shortDescBinding="XDBRES_PATHTOFILE@xdbMsgs"
                                                    renderedBinding="fromFileRendered@objectBean@servletRequest"/>                                                                                                                                                
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
									<uix:messageFileUpload name="resFilePath" id="resFilePath"
										shortDescBinding="XDBRES_PATHTOFILE@xdbMsgs"
										renderedBinding="fromFileRendered@objectBean@servletRequest" 
										messageBinding="resFilePathFileName@objectBean@servletRequest"/>
								</uix:cellFormat>                        
                    </uix:rowLayout>                    

                    <uix:rowLayout renderedBinding="fromUserRendered@objectBean@servletRequest">
                        <uix:cellFormat hAlign="right">
                            <uix:messagePrompt      promptBinding="XDBRES_CONTENTS@xdbMsgs"
                                                    shortDescBinding="XDBRES_CONTENTS@xdbMsgs"
                                                    renderedBinding="fromUserRendered@objectBean@servletRequest"/>                                                                                                                                                
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messageTextInput   name="resContents"
                                                    id="resContents"
                                                    textBinding="resContents@objectBean@servletRequest"
                                                    shortDescBinding="XDBRES_SPECIFY_FILECONTENTS@xdbMsgs"
                                                    rows="15"
                                                    columns="100"
                                                    renderedBinding="fromUserRendered@objectBean@servletRequest"/>                                                                            
                        </uix:cellFormat>                        
                    </uix:rowLayout>                                        
                </uix:tableLayout>
            </uix:subTabLayout>
            
            <%-- Page Buttons --%>
            <uix:pageButtons>
                <uix:pageButtonBar>
                    <uix:submitButton textBinding="SHOWSQL@dbMsgs" 
                                      shortDescBinding="SHOWSQL@dbMsgs"
                                      name="event" 
                                      value="showSql" />
                    <uix:submitButton textBinding="CANCEL@dbMsgs" 
                                      shortDescBinding="CANCEL@dbMsgs"
                                      name="event" 
                                      value="cancel"/>
                    <uix:submitButton textBinding="OK@dbMsgs" 
                                      shortDescBinding="OK@dbMsgs"
                                      name="event" 
                                      value="apply"/>                    
                </uix:pageButtonBar>
            </uix:pageButtons>
        </uix:pageLayout>
      </db:form>               
  </uix:body>
</uix:document>
</uix:renderingContext>
