<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        deletePage.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: XDB Resource Delete Page
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
  
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="CONFIRMATION@dbMsgs"/>
        </uix:metaContainer>
                
      <uix:body>
        <uix:contents>
            <uix:pageLayout messageType="confirmation">

                <% if (request.getAttribute("em2goApp") != null) {%>
                    <%@ include file="/em2go/em2goGlobal.jspf" %>
                <% } else {%>
                    <%@ include file="/database/globalPopup.jspf" %>
                <%} %>

                <% if (request.getAttribute("em2goApp") != null) {%>
                <%@ include file="/em2go/em2goFooter.jspf" %>
                <%}%>  
            
                <%-- Contents --%>
                <uix:stackLayout>
                    <uix:rowLayout>
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="msgText@msgTable@servletRequest"/>                                        
                    </uix:rowLayout>
		    
                    <uix:switcher childNameBinding="resFileType@objectBean@servletRequest">
                        <uix:case name="false">
                            <uix:rowLayout>
                                <uix:styledText styleClass="OraInstructionText"
                                                textBinding="XDBRES_DELETE_FOLDER_INFO@xdbMsgs"/>
                            </uix:rowLayout>                        
                        </uix:case>
                    </uix:switcher>		                        
                </uix:stackLayout>
                
                <%-- Page Buttons --%>
                <uix:pageButtons>
                    <uix:pageButtonBar>
                        <uix:button textBinding="NO@dbMsgs" 
                                    destinationBinding="backURL@servletRequest"/>
                        <uix:button textBinding="YES@dbMsgs" 
                                    destinationBinding="deleteURL@servletRequest"/>
                    </uix:pageButtonBar>
                </uix:pageButtons>                                
            </uix:pageLayout>
        </uix:contents>
      </uix:body>
    </uix:document>
</uix:renderingContext>
