<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        displayContents.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: Display Contents of XDB Resources
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>

<script language="javascript">
function popWindow() {
    sURL = "" + document.forms[0].action +'&event=showXMLContent';
    window.open( sURL, 'xmlResContent', 'width=700, height=600, resizeable=yes, scrollbars=yes', true );    
}
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>

        <uix:body>
            <%-- HTML Form --%>
            <db:form  name="displayContents"
                method="post"
                destination="/console/database/xdb/XDBResource"
                copyParams="target,type,otype,cancelURL,oname,sname">
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_DISPCONTENTS_PAGE %>"/>
                <uix:pageLayout titleBinding="displayContentHeader@objectBean@servletRequest">
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  

                
                    <%-- Contents --%>                                        
                    <%-- Display Contents header --%>
                    <uix:switcher childNameBinding="resFileType@objectBean@servletRequest">
                        <uix:case name="true">
                            <uix:tableLayout>
                            <uix:rowLayout>
                            <uix:cellFormat hAlign="left">
                                
                                    <uix:messageTextInput   name="dispXMLContent"
                                                            id="dispXMLContent"
                                                            shortDescBinding="XDBRES_CONTENTS@xdbMsgs"
                                                            textBinding="dispXMLContent@objectBean@servletRequest"
                                                            rows="20"
                                                            columns="100"
                                                            readOnly="true"/>                                
                                
                            </uix:cellFormat>
                                </uix:rowLayout>
                                <uix:rowLayout>
                                <uix:cellFormat hAlign="left">
                                    <uix:link   textBinding="XDBRES_SHOWFORMATTED_XML@xdbMsgs"
                                                destinationBinding="showXMLLink@servletRequest"
                                                onClick='<%= "popWindow();return false;"  %>' />
                                                </uix:cellFormat>
                                     </uix:rowLayout>                       
                            </uix:tableLayout>
                        </uix:case>
                        <uix:case name="false">
                            <uix:header textBinding="XDBRES_CONTENTS_TYPEFOLDER@xdbMsgs">
                                <uix:tree id="resContentsTree" 
                                            nodesBinding="folderContents@objectBean@servletRequest"/>
                            </uix:header>
                        </uix:case>
                    </uix:switcher>
                                                            
                    <%-- UIX Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="RETURN@dbMsgs" 
                            shortDescBinding="RETURN@dbMsgs"
                            name="event" 
                            value="cancel"/>                         
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
  
    </uix:document>
</uix:renderingContext>
  