<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        displayEventListeners.jsp
  -- Controller:  db/adm/xdb/EventsController.java
  --
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.events.Constants" %>


<uix:renderingContext id="renderingContext">

    <uix:bundle name="EventsMsgs"  class="oracle.sysman.db.rsc.xdb.EventsMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
   
    <oem:setURLEncoder id="renderingContext"/>
   
    <db:script src="/database/utils.js" />

    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
        <%-- HTML form --%>
        <uix:body>
            <db:form  name="displayEventListeners" 
                method="post" 
                destination="/console/database/xdb/XDBResource"
                copyParams="target,type,otype,cancelURL,oname,sname">
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_DISPLAY_EVENT_LISTENERS_PAGE %>"/>
                <uix:pageLayout titleBinding="EVENT_LISTENERS@EventsMsgs">  
                
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>

					<uix:tableLayout>
						<uix:styledText
							textBinding="RESOURCE_EVENT_LISTENERS@EventsMsgs"
							styleClass="OraInstructionText" />
					</uix:tableLayout>

					<uix:tableLayout cellSpacing="5" width="100%">
                    	
                    	<uix:rowLayout>
                    		<oem:table name="<%=Constants.EVENTS_UI_DATASOURCE %>"
									width="100%"
									beanKey="objectBean"
									blockSize="25"
									formSubmitted="true"
									destinationBinding="destination@objectBean"
									dataSourceProp="<%=Constants.EVENTS_UI_DATASOURCE %>"
									alternateTextBinding="NO_RESOURCE_CONFIG@EventsMsgs"
									summaryBinding="EVENT_LISTENERS@EventsMsgs">
							 </oem:table>
                    	</uix:rowLayout>
                    </uix:tableLayout>
                    
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="RETURN@dbMsgs" 
                            shortDescBinding="RETURN@dbMsgs"
                            name="event" 
                            value="view"/>                         
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
