<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        editPage.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: XDB Resource Edit Page
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
<uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
  
  <uix:body>
      <%-- HTML Form --%>
      <db:form  name="resEditGeneral"
                method="post"
                destination="/console/database/xdb/XDBResource"
                copyParams="target,type,otype,cancelURL,sname,oname" >
        <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_EDIT_PAGE %>"/> 
        <uix:pageLayout titleBinding="header@objectBean@servletRequest">
            <%--- Include global tabs --%>
            <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  
   
                         
            <%-- Sub Tabs --%>
            <uix:subTabLayout>
                <%-- Specify tabs --%>
                <uix:subTabs>                    
                    <uix:subTabBar selectedIndexBinding="currentTab@objectBean@servletRequest">
                        <db:link textBinding="GENERAL@dbMsgs"
                                 shortDescBinding="GENERAL@dbMsgs"
                                 onClick="submitForm('resEditGeneral', true, {event:'subTabResGeneral'})"
                                 copyParams="target,type,otype,cancelURL,sname,oname"/>
                        <db:link textBinding="XDBRES_SECURITY@xdbMsgs"
                                 shortDescBinding="XDBRES_SECURITY@xdbMsgs"
                                 onClick="submitForm('resEditGeneral', true, {event:'subTabResSecurity'})"
                                 copyParams="target,type,otype,cancelURL,sname,oname"/>                             
                     </uix:subTabBar>                                          
                </uix:subTabs>
                                
                <uix:labeledFieldLayout columns="1" width="35%">
                    <uix:spacer width="10" height="10"/>
                    <uix:messageStyledText  id="resName"
                                            promptBinding="XDBRES_PATHNAME@xdbMsgs"
                                            textBinding="resName@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_PATHNAME@xdbMsgs"
                                            styleClass="OraDataText"/>

                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="displayName"
                                            promptBinding="XDBRES_DISPNAME@xdbMsgs"
                                            textBinding="displayName@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_DISPNAME@xdbMsgs"
                                            styleClass="OraDataText"/>
                                            
                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="schemaName"
                                            promptBinding="OWNER@dbMsgs"
                                            textBinding="schemaName@objectBean@servletRequest"
                                            shortDescBinding="OWNER@dbMsgs"
                                            styleClass="OraDataText"/>
                                            
                    <%-- uix:spacer width="10" height="10" --%>                                            
                    <uix:messageStyledText  id="creator"
                                            promptBinding="XDBRES_CREATOR@xdbMsgs"
                                            textBinding="creator@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_CREATOR@xdbMsgs"
                                            styleClass="OraDataText"/>

                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="lastModifier"
                                            promptBinding="XDBRES_LASTMODIFIER@xdbMsgs"
                                            textBinding="lastModifier@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_LASTMODIFIER@xdbMsgs"
                                            styleClass="OraDataText"/>
                                 
                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="dateCreated"
                                            promptBinding="CREATED@dbMsgs"
                                            textBinding="dateCreated@objectBean@servletRequest"
                                            shortDescBinding="CREATED@dbMsgs"
                                            styleClass="OraDataText"/>

                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="dateModified"
                                            promptBinding="LAST_MODIFIED@dbMsgs"
                                            textBinding="dateModified@objectBean@servletRequest"
                                            shortDescBinding="LAST_MODIFIED@dbMsgs"
                                            styleClass="OraDataText"/>

                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="displayForResType"
                                            promptBinding="XDBRES_TYPE_COL_HEADER@xdbMsgs"
                                            textBinding="displayForResType@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_TYPE_COL_HEADER@xdbMsgs"
                                            styleClass="OraDataText"/>

                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="contentType"
                                            promptBinding="XDBRES_CONTENTTYPE@xdbMsgs"
                                            textBinding="contentType@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_CONTENTTYPE@xdbMsgs"
                                            styleClass="OraDataText"/>

                    <%-- uix:spacer width="10" height="10" --%>
                    <uix:messageStyledText  id="characterSet"
                                            promptBinding="XDBRES_CHARACTERSET@xdbMsgs"
                                            textBinding="characterSet@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_CHARACTERSET@xdbMsgs"
                                            styleClass="OraDataText"/>
                                            
                    <uix:spacer width="10" height="10"/>                                            
                    <uix:messageTextInput   name="language"
                                            id="language"
                                            promptBinding="XDBRES_LANGUAGE@xdbMsgs"
                                            textBinding="language@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_LANGUAGE@xdbMsgs"/>
                                            
                    <uix:spacer width="10" height="10"/>                                            
                    <uix:messageTextInput   name="author"
                                            id="author"
                                            promptBinding="XDBRES_AUTHOR@xdbMsgs"
                                            textBinding="author@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_AUTHOR@xdbMsgs"/>

                    <uix:spacer width="10" height="10"/>                                            
                    <uix:messageTextInput   name="comments"
                                            id="comments"
                                            promptBinding="XDBRES_COMMENT@xdbMsgs"
                                            textBinding="comments@objectBean@servletRequest"
                                            shortDescBinding="XDBRES_COMMENT@xdbMsgs"
                                            rows="3" columns="32"/>                           
                </uix:labeledFieldLayout>
            </uix:subTabLayout>
                        
            <%-- Page Buttons --%>
            <uix:pageButtons>
                <uix:pageButtonBar>
                    <uix:submitButton textBinding="SHOWSQL@dbMsgs" 
                                      shortDescBinding="SHOWSQL@dbMsgs"
                                      name="event" 
                                      value="showSql" />
                    <uix:submitButton textBinding="REVERT@dbMsgs" 
                                      shortDescBinding="REVERT@dbMsgs"
                                      name="event" 
                                      value="revert"/>
                    <uix:submitButton textBinding="APPLY@dbMsgs" 
                                      shortDescBinding="APPLY@dbMsgs"
                                      name="event" 
                                      value="apply"/>                    
                </uix:pageButtonBar>
            </uix:pageButtons>
            
        </uix:pageLayout>                            
      </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
