<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        searchPage.jsp
  -- Controller:  db/adm/xdb/XDBResourceSearchController.java
  --
  -- Description: 
  --              Results are shown as a HGrid
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.res.XDBResSearchUIXConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    <db:script src="/database/utils.js" />
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
        <%-- HTML form --%>
        <uix:body>
            <db:form  name="searchPage" 
                method="post" 
                destination="/console/database/xdb/XDBResourceSearch"
                copyParams="target,type,otype,objectType">
                <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_SEARCH_PAGE %>"/>
                <uix:pageLayout titleBinding="XDBRESOURCES@dbMsgs">  
                
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  
  

                    <%-- Header tab for Search --%>
                    <uix:contents>
                        <%-- table layout for controls --%>
                        
                            
                        <uix:tableLayout cellSpacing="5">
                            <uix:rowLayout>                                
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="XDBRES_NAME_COL_HEADER@xdbMsgs"/>                  
                                </uix:cellFormat>       

                                <uix:cellFormat>
                                    <uix:textInput    
                                    name="resNamePattern" 
                                    id="resNamePattern"
                                    textBinding="resNamePattern@mainSearchBean@servletRequest"
                                    shortDescBinding="XDBRES_NAME_COL_HEADER@xdbMsgs"
                                    columns="15"/>                      
                                </uix:cellFormat>             
                                    
                                <uix:cellFormat>
                                    <uix:submitButton textBinding="GO@dbMsgs" 
                                    onFocus="true" 
                                    selected="true" 
                                    name="event" 
                                    value="search"/>                                                
                                </uix:cellFormat>                                    
                            </uix:rowLayout>                            
                        </uix:tableLayout>                            
                    </uix:contents>
                                                                                            
                    <%-- Results --%>
					<uix:tableLayout cellSpacing="5" width="100%">
						<uix:rowLayout>
							<uix:cellFormat>
								<uix:styledText styleClass="OraTipText"
									textBinding="XDBRES_HGRID_SUMMARY@xdbMsgs" />
							</uix:cellFormat>

							<uix:cellFormat hAlign="right" vAlign="top">
								<uix:submitButton textBinding="CREATE@dbMsgs" name="event"
									value="create" />
							</uix:cellFormat>
						</uix:rowLayout>
					</uix:tableLayout>



					<uix:switcher childNameBinding="tableView@mainSearchBean@servletRequest">
                        <uix:case name="true">
                            <uix:dataScope currentDataBinding="dataBean@servletRequest">
                                <uix:table  name="resSearchTable"
                                alternateTextBinding="<%= XDBResSearchUIXConstants.XDBRES_TABLE_ALTERNATEBINDING %>"
                                blockSizeBinding="<%= XDBResSearchUIXConstants.XDBRES_TABLE_BLOCKSIZEBINDING %>"
                                formSubmitted="true"
                                width="100%"
                                tableDataBinding="rowData"
                                valueBinding="startIndex"
                                maxValueBinding="<%= XDBResSearchUIXConstants.XDBRES_NUM_ROWS_ATTR %>"
				summaryBinding="summary@dataBean@servletRequest">

                                <%-- Table Selection --%>
                                <uix:tableSelection>
                                    <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@dbMsgs">
                                        <uix:flowLayout>
                                            <uix:submitButton textBinding="EDIT@dbMsgs" name="event" value="edit"/>
                                            <uix:spacer width="2"/>
                                            <uix:submitButton textBinding="VIEW_BUTTON@dbMsgs" name="event" value="view"/>
                                            <uix:spacer width="2"/>
                                            <uix:submitButton textBinding="DELETE@dbMsgs" name="event" value="delete"/>
                                        </uix:flowLayout>
                                    </uix:singleSelection>
                                </uix:tableSelection>

                                <%-- XDBResource name column --%>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="NAME@dbMsgs" 
                                    sortableBinding="<%= XDBResSearchUIXConstants.XDBRESNAME_SORT_COL %>" />
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat" width="35%"/>
                                <uix:link   textBinding="<%= XDBResSearchUIXConstants.XDBRESNAME_COL %>" 
                                destinationBinding="<%= XDBResSearchUIXConstants.XDBRES_LINKATTR_OBJECTS %>"/>                    
                                </uix:column>

                                <%-- XDBResource owner column --%>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="OWNER@dbMsgs" 
                                    sortableBinding="<%= XDBResSearchUIXConstants.XDBRESOWNER_SORT_COL %>" />                    
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat" width="15%"/>
                                <uix:styledText textBinding="<%= XDBResSearchUIXConstants.XDBRESOWNER_COL %>" />
                                </uix:column>

                                <%-- XDBResource created date column --%>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="CREATED@dbMsgs"
                                    sortableBinding="<%= XDBResSearchUIXConstants.XDBRESCREATED_SORT_COL %>" />
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                <uix:styledText textBinding="<%= XDBResSearchUIXConstants.XDBRESCREATED_COL %>"/>
                                </uix:column>

                                <%-- XDBResource modified date column --%>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="LAST_MODIFIED@dbMsgs"
                                    sortableBinding="<%= XDBResSearchUIXConstants.XDBRESMODIFIED_SORT_COL %>" />                                            
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat" width="20%"/>
                                <uix:styledText textBinding="<%= XDBResSearchUIXConstants.XDBRESMODIFIED_COL %>"/>
                                </uix:column>

                                <%-- XDBResource image column --%>
                                <uix:column>
                                <uix:columnHeader>
                                    <uix:sortableHeader textBinding="XDBRES_TYPE_COL_HEADER@xdbMsgs"
                                    sortableBinding="<%= XDBResSearchUIXConstants.XDBRESTYPE_SORT_COL %>" />
                                </uix:columnHeader>
                                <uix:columnFormat columnDataFormat="textFormat" width="10%"/>
                                <uix:styledText textBinding="<%= XDBResSearchUIXConstants.XDBRESTYPE_COL %>" />
                                </uix:column>
                                </uix:table> 
                            </uix:dataScope>
                        </uix:case>
                        <uix:case name="false">
                            <uix:hGrid  id="resHGrid"
                                width="100%"
                                alternateTextBinding="alternateText@dataBean@servletRequest"
                                destinationBinding="destination@dataBean@servletRequest"
                                summaryBinding="summary@dataBean@servletRequest"
                                columnFormatsBinding="columnFormats@dataBean@servletRequest"
                                columnHeaderDataBinding="columnHeaderData@dataBean@servletRequest"
                                treeDataBinding="rootNode@dataBean@servletRequest"
                                proxyBinding="proxy@servletRequest"
                                formSubmitted="true">
                                <uix:formValue name="displayedItem" valueBinding="uniqueID"/>
                                <uix:tableSelection>
                                    <uix:singleSelection selectedIndexBinding="selectedIndex@dataBean@servletRequest"
                                        disabledBinding="disabled" shortDescBinding="SELECT@dbMsgs">
                                        <uix:flowLayout>
                                            <uix:submitButton textBinding="EDIT@dbMsgs" 
                                            name="event" 
                                            value="edit"
                                            disabledBinding="actionsDisabled@dataBean@servletRequest"/>
                                            <uix:spacer width="2"/>
                                            <uix:submitButton textBinding="VIEW_BUTTON@dbMsgs" 
                                            name="event" 
                                            value="view"
                                            disabledBinding="actionsDisabled@dataBean@servletRequest"/>
                                            <uix:spacer width="2"/>
                                            <uix:submitButton textBinding="DELETE@dbMsgs" 
                                            name="event" 
                                            value="delete"
                                            disabledBinding="actionsDisabled@dataBean@servletRequest"/>
                                        </uix:flowLayout>                                            
                                    </uix:singleSelection> 
                                </uix:tableSelection>                                
                            
                                <uix:nodeStamp>
                                    <uix:column>
                                    <uix:columnHeader>
                                        <uix:styledText textBinding="NAME@dbMsgs"/>
                                    </uix:columnHeader>
                                    <db:link textBinding="resDispName" destinationBinding="resNameViewLink"/>
                                    </uix:column>
                                </uix:nodeStamp>
                                                                
                                <uix:columnHeaderStamp>
                                    <uix:text textBinding="text"/>
                                </uix:columnHeaderStamp>
                            
                                <uix:styledText textBinding="resOwner"/>
                                <uix:styledText textBinding="resDateCreated"/>
                                <uix:styledText textBinding="resDateModified"/>                                
                            </uix:hGrid>                            
                        </uix:case>
                    </uix:switcher>
                    
                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:switcher childNameBinding="tableView@mainSearchBean@servletRequest">
                                <uix:case name="true">
                                    <uix:submitButton textBinding="XDBRES_VIEW_FULL_HIERARCHY@xdbMsgs" 
                                    name="event" value="xdbResViewHierarchy"/>                                            
                                </uix:case>
                                <uix:case name="false">
                                    <uix:submitButton textBinding="XDBRES_VIEW_FLAT_LIST@xdbMsgs" 
                                    name="event" value="xdbResViewFlatList"/>                                            
                                </uix:case>                                                                
                            </uix:switcher>                        
                            <uix:spacer width="5"/>
                        </uix:pageButtonBar>
                    </uix:pageButtons>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
