<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        securityPage.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: Security Page for XDB Resource Create and EDit
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%--
<db:script src="/database/utils.js"/>
--%>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
<uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
  
  <uix:body>
      <%-- HTML Form --%>
      <db:form  name="resSecurity"
                method="post"
                destination="/console/database/xdb/XDBResource"
                copyParams="target,type,otype,cancelURL,oname,sname" >
        <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_SECURITY_PAGE %>"/>
        <uix:pageLayout titleBinding="header@objectBean@servletRequest">
        <%--- Include global tabs --%>
        <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  
  

        <%-- Sub Tabs --%>
        <uix:subTabLayout>
            <%-- Specify tabs --%>
            <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="currentTab@objectBean@servletRequest">
                    <db:link textBinding="GENERAL@dbMsgs"
                             shortDescBinding="GENERAL@dbMsgs"
                             onClick="submitForm('resSecurity', true, {event:'subTabResGeneral'})"
                             copyParams="target,type,otype,cancelURL,oname,sname"/>
                    <db:link textBinding="XDBRES_SECURITY@xdbMsgs"
                             shortDescBinding="XDBRES_SECURITY@xdbMsgs"
                             onClick="submitForm('resSecurity', true, {event:'subTabResSecurity'})"
                             copyParams="target,type,otype,cancelURL"/>                             
                 </uix:subTabBar>
            </uix:subTabs>
            
            <%-- Specify contents --%>
            <uix:spacer width="10" height="10"/>
            <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>        
                    <uix:cellFormat>
                        <uix:spacer width="10" height="10"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                        <%-- Todo Binding --%>
                        <uix:messageChoice  name="resACLFile"
                                            id="resACLFile"
                                            shortDescBinding="XDBRES_ACL_FILE@xdbMsgs"
                                            promptBinding="XDBRES_ACL_FILE@xdbMsgs"
                                            selectedValueBinding="resACLFile@objectBean@servletRequest">
                            <uix:contents childDataBinding="resACLFiles@objectBean@servletRequest">
                                <uix:option textBinding="textKey" 
                                            valueBinding="valueKey"/>
                            </uix:contents>
                        </uix:messageChoice>                            
                    </uix:cellFormat>
                    <uix:cellFormat>
                        <uix:spacer width="10" height="10"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                        <uix:button  textBinding="XDBRES_CREATE_ACL@xdbMsgs"
                                            shortDescBinding="XDBRES_CREATE_ACL@xdbMsgs"
                                            destinationBinding="createACLLink@servletRequest"/>                        
                    </uix:cellFormat>
                    <uix:cellFormat>
                        <uix:spacer width="10" height="10"/>
                    </uix:cellFormat>
                    <uix:cellFormat>
                        <uix:submitButton   textBinding="XDBRES_EDIT_ACL@xdbMsgs"
                                            shortDescBinding="XDBRES_EDIT_ACL@xdbMsgs"
                                            name="event"
                                            value="xdbEditACL"/>                        
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>

      <%--      <uix:tableLayout width="15%" cellSpacing="10">
                <uix:rowLayout>                
                    <uix:header textBinding="XDBRES_RELATED_LINK@xdbMsgs">
                        <db:link textBinding="XDBRES_CREATE_ACL@xdbMsgs"
                                 shortDescBinding="XDBRES_CREATE_ACL@xdbMsgs"
                                 destinationBinding="createACLLink@servletRequest"
                                 onClick="submitForm('resSecurity', true, {event:'xdbCreateACL'})"/> 
      
                    </uix:header>
                </uix:rowLayout>
            </uix:tableLayout> --%> 
        </uix:subTabLayout>
        
        <%-- Page Buttons --%>
        <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:submitButton textBinding="SHOWSQL@dbMsgs" 
                                  shortDescBinding="SHOWSQL@dbMsgs"
                                  name="event" 
                                  value="showSql" />
                <%-- Show Revert and Apply for Edit mode --%>
                <uix:submitButton textBinding="REVERT@dbMsgs" 
                                  shortDescBinding="REVERT@dbMsgs"
                                  name="event" 
                                  value="revert"
                                  renderedBinding="editMode@objectBean@servletRequest"/>
                <uix:submitButton textBinding="APPLY@dbMsgs" 
                                  shortDescBinding="APPLY@dbMsgs"
                                  name="event" 
                                  value="apply"
                                  renderedBinding="editMode@objectBean@servletRequest"/>                                        
               <%-- Show Cancel and OK for Create mode --%>
                <uix:submitButton textBinding="CANCEL@dbMsgs" 
                                  shortDescBinding="CANCEL@dbMsgs"
                                  name="event" 
                                  value="cancel"
                                  renderedBinding="createMode@objectBean@servletRequest"/>
                <uix:submitButton textBinding="OK@dbMsgs" 
                                  shortDescBinding="OK@dbMsgs"
                                  name="event" 
                                  value="apply"
                                  renderedBinding="createMode@objectBean@servletRequest"/>                                        
                
            </uix:pageButtonBar>
        </uix:pageButtons>
        
    </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>
 
