<%--
  -- Page:        selectResPage.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: LOV Page for display XDB Resource files and folders
  --%>
  
<%@ include file="/sdk/oemTop.jspf" %>  
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@uixDBObjectBundle@servletRequest"/>    
      <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
      </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>
      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('resSelectDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('XDBResource', selectedIndex);
            lovField.value = selectedElement.value;
            alert( selectedElement.value );
            window.close();
          }
        }
      </script>          
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <db:form  name="selectResPage" 
                  method="post"
                  destinationBinding="destination@xdbResSelectBean@servletRequest"
                  copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_LOVSEARCHALL_PAGE %>"/>
          <uix:formValue name="event" value="<%= XDBConstants.XDBRES_CHANGESEARCH_EVENT %>"/>
          <uix:pageLayout titleBinding="titleBinding@xdbResSelectBean@servletRequest">
            <uix:tableLayout cellSpacing="2" width="80%">

              <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
                    <uix:rowLayout>
                      <uix:messageTextInput id="xdbResSearchCriteria"
                                       name="xdbResSearchCriteria" 
                                       promptBinding="promptBindingForXDBRes@xdbResSelectBean@servletRequest"
                                       shortDescBinding="promptBindingForXDBRes@xdbResSelectBean@servletRequest"
                                       textBinding="xdbResSearchCriteria@xdbResSelectBean@servletRequest"/>
                      <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" name="event" 
                                              value="xdbResSelectChangeCriteria"/>
                    </uix:rowLayout>
                  </uix:header>
                </uix:stackLayout>
            </uix:rowLayout>
            <uix:rowLayout>
                  <uix:stackLayout>
                    <uix:header textBinding="RESULT@uixDBObjectBundle@servletRequest">
                      <oem:table  name="resSelectDataSource" 
                                  beanKey="xdbResSelectBean" 
                                  blockSize="25"
                                  destinationBinding="destination" 
                                  formSubmitted="true"
                                  dataSourceProp="resSelectDataSource" 
                                  width="90%" 
                                  summaryBinding="RESULT@uixDBObjectBundle@servletRequest"
                                  alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest">
                          <uix:tableSelection>
                            <uix:singleSelection shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest"
                                                 selectedIndex="0"/>
                          </uix:tableSelection>
                      </oem:table>
                  </uix:header>
                </uix:stackLayout>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          destination="javascript:self.close()" />
              <uix:button textBinding="SELECT@uixDBObjectBundle@servletRequest" 
                          destinationBinding="XDBResourceDestination@servletRequest"/>
           </uix:pageButtonBar>
          </uix:pageButtons>
          
          </uix:pageLayout>        
        </db:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>
