<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        viewPage.jsp
  -- Controller:  db/adm/xdb/XDBResourceController.java
  --
  -- Description: XDB Resource View Page
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%--
<db:script src="/database/utils.js"/>
--%>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="xdbMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
<uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>

<uix:document>
  <%@ include file="/oemTitle.jspf" %>
  
  <uix:body>
      <%-- HTML Form --%>
      <db:form  name="resSecurity"
                method="post"
                destination="/console/database/xdb/XDBResource"
                copyParams="target,type,otype,cancelURL,oname,sname" >
        <uix:formValue name="pageName" value="<%= XDBConstants.XDBRES_VIEW_PAGE %>"/>
        <uix:pageLayout titleBinding="header@objectBean@servletRequest">
        <%--- Include global tabs --%>
        <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>  
  

        <%-- contents --%>
        <uix:header textBinding="GENERAL@dbMsgs">
            <uix:labeledFieldLayout columns="1" width="50%">
                <uix:styledText textBinding="XDBRES_PATHNAME@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="resName@objectBean@servletRequest" styleClass="OraDataText"/>

                <uix:styledText textBinding="XDBRES_DISPNAME@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="displayName@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="OWNER@dbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="schemaName@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="XDBRES_CREATOR@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="creator@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="XDBRES_LASTMODIFIER@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="lastModifier@objectBean@servletRequest" styleClass="OraDataText"/>

                <uix:styledText textBinding="CREATED@dbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="dateCreated@objectBean@servletRequest" styleClass="OraDataText"/>

                <uix:styledText textBinding="LAST_MODIFIED@dbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="dateModified@objectBean@servletRequest" styleClass="OraDataText"/>

                <uix:styledText textBinding="XDBRES_TYPE_COL_HEADER@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="displayForResType@objectBean@servletRequest" styleClass="OraDataText"/>

                <uix:styledText textBinding="XDBRES_CONTENTTYPE@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="contentType@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="XDBRES_CHARACTERSET@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="characterSet@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="XDBRES_LANGUAGE@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="language@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="XDBRES_AUTHOR@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="author@objectBean@servletRequest" styleClass="OraDataText"/>
                
                <uix:styledText textBinding="XDBRES_COMMENT@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="comments@objectBean@servletRequest" styleClass="OraDataText"/>                
            </uix:labeledFieldLayout>            
        </uix:header>
        
        <uix:header textBinding="XDBRES_SECURITY@xdbMsgs">
            <uix:labeledFieldLayout columns="1" width="50%">
                <uix:styledText textBinding="XDBRES_ACL_FILE@xdbMsgs" styleClass="OraInstructionText"/>
                <uix:styledText textBinding="resACLFile@objectBean@servletRequest" styleClass="OraDataText"/>
            </uix:labeledFieldLayout>
        </uix:header>
        
        <%-- Page Buttons --%>
        <uix:pageButtons>
            <uix:pageButtonBar>
                <uix:switcher childNameBinding="resFileType@objectBean@servletRequest">
                    <uix:case name="true">
                        <uix:submitButton textBinding="DISPLAY_CONTENTS@dbMsgs" 
                                          shortDescBinding="DISPLAY_CONTENTS@dbMsgs"
                                          name="event" 
                                          value="xdbResDisplayContents"/>                                                    
                    </uix:case>
                </uix:switcher>
            
            	<uix:submitButton textBinding="DISPLAY_EVENT_LISTENERS@xdbMsgs" 
                                  shortDescBinding="DISPLAY_EVENT_LISTENERS@xdbMsgs"
                                  name="event" 
                                  value="displayEventListeners"/>
            
                <uix:submitButton textBinding="EDIT@dbMsgs" 
                                  shortDescBinding="EDIT@dbMsgs"
                                  name="event" 
                                  value="edit"/>
                <uix:submitButton textBinding="OK@dbMsgs" 
                                  shortDescBinding="OK@dbMsgs"
                                  name="event" 
                                  value="cancel"/>                    
            </uix:pageButtonBar>
        </uix:pageButtons>
        </uix:pageLayout>
      </db:form>
  </uix:body>
</uix:document>
</uix:renderingContext>