<%@ include file="/sdk/oemTop.jspf"%>

<%--
  -- Page:       createGeneralPage.jsp
  -- Controller: db/adm/xdb/XMLSchemaController.java
  --
  -- Description: Page for XML Schema Registration
  --              
--%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<%-- LOV support --%>
<db:script src="/database/LOV.js" />

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants"%>

<uix:renderingContext id="renderingContext">
	<uix:bundle name="xdbResMsgs"
		class="oracle.sysman.db.rsc.xdb.XDBResMsg" />
	<uix:bundle name="xdbSchMsgs"
		class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg" />
	<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg" />
	<oem:setURLEncoder id="renderingContext" />

	<uix:document>
		<%@ include file="/oemTitle.jspf"%>
		<uix:body>
			<%-- HTML Form --%>
			<db:form name="resCreateForm" method="post"
				destination="/console/database/xdb/XMLSchema"
				copyParams="target,type,otype,cancelURL"
				usesUploadBinding="fileUpload@objectBean@servletRequest">
				<uix:formValue name="pageName"
					value="<%= XDBConstants.XMLSCHEMA_CREATE_GENERAL_PAGE %>" />
				<uix:pageLayout titleBinding="header@objectBean@servletRequest">
					<%--- Include global tabs --%>
					<%@ include file="/database/global.jspf"%>

					<%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>
					
					<uix:rowLayout>
						<uix:styledText textBinding="XML_SCHEMA_PAGE_INFO@xdbSchMsgs"
							styleClass="OraInstructionText" />
					</uix:rowLayout>
					<uix:rowLayout>
						<uix:spacer width="10" height="10" />
					</uix:rowLayout>


					<%-- Contents of General Header --%>
					<uix:header textBinding="GENERAL@dbMsgs">
						<uix:tableLayout cellSpacing="10">
							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="OWNER@dbMsgs"
										shortDescBinding="OWNER@dbMsgs" required="yes"
										labeledNodeId="schemaName" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageLovField name="schemaName" id="schemaName"
										shortDescBinding="OWNER@dbMsgs"
										searchDescBinding="OWNER@dbMsgs"
										textBinding="schemaName@objectBean@servletRequest"
										onClick="startLov('schemaName', 'ListSchema')" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="XMLSCHEMA_SCH_URL@xdbSchMsgs"
										shortDescBinding="XMLSCHEMA_SCH_URL@xdbSchMsgs" required="yes" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageTextInput name="resURLName" id="resURLName"
										shortDescBinding="XMLSCHEMA_SCH_URL@xdbSchMsgs"
										textBinding="resURLName@objectBean@servletRequest" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="XMLSCHEMA_SCOPE@xdbSchMsgs"
										shortDescBinding="XMLSCHEMA_SCOPE@xdbSchMsgs" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageChoice name="resScope" id="resScope"
										shortDescBinding="XMLSCHEMA_SCOPE@xdbSchMsgs"
										selectedValueBinding="resScope@objectBean@servletRequest">
										<uix:option textBinding="XMLSCHEMA_PUBLIC@xdbSchMsgs"
											value="PUBLIC" />
										<uix:option textBinding="XMLSCHEMA_PRIVATE@xdbSchMsgs"
											value="PRIVATE" />
									</uix:messageChoice>
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt
										promptBinding="XDBRES_SOURCE_OF_RESOURCE@xdbResMsgs"
										shortDescBinding="XDBRES_SOURCE_OF_RESOURCE@xdbResMsgs" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageChoice name="resSource" id="resSource"
										shortDescBinding="XDBRES_SOURCE_OF_RESOURCE@xdbResMsgs"
										selectedValueBinding="resSource@objectBean@servletRequest"
										onChange="submitForm('resCreateForm',true,{event:'resSourceChangeEvent'})">
										<uix:option textBinding="XMLSCHEMA_USEFROM_XMLDB@xdbSchMsgs"
											value="XMLDBSOURCE" />
										<uix:option textBinding="XDBRES_USEFILEATURL@xdbResMsgs"
											value="URLSOURCE" />
										<uix:option textBinding="XDBRES_USEFILEINFS@xdbResMsgs"
											value="FILESOURCE" />
										<uix:option
											textBinding="XDBRES_SPECIFY_FILECONTENTS@xdbResMsgs"
											value="USERSOURCE" />
									</uix:messageChoice>
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout
								renderedBinding="fromFileAtURLRendered@objectBean@servletRequest">
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="XDBRES_URL@xdbResMsgs"
										shortDescBinding="XDBRES_URL@xdbResMsgs"
										renderedBinding="fromFileAtURLRendered@objectBean@servletRequest" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageTextInput name="resURL" id="resURL"
										textBinding="resURL@objectBean@servletRequest"
										shortDescBinding="XDBRES_URL@xdbResMsgs"
										renderedBinding="fromFileAtURLRendered@objectBean@servletRequest" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout
								renderedBinding="fromFileAtFSRendered@objectBean@servletRequest">
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="XDBRES_PATHTOFILE@xdbResMsgs"
										shortDescBinding="XDBRES_PATHTOFILE@xdbResMsgs"
										renderedBinding="fromFileAtFSRendered@objectBean@servletRequest"
										labeledNodeId="resFilePath" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageFileUpload name="resFilePath" id="resFilePath"
										shortDescBinding="XDBRES_PATHTOFILE@xdbResMsgs"
										renderedBinding="fromFileAtFSRendered@objectBean@servletRequest" 
										messageBinding="resFilePathFileName@objectBean@servletRequest"/>
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout
								renderedBinding="fromUserRendered@objectBean@servletRequest">
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="XDBRES_CONTENTS@xdbResMsgs"
										shortDescBinding="XDBRES_CONTENTS@xdbResMsgs"
										renderedBinding="fromUserRendered@objectBean@servletRequest" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageTextInput name="resContents" id="resContents"
										shortDescBinding="XDBRES_CONTENTS@xdbResMsgs"
										textBinding="resContents@objectBean@servletRequest" rows="15"
										columns="100"
										renderedBinding="fromUserRendered@objectBean@servletRequest" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout
								renderedBinding="fromXMLDBRendered@objectBean@servletRequest">
								<uix:cellFormat hAlign="right">
									<uix:messagePrompt promptBinding="XDBRES_COL_HEADER@xdbResMsgs"
										shortDescBinding="XDBRES_COL_HEADER@xdbResMsgs"
										renderedBinding="fromXMLDBRendered@objectBean@servletRequest"
										labeledNodeId="xmlDBResName" />
								</uix:cellFormat>

								<uix:cellFormat hAlign="left">
									<uix:messageLovField name="xmlDBResName" id="xmlDBResName"
										shortDescBinding="XDBRES_COL_HEADER@xdbResMsgs"
										searchDescBinding="XDBRES_COL_HEADER@xdbResMsgs"
										textBinding="xmlDBResName@objectBean@servletRequest"
										onClick="preserveCase();startLov('xmlDBResName', 'ListXDBResourceFile')"
										renderedBinding="fromXMLDBRendered@objectBean@servletRequest" />
								</uix:cellFormat>
							</uix:rowLayout>
						</uix:tableLayout>
					</uix:header>

					<%-- Contents of Options header --%>
					<uix:header textBinding="TABLE_STORAGE_OPTIONS@xdbSchMsgs">
						<uix:contents>
							<uix:rowLayout>
								<uix:cellFormat>
									<uix:spacer width="5" height="5" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat>
									<uix:messagePrompt promptBinding="REGISTER_FOR@xdbSchMsgs" />
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:spacer width="10" />
								</uix:cellFormat>
								<uix:cellFormat>
									<uix:messageChoice name="registerFor" id="registerFor"
										shortDescBinding="REGISTER_FOR@xdbSchMsgs"
										selectedValueBinding="registerFor@objectBean@servletRequest">
										<uix:option textBinding="BINARY@xdbSchMsgs" 
												value="BINARY" 
												renderedBinding="versionEqualOrHigher11g@objectBean@servletRequest"/>
										<uix:option textBinding="CLOB@xdbSchMsgs" value="CLOB" />
										<uix:option textBinding="OBJECT-RELATIONAL@xdbSchMsgs" value="OBJECT-RELATIONAL" />
									</uix:messageChoice>
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat>
									<uix:spacer width="5" height="5" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat>
									<uix:messageCheckBox name="genObjTables"
										id="genObjTables"
										textBinding="XMLSCHEMA_OPT_GENTABLES@xdbSchMsgs"
										checkedBinding="genObjTables@objectBean@servletRequest" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat>
									<uix:spacer width="5" height="5" />
								</uix:cellFormat>
							</uix:rowLayout>

							<uix:rowLayout>
								<uix:cellFormat>
									<uix:messageCheckBox name="ignoreRegErrors"
										id="ignoreRegErrors"
										textBinding="XMLSCHEMA_OPT_REGSCHEMA@xdbSchMsgs"
										checkedBinding="ignoreRegErrors@objectBean@servletRequest"
										tipBinding="XMLSCHEMA_OPT_REGSCHEMA_TIP@xdbSchMsgs" />
								</uix:cellFormat>
							</uix:rowLayout>
						</uix:contents>
					</uix:header>

					<%-- Page Buttons --%>
					<uix:pageButtons>
						<uix:pageButtonBar>
							<uix:submitButton textBinding="SHOWSQL@dbMsgs"
								shortDescBinding="SHOWSQL@dbMsgs" name="event" value="showSql" />
							<uix:submitButton textBinding="CANCEL@dbMsgs"
								shortDescBinding="CANCEL@dbMsgs" name="event" value="cancel" />
							<uix:submitButton textBinding="OK@dbMsgs"
								shortDescBinding="OK@dbMsgs" name="event" value="apply" />
						</uix:pageButtonBar>
					</uix:pageButtons>
				</uix:pageLayout>
			</db:form>
		</uix:body>
	</uix:document>

</uix:renderingContext>
