<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        deletePage.jsp
  -- Controller:  db/adm/xdb/XMLSchemaController.java
  --
  -- Description: XML Schema Delete Page
  --%>
  
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
  
<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>
<%@ page import="oracle.sysman.emo.xdb.schema.XMLSchemaObject" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbSchMsgs" class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

    <uix:document>
        <uix:metaContainer>
            <uix:head titleBinding="CONFIRMATION@dbMsgs"/>
        </uix:metaContainer>

        <uix:body>
            <db:form    name="delXMLSchema"
                        method="post"
                        destination="/console/database/databaseObjectsSearch"
                        copyParams="target,type,cancelURL,sname,oname,otype,objectType">
                <uix:formValue name="pageName" value="<%= XDBConstants.XMLSCHEMA_DELETE_PAGE %>"/>
                <uix:formValue name="objectType" value="XMLSCHEMA"/>
                <uix:formValue name="backURL" valueBinding="backURL@servletRequest"/>
                <uix:formValue name="msgText" valueBinding="msgText@msgTable@servletRequest"/>
                <uix:pageLayout titleBinding="DELETE_WITH_OPTIONS@dbMsgs">                            
                    <% if (request.getAttribute("em2goApp") != null) {%>
                        <%@ include file="/em2go/em2goGlobal.jspf" %>
                    <% } else {%>   
                        <%@ include file="/database/globalPopup.jspf" %>
                    <%} %>

                    <% if (request.getAttribute("em2goApp") != null) {%>
                        <%@ include file="/em2go/em2goFooter.jspf" %>
                    <%}%>                  
                    <%-- Contents --%>
                    <uix:stackLayout>
                        <uix:rowLayout>
                            <uix:spacer width="10" height="10"/>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:radioButton    name="deleteOption"
                                                id="schemaDelRestrict"
                                                textBinding="XMLSCHEMA_DEL_RESTRICT@xdbSchMsgs"
                                                value="<%= XDBConstants.XMLSCHEMA_DELETE_RESTRICT %>"
                                                selectedValueBinding="deleteOption@objectBean@servletRequest"
                                                shortDescBinding="XMLSCHEMA_DEL_RESTRICT@xdbSchMsgs"/>    
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:spacer width="10" height="10"/>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:radioButton    name="deleteOption"
                                                id="schemaDelInvalid"
                                                textBinding="XMLSCHEMA_DEL_INVALIDATE@xdbSchMsgs"
                                                value="<%= XDBConstants.XMLSCHEMA_DELETE_INVALIDATE %>"
                                                selectedValueBinding="deleteOption@objectBean@servletRequest"
                                                shortDescBinding="XMLSCHEMA_DEL_INVALIDATE@xdbSchMsgs"/>                                                                                        
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:spacer width="10" height="10"/>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:radioButton    name="deleteOption"
                                                id="schemaDelCascade"
                                                textBinding="XMLSCHEMA_DEL_CASCADE@xdbSchMsgs"
                                                value="<%= XDBConstants.XMLSCHEMA_DELETE_CASCADE %>"
                                                selectedValueBinding="deleteOption@objectBean@servletRequest"
                                                shortDescBinding="XMLSCHEMA_DEL_CASCADE@xdbSchMsgs"/>                                                                                        
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:spacer width="10" height="10"/>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:radioButton    name="deleteOption"
                                                id="schemaDelCascadeForce"
                                                textBinding="XMLSCHEMA_DEL_CASCADE_FORCE@xdbSchMsgs"
                                                value="<%= XDBConstants.XMLSCHEMA_DELETE_CASCADE_FORCE %>"
                                                selectedValueBinding="deleteOption@objectBean@servletRequest"
                                                shortDescBinding="XMLSCHEMA_DEL_CASCADE_FORCE@xdbSchMsgs"/>                                                                                        
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:spacer width="10" height="10"/>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:spacer width="20"/>
                            <uix:styledText styleClass="OraDataText" textBinding="msgText@msgTable@servletRequest"/>
                        </uix:rowLayout>
                    </uix:stackLayout>

                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="SHOWSQL@dbMsgs" 
                                            shortDescBinding="SHOWSQL@dbMsgs"
                                            name="event" 
                                            value="showSql"/>
                            <uix:button textBinding="CANCEL@dbMsgs" 
                                        destinationBinding="backURL@servletRequest"/>
                            <uix:submitButton textBinding="YES@dbMsgs" 
                                        shortDescBinding="YES@dbMsgs"
                                        name="event" 
                                        value="doDelete"/>
                        </uix:pageButtonBar>
                    </uix:pageButtons>                
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>