<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        showSchema.jsp
  -- Controller:  db/adm/xdb/XMLSchemaController.java
  --
  -- Description: Display XML Schema Content
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbResMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="xdbSchMsgs" class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
        <uix:body>
            <%-- HTML form --%>
            <db:form    name="schDispForm"
                        method="post"
                        destination="/console/database/xdb/XMLSchema"
                        copyParams="target,type,otype,oname,sname,cancelURL">
                <uix:formValue name="pageName" value="<%= XDBConstants.XMLSCHEMA_SHOWCONTENTS_PAGE %>"/>
                <%-- TODO: use titleBinding --%>
                <uix:pageLayout title="Display XML Schema Contents">
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>    
                
                    <%-- Contents --%>
                    <uix:styledText textBinding="resContents@objectBean@servletRequest"/>
                    
                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="OK@dbMsgs" 
                                              shortDescBinding="OK@dbMsgs"
                                              name="event" 
                                              value="cancel"/>                    
                        </uix:pageButtonBar>
                    </uix:pageButtons>                                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>