<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        viewPage.jsp
  -- Controller:  db/adm/xdb/XMLSchemaController.java
  --
  -- Description: XML Schema View Page
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.emo.xdb.XDBConstants" %>

<script language="javascript">
function popWindow() {
    sURL = "" + document.forms[0].action +'&event=showSchemaContents';
    window.open( sURL, 'xmlSchema', 'width=700, height=600, resizeable=yes, scrollbars=yes', true );    
}
</script>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="xdbResMsgs" class="oracle.sysman.db.rsc.xdb.XDBResMsg"/>
    <uix:bundle name="xdbSchMsgs" class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg"/>
    <uix:bundle name="dbMsgs"  class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    
    <uix:document>
        <%@ include file="/oemTitle.jspf" %>
        <uix:body>
            <%-- HTML form --%>
            <db:form    name="schViewForm"
                        method="post"
                        destination="/console/database/xdb/XMLSchema"
                        copyParams="target,type,otype,oname,sname,cancelURL">
                <uix:formValue name="pageName" value="<%= XDBConstants.XMLSCHEMA_VIEW_PAGE %>"/>
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">
                    <%--- Include global tabs --%>
                    <%@ include file="/database/global.jspf" %>        

                   <%-- Information/Error display --%>
					<%@ include file="/database/informationError.jspf" %>    
                
                    <%-- Contents --%>
                    <uix:header textBinding="GENERAL@dbMsgs">
                        <uix:labeledFieldLayout columns="1" width="25%">
                            <uix:spacer width="10" height="10"/>
                            <uix:messageStyledText  id="resURLName"
                                                    promptBinding="XMLSCHEMA_SCH_URL@xdbSchMsgs"
                                                    textBinding="resURLName@objectBean@servletRequest"
                                                    styleClass="OraDataText"/>                                                

                            <uix:spacer width="10" height="10"/>
                            <uix:messageStyledText  id="schemaName"
                                                    promptBinding="OWNER@dbMsgs"
                                                    textBinding="schemaName@objectBean@servletRequest"
                                                    styleClass="OraDataText"/>                                                

                            <uix:spacer width="10" height="10"/>
                            <uix:messageStyledText  id="resScope"
                                                    promptBinding="XMLSCHEMA_SCOPE@xdbSchMsgs"
                                                    textBinding="resScope@objectBean@servletRequest"
                                                    styleClass="OraDataText"/>                                                                                                
                        </uix:labeledFieldLayout>
                    </uix:header>
                    
                    <uix:header textBinding="XMLSCHEMA_SCHEMATEXT@xdbSchMsgs">
                        <uix:labeledFieldLayout columns="1" width="25%">
                            <uix:messageTextInput   name="resContents"
                                                    id="resContents"
                                                    shortDescBinding="XDBRES_CONTENTS@xdbResMsgs"
                                                    textBinding="resContents@objectBean@servletRequest"
                                                    rows="20"
                                                    columns="100"
                                                    readOnly="true"/>                                
                        </uix:labeledFieldLayout>
                        <uix:labeledFieldLayout width="38%">
                            <uix:link   textBinding="XMLSCHEMA_LINKTEXT@xdbSchMsgs"
                                        destinationBinding="showSchemaLink@servletRequest"
                                        onClick='<%= "popWindow();return false;"  %>' />
                        </uix:labeledFieldLayout>
                    </uix:header>
                    
                    <%-- Page Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <uix:submitButton textBinding="OK@dbMsgs" 
                                              shortDescBinding="OK@dbMsgs"
                                              name="event" 
                                              value="cancel"/>                    
                        </uix:pageButtonBar>    
                    </uix:pageButtons>                    
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
