<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="bundle" class="oracle.sysman.db.eusr.rsc.OidMsg" /> 
<uix:document> 
 <uix:metaContainer> 
  <uix:head titleBinding="LABEL_OID@bundle"/> 
  <uix:styleSheet/>
 </uix:metaContainer> 

 <uix:form name="configSet" method="POST" >

 <uix:pageLayout>
 <%@ include file="/oemGlobal.jspf" %>
 <uix:tableLayout width="100%"
                  cellSpacing="5"
                  hAlign="center" >
 <uix:rowLayout>
  <uix:header textBinding="configSetTitle@defaultBean@servletRequest"/>
 </uix:rowLayout>
 <uix:rowLayout>

 </uix:rowLayout>
 <uix:messageBox messageBinding="errorMsg@defaultBean@servletRequest"
                 renderedBinding="isErr@defaultBean@servletRequest"
                 messageType="error" />
 <uix:spacer height="15" />

  <uix:labeledFieldLayout fieldWidth="65%" labelWidth="35%">
    <uix:contents>
     <uix:messageTextInput textBinding="configSetNum@defaultBean@servletRequest"
                           promptBinding="LABEL_CONFIG_SET_NUMBER@bundle" 
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="nonSSLPort@defaultBean@servletRequest"
                           promptBinding="LABEL_NON_SSL_PORT@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="maxDBConnect@defaultBean@servletRequest"
                           promptBinding="LABEL_MAX_NUM_DB_CONNECT@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="numServerProcess@defaultBean@servletRequest"
                           promptBinding="LABEL_NUM_SERVER_PROCESS@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="sslEnable@defaultBean@servletRequest"
                           promptBinding="LABEL_SSL_ENABLE@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="sslPort@defaultBean@servletRequest"
                           promptBinding="LABEL_SSL_PORT@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="sslWalletUrl@defaultBean@servletRequest"
                           promptBinding="LABEL_SSL_WALLET_URL@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="sslVersion@defaultBean@servletRequest"
                           promptBinding="LABEL_SSL_VERSION@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
     <uix:messageTextInput textBinding="sslAuthType@defaultBean@servletRequest"
                           promptBinding="LABEL_SSL_AUTHENTICATION_TYPE@bundle"
                           readOnly="true" 
                           styleClass="OraDataText"/>
   </uix:contents>
  </uix:labeledFieldLayout>
 </uix:tableLayout>
 </uix:pageLayout>
 </uix:form>  

</uix:document> 
</uix:renderingContext> 