<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="bundle" class="oracle.sysman.db.eusr.rsc.OidMsg" /> 
<uix:document> 
 <uix:metaContainer> 
  <uix:head titleBinding="LABEL_OID@bundle"/> 
  <uix:styleSheet/>
 </uix:metaContainer> 

 <uix:form name="oidHome" method="POST" 
           destinationBinding="oidHomeDest@defaultBean@servletRequest" > 

 <uix:pageLayout>
 <%@ include file="/oemGlobal.jspf" %>
 <uix:header textBinding="homePageHeader@defaultBean@servletRequest"/>
    <uix:subTabBar orientation="top" selectedIndex="0">
       <uix:link textBinding="LABEL_HOME@bundle" />
       <uix:link textBinding="LABEL_PERFORMANCE@bundle" 
                 destinationBinding="performanceDest@defaultBean@servletRequest"/>
       <uix:link textBinding="LABEL_EUS@bundle"
                 destinationBinding="eusDest@defaultBean@servletRequest"/>

    </uix:subTabBar>
 <%@ include file="oidRefreshTime.jspf" %>
 <uix:tableLayout  width="100%" 
                   cellSpacing="15"
                   hAlign="center" >
  <uix:rowLayout vAlign="top">
   <uix:cellFormat vAlign="top" width="50%">
     <uix:styledText textBinding="LABEL_GENERAL@bundle" 
                     styleClass="OraHeaderSub" />
     <uix:header text="" >
      <uix:stackLayout>
      <uix:rowLayout>
       <uix:borderLayout>

        <uix:tableLayout  cellSpacing="2" hAlign="left">
         <uix:rowLayout>
          <uix:cellFormat hAlign="right">
           <uix:spacer width="8"/>
           <uix:styledText textBinding="LABEL_CURRENT_AVAIL_STATUS@bundle" 
                styleClass="OraPromptText"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:rowLayout>
           <uix:styledText styleClass="OraDataText" 
                     textBinding="targetStatus@defaultBean@servletRequest"/>
           <uix:spacer width="8"/>
           <uix:link styleClass="OraDataText" 
                     textBinding="availStr@defaultBean@servletRequest" 
                     destinationBinding="availDest@defaultBean@servletRequest"/>

          </uix:rowLayout>

         </uix:rowLayout>

         <uix:rowLayout rendered="true">
          <uix:cellFormat hAlign="right">
           <uix:styledText textBinding="LABEL_LAST_LOAD_TIME@bundle" 
                styleClass="OraPromptText"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:styledText styleClass="OraDataText" 
                          textBinding="lastLoadTime@defaultBean@servletRequest"/>
         </uix:rowLayout>

         <uix:rowLayout rendered="true">
          <uix:cellFormat hAlign="right">
           <uix:styledText textBinding="LABEL_REPOSITORY@bundle"
                styleClass="OraPromptText"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:styledText styleClass="OraDataText" 
                          textBinding="ldapRep@defaultBean@servletRequest"/>
         </uix:rowLayout>
 
         <uix:rowLayout rendered="true">
          <uix:cellFormat hAlign="right">
           <uix:styledText textBinding="LABEL_OID_STATUS@bundle"
                styleClass="OraPromptText"/>
          </uix:cellFormat>
          <uix:spacer width="8"/>
          <uix:image sourceBinding="oidStatusImage@defaultBean@servletRequest" />
         </uix:rowLayout>
 
        </uix:tableLayout>

        <uix:left>
         <uix:image sourceBinding="trafficImage@defaultBean@servletRequest" />
        </uix:left>

       </uix:borderLayout>
      </uix:rowLayout>
      </uix:stackLayout>
     </uix:header>
    </uix:cellFormat>

    <uix:cellFormat vAlign="top" width="50%">
    <uix:styledText textBinding="LABEL_SECURITY_EVENT@bundle" 
                     styleClass="OraHeaderSub" />
    <uix:header text="" >
    <uix:link styleClass="OraDataText" 
              textBinding="LABEL_SECURITY_EVENT_DETAIL@bundle" 
              destinationBinding="detailDest@defaultBean@servletRequest"/>

     <uix:stackLayout>
      <uix:tableLayout cellSpacing="2">
       <uix:rowLayout>
           <oem:chart title=""
                 chartType="barChart"
                 width="300"
                 height="150" 
                 orientation="vertical"
                 shadowEffect="3d"
                 >
              <uix:contents>
                <oem:boundChartDataSource 
                 chartDataSourceBinding="barDataSource@defaultBean@servletRequest"
                 />
                <oem:imageMap defaultLabel="true" />
                <oem:chartColumn                                   
                    isKey="true" 
                    displayLabel=""
                    sourceIndex="0"
                  />
                <oem:chartColumn                                   
                    displayLabelBinding="LABEL_REALTIME@bundle"
                    sourceIndex="1"
                  />
                <oem:chartColumn                                   
                    displayLabelBinding="LABEL_BYDAY@bundle"
                    sourceIndex="2"
                  />
                <oem:chartColumn                                   
                    displayLabelBinding="LABEL_BYWEEK@bundle"
                    sourceIndex="3"
                  />
                <oem:chartColumn                                   
                    displayLabelBinding="LABEL_BYMONTH@bundle"
                    sourceIndex="4"
                  />

              </uix:contents>
            </oem:chart>
       </uix:rowLayout>

      </uix:tableLayout>
     </uix:stackLayout>
    </uix:header>
   </uix:cellFormat>

  </uix:rowLayout>
</uix:tableLayout>

 <uix:tableLayout  width="100%" 
                   cellSpacing="15"
                   hAlign="center" > 
  <uix:rowLayout vAlign="top" width="80%" >
   <uix:cellFormat vAlign="top" width="100%">
    <uix:rowLayout>
    <uix:styledText textBinding="LABEL_SERVER_INSTANCE@bundle"
                    styleClass="OraHeaderSub" />
    <uix:spacer height="0" width="10" />
    <uix:styledText textBinding="LABEL_REAL_TIME@bundle"
                    styleClass="OraDataText" />
    </uix:rowLayout>
    <uix:header text="" />
    <uix:spacer height= "8" />
    <uix:contents>
      <uix:stackLayout>
       <uix:rowLayout>
         <uix:submitButton textBinding="LABEL_STOP_ALL_INST@bundle"
                           name="event" value="STOP_ALL" 
                           disabledBinding="disableStop@defaultBean@servletRequest"/>

         <uix:submitButton textBinding="LABEL_START_FIRST_INST@bundle" 
                           name="event" value="START_INIT" 
                           disabledBinding="disableStart@defaultBean@servletRequest" />

         <uix:submitButton textBinding="LABEL_NEW_INSTANCE@bundle" 
                           name="event" value="NEW_INSTANCE" />

       </uix:rowLayout>
       <uix:spacer height="0" />

       <uix:rowLayout>
        <oem:table name="runningInstTable" 
                   width="100%" 
                   dataSourceProp="oidTableUI" 
                   formSubmitted="true"> 
         <uix:tableSelection>
         <oem:singleSelection selectedIndex="0" >
          <uix:submitButton textBinding="LABEL_STOP@bundle"
                            name="event" 
                            value="STOP_INSTANCE"/>
          <uix:spacer height="5" />
          <uix:submitButton textBinding="LABEL_RESTART@bundle"
                            name="event" 
                            value="RESTART_INSTANCE"/>
         </oem:singleSelection>
         </uix:tableSelection>

        </oem:table>
       </uix:rowLayout>

      </uix:stackLayout>
    </uix:contents>
   </uix:cellFormat>
  </uix:rowLayout>
    
 </uix:tableLayout>

 <uix:tableLayout  width="100%" 
                   cellSpacing="20"
                   hAlign="center" >
  <uix:rowLayout vAlign="top">
   <uix:cellFormat vAlign="top" width="50%">
     <uix:styledText textBinding="LABEL_RELATED@bundle" 
                     styleClass="OraHeaderSub" />
     <uix:header text="" />
      <uix:stackLayout>
      <uix:rowLayout>
       <uix:link textBinding="LABEL_ALL_METRICS@bundle" 
                 destinationBinding="allMetricsDest@defaultBean@servletRequest"/> 
      </uix:rowLayout>
      </uix:stackLayout>
   </uix:cellFormat>
  </uix:rowLayout>
</uix:tableLayout>

 </uix:pageLayout>
 </uix:form>  

</uix:document> 
</uix:renderingContext> 
