<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:bundle name="bundle" class="oracle.sysman.db.eusr.rsc.OidMsg" /> 
<uix:document> 
 <uix:metaContainer> 
  <uix:head titleBinding="LABEL_OID@bundle"/> 
  <uix:styleSheet/>
 </uix:metaContainer> 

 <uix:form name="oidHome" method="POST" 
           destinationBinding="performanceDest@defaultBean@servletRequest" > 


 <uix:pageLayout>
 <%@ include file="/oemGlobal.jspf" %>
 <uix:header textBinding="pageHeader@defaultBean@servletRequest"/>
    <uix:subTabBar orientation="top" selectedIndex="1">
       <uix:link textBinding="LABEL_HOME@bundle" 
                 destinationBinding="oidHomeDest@defaultBean@servletRequest"/>
       <uix:link textBinding="LABEL_PERFORMANCE@bundle" />
       <uix:link textBinding="LABEL_EUS@bundle" 
                 destinationBinding="eusDest@defaultBean@servletRequest"/>
    </uix:subTabBar>
 <%@ include file="oidRefreshTime.jspf" %>
 <uix:tableLayout  width="100%" 
                   cellSpacing="15"
                   hAlign="center" >
  <uix:rowLayout vAlign="top">
   <uix:cellFormat vAlign="top" width="50%">
     <uix:styledText textBinding="LABEL_CPU_USAGE@bundle" 
                     styleClass="OraHeaderSub" />
     <uix:header text="" >
            <oem:chart 
                 chartType="timeSeriesChart"
                 width="350"
                 height="200" 
                 timeGranularity="HOUR"
                 orientation="vertical"
                 seriesColorsAutomatic="false"
                 warningThreshold="150"
                 criticalThreshold="170"
                legendPosition="south"
                 >
              <uix:contents>
                <oem:boundChartDataSource 
                      chartDataSourceBinding="cpuDataSource@defaultBean@servletRequest"
                      />
                <oem:imageMap defaultLabel="true" />
                <oem:chartColumn                                   
                    isKey="true" 
                    displayLabel=""
                    sourceIndex="0"
                  />
                <oem:chartColumn
                    isTimeColumn="true"
                    displayLabel="Time"
                    sourceIndex="1"
                  />
                <oem:chartColumn                                   
                    displayLabel=""
                    sourceIndex="2"
                    itemColor="blue"
                  />

              </uix:contents>
            </oem:chart>


     </uix:header>
    </uix:cellFormat>

    <uix:cellFormat vAlign="top" width="50%">
    <uix:styledText textBinding="LABEL_MEMORY_USAGE@bundle" 
                     styleClass="OraHeaderSub" />
    <uix:header text="" />
            <oem:chart 
                 chartType="timeSeriesChart"
                 width="350"
                 height="200" 
                 timeGranularity="HOUR"
                 orientation="vertical"
                 seriesColorsAutomatic="false"
                 legendPosition="south"
                 >
              <uix:contents>
                <oem:boundChartDataSource 
                      chartDataSourceBinding="memDataSource@defaultBean@servletRequest"
                      />
                <oem:imageMap defaultLabel="true" />
                <oem:chartColumn                                   
                    isKey="true" 
                    displayLabel="test"
                    sourceIndex="0"
                  />
                <oem:chartColumn
                    isTimeColumn="true"
                    displayLabel="Time"
                    sourceIndex="1"
                  />
                <oem:chartColumn                                   
                    displayLabel=""
                    sourceIndex="2"
                    itemColor="blue"
                  />

              </uix:contents>
            </oem:chart>




   </uix:cellFormat>

  </uix:rowLayout>
</uix:tableLayout>


 </uix:pageLayout>
 </uix:form>  

</uix:document> 
</uix:renderingContext> 
