<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%@ page import="oracle.sysman.db.eusr.rsc.EuserMsg" %>
<%@ page import="oracle.sysman.db.eusr.rsc.EuserMsgID" %>
<%@ page import="oracle.sysman.db.eusr.usradm.EuserAdminBean" %>


<oem:styleSheet/>

<html>
<head><oem:title text="<%=EuserMsg.getStr(EuserMsgID.TITLE_EUSER_SECURITY)%>" />
</head>

<oem:body>
<oem:contents>
<oem:form name="euserAdmin" method="POST">
<oem:pageLayout>

<%@ include file="/oemPageGlobal.jspf"%>
<oem:header textProp="homePageHeader"/>
  <oem:subTabBar selectedIndex="2">
     <oem:link text="<%=EuserMsg.getStr(EuserMsgID.LABEL_HOME)%>" 
               destinationProp="homeDest"/>
     <oem:link text="<%=EuserMsg.getStr(EuserMsgID.LABEL_PERFORMANCE)%>"
               destinationProp="performanceDest"/>
     <oem:link text="<%=EuserMsg.getStr(EuserMsgID.LABEL_EUS)%>" />
  </oem:subTabBar>

 <oem:contentFooter  rendered="<%=EuserAdminBean.isRendered()%>">
  <oem:pageButtonBar>
   <oem:flowLayout>
    <oem:contents>
     <oem:button text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_CANCEL)%>" 
                 destinationProp = "homeDest" />

     <oem:spacer height="5" />
     <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_OK)%>" 
                       name="event" value="LDAP_LOGIN" />
    </oem:contents>
   </oem:flowLayout>
  </oem:pageButtonBar>
 </oem:contentFooter>
 <oem:switcher childNameProp="euserAdminForm">
 <oem:case name = "workForm" >
  <oem:tableLayout  width="80%" 
                    cellSpacing="15"
                    hAlign="center" >
  <oem:rowLayout>
    <oem:stackLayout>
     <oem:contents>
      <oem:styledText text="<%=EuserMsg.getStr(EuserMsgID.HEADER_EUSER)%>"
                      styleClass="OraHeaderSub"/>
      <oem:header text="" />
       <oem:borderLayout>
       <oem:left>
       <oem:rowLayout>
       <oem:styledText text="<%=EuserMsg.getStr(EuserMsgID.LABEL_SEARCH)%>"/>
       <oem:spacer width="2" />
       <oem:textInput  name="SEARCH_KEY" textProp="euserSearchKey" />
       <oem:spacer width="2" />
       <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_GO)%>"  
                         name="event" 
                         value="EUSER_SEARCH"/>
       <oem:formValue name="event" value="EUSER_SEARCH" />
       </oem:rowLayout>
       </oem:left>
       <oem:contents>
       <oem:spacer width="0" height="1"/>
       </oem:contents> 
       <oem:right>
       <oem:button text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_CREATE_EUSER)%>" />
                   
       </oem:right>
      </oem:borderLayout>
      <oem:spacer width="0" height="0" />
      <oem:table name="euserTable" 
                 width="100%" 
                 blockSize="5"
                 dataSourceProp="euserTableUI" >
 
       <oem:singleSelection text="<%=EuserMsg.getStr(EuserMsgID.LABEL_SELECT_EUSER_AND)%>" 
                            selectedIndex="0" >
        <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_VIEW)%>"
                          name="event"
                          value="VIEW_USER_DETAIL" />
        <oem:spacer height="1" /> 

        <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_CHANGE_PWD)%>" 
                          name="event"
                          value="CHANGE_PWD" />
        <oem:spacer height="1" /> 
        <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_EDIT_ROLES)%>"
                          name="event"
                          value="EDIT_ROLE"/>
       </oem:singleSelection>
      </oem:table>

      <oem:spacer height="25" />
      <oem:styledText text="<%=EuserMsg.getStr(EuserMsgID.HEADER_EROLE)%>"
                      styleClass="OraHeaderSub"/>
      <oem:header text="" />
      <oem:borderLayout>
       <oem:left>
       <oem:spacer width="0" height="1"/>
       </oem:left>
       <oem:contents>
       <oem:spacer width="0" height="1"/>
       </oem:contents> 
       <oem:right>
       <oem:button text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_CREATE_EROLE)%>"/>
       </oem:right>
      </oem:borderLayout>
      <oem:spacer width="0" height="0" />
      <oem:table name="eroleTable" 
                 width="100%"
                 blockSize="5"
                 dataSourceProp="eroleTableUI">
       <oem:singleSelection text="<%=EuserMsg.getStr(EuserMsgID.LABEL_SELECT_EROLE_AND)%>"
                            selectedIndex="0" >

        <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_EDIT_GLOBAL_ROLES)%>"
                          name="event" value="EDIT_GLOBAL_ROLES" /> 
        <oem:spacer width="0" height="1" /> 
        <oem:submitButton text="<%=EuserMsg.getStr(EuserMsgID.BUTTON_EDIT_GRANTEES)%>"
                          name="event" value="EDIT_GRANTEES" />
       </oem:singleSelection>
      </oem:table>
     </oem:contents>
    </oem:stackLayout>
  </oem:rowLayout>
 </oem:tableLayout>
 </oem:case>
 <oem:case name ="loginForm">
 <oem:tableLayout width="80%" cellSpacing="10" hAlign="center">
  <oem:contents>
  <oem:rowLayout>
    <oem:stackLayout>
     <oem:styledText text="<%=EuserMsg.getStr(EuserMsgID.HEADER_LDAP_LOGIN)%>"
                 styleClass="OraHeaderSub" />
     <oem:header text="" />
     <oem:spacer height="10" />

     <oem:messageBox message="<%=EuserMsg.getStr(EuserMsgID.ERROR_LOGIN)%>"
                     rendered="<%=EuserAdminBean.getLoginErr()%>"
                     messageType="error" />
     <oem:labeledFieldLayout fieldWidth="95%" labelWidth="30%">
      <oem:contents>
       <oem:styledText styleClass="OraDataText" 
                       text="<%=EuserMsg.getStr(EuserMsgID.LABEL_LDAP_HOST)%>"/>
       <oem:textInput  name="ldapHost"  
                       required="yes"/>
       <oem:styledText styleClass="OraDataText" 
                       text="<%=EuserMsg.getStr(EuserMsgID.LABEL_LDAP_PORT)%>" />
       <oem:textInput  name="ldapPort" 
                       required="yes"/>
       <oem:styledText styleClass="OraDataText" 
                       text="<%=EuserMsg.getStr(EuserMsgID.LABEL_LDAP_UID)%>"/>
       <oem:textInput  name="ldapUID"  
                       required="yes"/>
       <oem:styledText styleClass="OraDataText" 
                       text="<%=EuserMsg.getStr(EuserMsgID.LABEL_LDAP_PWD)%>"/>
       <oem:textInput  name="ldapPwd" 
                       secret="true"
                       required="yes"/>
      </oem:contents>
     </oem:labeledFieldLayout>

     <oem:spacer height="20" />

   </oem:stackLayout>
  </oem:rowLayout>
  </oem:contents>
 </oem:tableLayout>
 </oem:case>
 </oem:switcher>

</oem:pageLayout>
</oem:form> 
</oem:contents>
</oem:body>

</html>

