<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <script type="text/javascript">
        function toggleLov(idEnable, idDisable){
            document.getElementById(idEnable).disabled = false;
            document.getElementById(idDisable).value = "";
            document.getElementById(idDisable).disabled = true;
        }
    </script>
    <uix:body >
      <db:form name="foo" destinationBinding="addDestination@addRes@servletRequest" method="post" copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
<uix:formValue name="isRepDown" valueBinding="isRepDown@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/database/global.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest" errorTableBinding="msgBox@servletRequest" destTableBinding="msgUrls@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
            <uix:formValue name="pageNum" value="3"/>
            <uix:formValue name="mod1Value" valueBinding="mod1Value@servletRequest"/>
          <uix:header textBinding="dependencyHeader@servletRequest">
            <uix:stackLayout>
              <uix:contents>
                  <uix:tableLayout width="100%">
                      <uix:rowLayout>
                          <uix:cellFormat/>
                          <uix:cellFormat hAlign="right">
                              <uix:flowLayout>
                                  <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event"
                                                    value="add"/>
                                  <uix:spacer width="10"/>
                                  <uix:submitButton textBinding="OK@hasBundle@servletRequest" name="event"
                                                    value="continueAddDependency"/>
                              </uix:flowLayout>
                          </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:tableLayout width="80%">
                          <uix:rowLayout>
                              <uix:cellFormat vAlign="left" >
                                  <uix:styledText textBinding="dependencyIntro@servletRequest" styleClass="OraInstructionText"/>
                              </uix:cellFormat>
                          </uix:rowLayout>
                      </uix:tableLayout>
                      </uix:tableLayout>
                  <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                          <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:styledText textBinding="DEPENDENT_ON@resourcesBundle@servletRequest"
                                  styleClass="OraPromptText"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="left">
                                <uix:tableLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:flowLayout>
                                                <uix:contents>
                                                    <uix:radioButton name="depdendentOn" value="resource" onClick="toggleLov('selectResource','selectResourceType');"
                                                                     textBinding="RESOURCE@resourcesBundle@servletRequest" selectedBinding="resourceRadioSelected@dependencyBean@servletRequest" />
                                                    <uix:lovInput name="selectResource" id="selectResource" columns="20"
                                                                  shortDescBinding="SELECT_DEPENDENT_RESOURCE@resourcesBundle@servletRequest"
                                                                  searchDescBinding="SEARCH@hasBundle@servletRequest"
                                                                  partialRenderMode="self" disabledBinding="resourceTypeRadioSelected@dependencyBean@servletRequest"
                                                                  textBinding="displayableResourceName@dependencyBean@servletRequest" destinationBinding="lovDestination@servletRequest"  />
                                                </uix:contents>
                                            </uix:flowLayout>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:flowLayout>
                                                <uix:contents>
                                                    <uix:radioButton name="depdendentOn" value="resourceType" onClick="toggleLov('selectResourceType','selectResource')"
                                                                     textBinding="RESOURCE_TYPE@resourcesBundle@servletRequest" selectedBinding="resourceTypeRadioSelected@dependencyBean@servletRequest"/>
                                                    <uix:lovInput name="selectResourceType" id="selectResourceType" columns="20"
                                                                  shortDescBinding="SELECT_DEPENDENT_RESOURCETYPE@resourcesBundle@servletRequest"
                                                                  destinationBinding="lovDestination@servletRequest" partialRenderMode="self"
                                                                  searchDescBinding="SEARCH@hasBundle@servletRequest"
                                                                  textBinding="displayableResourceTypeName@dependencyBean@servletRequest" formSubmitted="true"/>
                                                </uix:contents>
                                            </uix:flowLayout>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                          </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout/>
                      <uix:rowLayout renderedBinding="mod2Visible@dependencyBean@servletRequest">
                          <uix:cellFormat hAlign="right" vAlign="top">
                              <uix:styledText textBinding="PLACEMENT_DEP_ENTITY@resourcesBundle@servletRequest"
                                  styleClass="OraPromptText"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="left">
                              <uix:tableLayout>
                                  <uix:rowLayout>
                                      <uix:cellFormat>
                                          <uix:radioButton name="mod2"
                                                           textBinding="CO_LOCATE@resourcesBundle@servletRequest"
                                                           value="colocate"
                                                           selectedBinding="colocateSelected@dependencyBean@servletRequest"/>
                                      </uix:cellFormat>
                                  </uix:rowLayout>
                                  <uix:rowLayout>
                                      <uix:cellFormat>
                                          <uix:radioButton name="mod2"
                                                           textBinding="ANYWHERE_IN_THE_CLUSTER@resourcesBundle@servletRequest"
                                                           value="global"
                                                           selectedBinding="globalSelected@dependencyBean@servletRequest"/>
                                      </uix:cellFormat>
                                  </uix:rowLayout>
                              </uix:tableLayout>
                          </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout/>
                      <uix:rowLayout>
                          <uix:cellFormat />
                          <uix:cellFormat hAlign="left" >
                              <uix:checkBox name="mod1" value="mod1Selected" textBinding="mod1Label@dependencyBean@servletRequest"
                                            renderedBinding="mod1Visible@dependencyBean@servletRequest"
                                            checkedBinding="quandarySelected@dependencyBean@servletRequest" />
                          </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout renderedBinding="showPullupCheckbox@dependencyBean@servletRequest">
                          <uix:cellFormat />
                          <uix:cellFormat hAlign="left" >
                              <uix:stackLayout>
                                  <uix:checkBox name="pullupCheckBox" value="pullup" textBinding="PULLUP_CHECKBOX_LABEL@resourcesBundle@servletRequest"
                                                checkedBinding="pullupSelected@dependencyBean@servletRequest" />
                                  <uix:styledText styleClass="OraInlineInfoText" textBinding="PULLUP_START_DEPENDENCY_INTRO@resourcesBundle@servletRequest"/>
                              </uix:stackLayout>
                          </uix:cellFormat>
                      </uix:rowLayout>

                  </uix:tableLayout>
                <uix:tableLayout width="100%">
                    <uix:rowLayout>
                        <uix:cellFormat>
                            <uix:tip textBinding="DEPENDENT_RESOURCE_TIP@resourcesBundle@servletRequest"/>
                        </uix:cellFormat>
                    </uix:rowLayout>
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat hAlign="right">
                        <uix:flowLayout>
                            <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event"
                                              value="add"/>
                            <uix:spacer width="10"/>
                            <uix:submitButton textBinding="OK@hasBundle@servletRequest" name="event"
                                              value="continueAddDependency"/>
                        </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:contents>
            </uix:stackLayout>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
