<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <uix:body>
      <db:form name="credentials" method="POST"
               destinationBinding="destination@servletRequest"
               copyParams="target,type,isRepDown">
        <uix:switcher childNameBinding="return2dbPage@servletRequest"
                      defaultCase="false">
          <uix:case name="true">
            <uix:formValue name="return2dbPage" value="true"/>
          </uix:case>
          <uix:case name="false">
            <uix:formValue name="return2dbPage" value="false"/>
          </uix:case>
        </uix:switcher>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                            errorTableBinding="msgBox@servletRequest"
                            destTableBinding="msgUrls@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:stackLayout>
            <uix:contents>
              <uix:header messageType="confirmation"
                          textBinding="credsPageHeader@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                      <uix:cellFormat>
                          <uix:switcher childNameBinding="showBackendCommand@servletRequest"
                                        defaultCase="show">
                              <uix:case name="hide">
                                  <uix:tableLayout width="100%">
                                      <uix:rowLayout>
                                          <uix:cellFormat hAlign="left">
                                              <uix:styledText styleClass="OraInstructionText"
                                                              textBinding="credsPageDesc@servletRequest"/>
                                          </uix:cellFormat>
                                          <uix:cellFormat hAlign="right">
                                              <uix:flowLayout>
                                                  <uix:switcher childNameBinding="linkCancelButton@servletRequest"
                                                                defaultCase="false">
                                                      <uix:case name="true">
                                                          <uix:button
                                                                  textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                                  destinationBinding="returnURL@servletRequest"/>
                                                      </uix:case>
                                                      <uix:case name="false">
                                                          <uix:submitButton
                                                                  textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                                  name="event"
                                                                  value="reLoad"/>
                                                      </uix:case>
                                                  </uix:switcher>
                                                  <uix:spacer width="10"/>
                                                  <uix:submitButton
                                                          textBinding="CONTINUE_BUTTON@hasBundle@servletRequest"
                                                          name="event"
                                                          valueBinding="finishEvent@servletRequest"/>
                                              </uix:flowLayout>
                                          </uix:cellFormat>
                                          <uix:cellFormat>
                                              <uix:spacer width="5"/>
                                          </uix:cellFormat>
                                      </uix:rowLayout>
                                  </uix:tableLayout>
                              </uix:case>
                              <uix:case name="show">
                                  <uix:tableLayout width="100%">
                                      <uix:rowLayout>
                                          <uix:cellFormat hAlign="left">
                                              <uix:styledText styleClass="OraInstructionText"
                                                              textBinding="BACKEND_COMMAND@hasBundle@servletRequest"/>
                                          </uix:cellFormat>
                                          <uix:cellFormat hAlign="right">
                                              <uix:flowLayout>
                                                  <uix:switcher childNameBinding="linkCancelButton@servletRequest">
                                                      <uix:case name="true">
                                                          <uix:button
                                                                  textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                                  destinationBinding="returnURL@servletRequest"/>
                                                      </uix:case>
                                                      <uix:case name="false">
                                                          <uix:submitButton
                                                                  textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                                  name="event"
                                                                  value="reLoad"/>
                                                      </uix:case>
                                                  </uix:switcher>
                                                  <uix:spacer width="10"/>
                                                  <uix:submitButton
                                                          textBinding="CONTINUE_BUTTON@hasBundle@servletRequest"
                                                          name="event"
                                                          valueBinding="finishEvent@servletRequest"/>
                                              </uix:flowLayout>
                                          </uix:cellFormat>
                                          <uix:cellFormat>
                                              <uix:spacer width="5"/>
                                          </uix:cellFormat>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                          <uix:cellFormat>
                                              <uix:styledText styleClass="OraInstructionText"
                                                              textBinding="backEndCommand@servletRequest"/>
                                          </uix:cellFormat>
                                      </uix:rowLayout>
                                      <uix:rowLayout>
                                          <uix:spacer height="10"/>
                                      </uix:rowLayout>

                                      <uix:rowLayout>
                                          <uix:cellFormat hAlign="left">
                                              <uix:formattedText styleClass="OraInstructionText"
                                                                 textBinding="credsPageDesc@servletRequest"/>
                                          </uix:cellFormat>
                                      </uix:rowLayout>

                                  </uix:tableLayout>
                              </uix:case>
                          </uix:switcher>
                      </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                      <uix:cellFormat><uix:spacer height="10"/> </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:switcher childNameBinding="showForceOption@servletRequest" defaultCase="false">
                      <uix:case name="true">
                          <uix:stackLayout>
                              <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:flowLayout>
                                        <uix:checkBox name="forceOption" value="true" selectedValueBinding="forceOption@servletRequest"/>
                                        <uix:spacer width="5"/>
                                      <uix:styledText styleClass="OraInstructionText"
                                                      textBinding="forceOptionDesc@servletRequest"/>
                                    </uix:flowLayout>
                                </uix:cellFormat>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:styledText styleClass="OraInlineInfoText" textBinding="forceOptionTip@servletRequest"/>
                                </uix:cellFormat>
                              </uix:rowLayout>
                          </uix:stackLayout>
                      </uix:case>
                      <uix:case name="false"/>
                  </uix:switcher>
                  <uix:switcher childNameBinding="showIOption@servletRequest" defaultCase="false">
                      <uix:case name="true">
                          <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:flowLayout>
                                    <uix:checkBox name="iOption" value="true" selectedValueBinding="iOption@servletRequest"/>
                                    <uix:spacer width="5"/>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="iOptionDesc@servletRequest"/>
                                </uix:flowLayout>
                            </uix:cellFormat>
                          </uix:rowLayout>
                      </uix:case>
                      <uix:case name="false"/>
                  </uix:switcher>

                </uix:tableLayout>
                <uix:header textBinding="SPECIFY_CLUSTER_CREDENTIALS@hasBundle@servletRequest"
                            renderedBinding="showOverrideCreds@servletRequest">
                  <uix:spacer height="8"/>
                  <%@ include file="/credentials.jspf"%>
                </uix:header>
              </uix:header>
            </uix:contents>
          </uix:stackLayout>
          <uix:contentFooter>
            <uix:pageButtonBar renderedBinding="showOverrideCreds@servletRequest">
              <uix:spacer width="10"/>
              <uix:flowLayout>
                <uix:switcher childNameBinding="linkCancelButton@servletRequest">
                  <uix:case name="true">
                    <uix:button textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                destinationBinding="returnURL@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                      name="event" value="reLoad"/>
                  </uix:case>
                </uix:switcher>
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="CONTINUE_BUTTON@hasBundle@servletRequest"
                                  name="event"
                                  valueBinding="finishEvent@servletRequest"/>
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
