<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext"> 
<oem:setURLEncoder id="renderingContext"/> 

  <uix:document> 
    
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
       <db:form name="credentials" method="POST" destinationBinding="destination@servletRequest" copyParams="target,type,isRepDown">            
<uix:formValue name="returnURL" valueBinding="returnURL@servletRequest"/>
<uix:formValue name="dbTargetName" valueBinding="dbTargetNameReqParam@servletRequest"/>
<uix:formValue name="dbName" valueBinding="dbNameReqParam@servletRequest"/>
<uix:formValue name="dbHome" valueBinding="dbHomeReqParam@servletRequest"/>
<uix:formValue name="lsnrName" valueBinding="lsnrName@servletRequest"/>
<uix:formValue name="lsnrTargetName" valueBinding="lsnrTargetName@servletRequest"/>
<uix:formValue name="lsnrHome" valueBinding="lsnrHome@servletRequest"/>
<uix:formValue name="endPoint" valueBinding="endPoint@servletRequest"/>
<uix:formValue name="sgName" valueBinding="sgName@servletRequest"/>
<uix:formValue name="loginEvent" valueBinding="loginAction@servletRequest"/>
<uix:formValue name="afterLoginEvent" valueBinding="afterLoginEvent@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

  <uix:messages>
     <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                     errorTableBinding="msgBox@servletRequest"
                     destTableBinding="msgUrls@servletRequest"
                     titleTextKey="titleText" mainTextKey="mainText"/>
  </uix:messages>
          
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="credsPageHeader@servletRequest">
                <uix:tableLayout width="100%">
          	      <uix:rowLayout>
	                  <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraInstructionText" textBinding="credsPageDesc@servletRequest" />
	                  </uix:cellFormat>

	                  <uix:cellFormat hAlign="left">
                      <uix:spacer width="5"/>
	                  </uix:cellFormat>

          	        <uix:cellFormat hAlign="right">
        	    <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event" value="loginCancel" />
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="LOGIN_BUTTON@hasBundle@servletRequest"  name="event" valueBinding="loginAction@servletRequest" /> 
              </uix:flowLayout>

        	          </uix:cellFormat>

                		<uix:cellFormat>
                		  <uix:spacer width="5" />
                		</uix:cellFormat>

         	        </uix:rowLayout>
	              </uix:tableLayout>

                  <uix:spacer height="8" />
                  <%@ include file="/credentials.jspf" %>
     
              </uix:header>
            </uix:contents>
          </uix:stackLayout>

          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
        	    <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event" value="loginCancel" />
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="LOGIN_BUTTON@hasBundle@servletRequest"  name="event" valueBinding="loginAction@servletRequest" /> 
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>


        </uix:pageLayout>  
      </db:form>

    </uix:body>
  </uix:document> 
</uix:renderingContext>
