<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

  <%@ include file="/oemTitle.jspf" %>

  <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
    <db:form name="foo" destination="/em/console/has/resourceTypes" method="post" 
      copyParams="target,type,isRepDown">
<%-- this is required for refresh event.  --%>
<uix:formValue name="returnURL" valueBinding="returnURL@defaultBean@servletRequest"/>
  <uix:pageLayout>
  <%@ include file="/database/global.jspf" %>

<uix:messages>
    <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                       errorTableBinding="msgBox@servletRequest"
                       destTableBinding="msgUrls@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

      <uix:header textBinding="RESOURCE_TYPES_LIST@resourcesBundle@servletRequest">

	    <%-- page refresh time / refresh button --%>
	    <uix:tableLayout width="100%">
	    <uix:rowLayout>

  	    <uix:cellFormat hAlign="right" vAlign="top" width="35%">
	       <uix:flowLayout>
	         <uix:styledText styleClass="OraTipText" 
	              textBinding="PAGE_REFRESHED@hasBundle@servletRequest"/>
	         <uix:spacer width="5" />  

	         <uix:styledText styleClass="OraTipLabel" 
	              textBinding="refreshTime@defaultBean@servletRequest"/>

	         <uix:spacer width="5" />  
   	         <uix:submitButton textBinding="REFRESH_BUTTON@hasBundle@servletRequest" name="event" value="doLoad"/>

	      </uix:flowLayout>
            </uix:cellFormat> 	    
	    </uix:rowLayout> 	    
	  </uix:tableLayout>	    


        <uix:stackLayout>
          <uix:contents>
          
          <uix:tableLayout width="100%" cellSpacing="2">

              <%-- Intro --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="3">
                  <uix:styledText textBinding="RESOURCE_TYPES_MASTER_DESC@resourcesBundle@servletRequest" 
                    styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
              <uix:spacer height="5"/>
              </uix:rowLayout>

              <%-- Show Internal Resources Check Box --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="3">
                  <uix:checkBox textBinding="SHOW_INTERNAL_RESOURCE_TYPES@resourcesBundle@servletRequest" name="showInternalResourceTypes" checkedBinding="showInternalResourceTypes@defaultBean@servletRequest" shortDescBinding="SHOW_INTERNAL_RESOURCE_TYPES@resourcesBundle@servletRequest" onClick="submitForm(document.forms[0], true, {'event':'toggleInternalResourceTypes'})"/>
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:tableLayout width="100%">
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat hAlign="right">
                      <uix:pageButtonBar>
                        <uix:submitButton textBinding="ADD@hasBundle@servletRequest" name="event" value="add"/>
                      </uix:pageButtonBar>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:rowLayout>

              <%-- Resources Table --%>
              <uix:rowLayout>
              <oem:table name="resourceTypesTable"
                   width="100%" blockSize="50"
                   dataSourceProp="resourceTypesTable"
                   beanKey="defaultBean"
                   alternateTextBinding="emptyTableMessage@defaultBean@servletRequest"
                   formSubmitted="true"
		               summaryBinding="RESOURCE_TYPES_MASTER_DESC@resourcesBundle@servletRequest">
                   <uix:tableSelection>
                      <uix:multipleSelection shortDescBinding="SELECT@hasBundle@servletRequest" selectionBinding="selectedIndexes@defaultBean@servletRequest" selectedBinding="isSelected">
      
                          <uix:submitButton textBinding="RESOURCES_VIEW@resourcesBundle@servletRequest" name="event" value="view"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="EDIT@hasBundle@servletRequest" name="event" value="edit"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="REMOVE@hasBundle@servletRequest" name="event" value="DELETE" />
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="ADD_RESOURCE@resourcesBundle@servletRequest" name="event" value="addResOfType" />

                     </uix:multipleSelection>
                  </uix:tableSelection>
              </oem:table>
              </uix:rowLayout>

	  <uix:spacer height="20" />
          <%-- Return Button --%>
          <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right">
          <uix:button textBinding="RETURN@hasBundle@servletRequest" destinationBinding="returnURL@defaultBean@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
                                                                            
             </uix:tableLayout>
          </uix:contents>
        </uix:stackLayout>
        </uix:header> 


      </uix:pageLayout>
    </db:form>
  </uix:body>
  </uix:document>
</uix:renderingContext>
