<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <uix:body>
      <db:form name="addResForm" method="post"
               destinationBinding="addDestination@addRes@servletRequest"
               copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                            errorTableBinding="msgBox@servletRequest"
                            destTableBinding="msgUrls@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="addHeader@addRes@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="reLoadAfterReset"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="finishAdd"/>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
</uix:tableLayout>
                <uix:spacer width="5"/>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="3">
                <uix:link textBinding="GENERAL@resourcesBundle@servletRequest" onClick="submitForm('addResForm', true, {event:'add',pageNum:'1'})"/>
                  <uix:switcher childNameBinding="requiredForParametersTab@resource@addRes@servletRequest">
                      <uix:case name="true">
                          <uix:link textBinding="PARAMETERS_STAR@resourcesBundle@servletRequest"   onClick="submitForm('addResForm', true, {event:'add',pageNum:'2'})"/>
                      </uix:case>
                      <uix:case name="false">
                          <uix:link textBinding="PARAMETERS@resourcesBundle@servletRequest"   onClick="submitForm('addResForm', true, {event:'add',pageNum:'2'})"/>
                      </uix:case>
                  </uix:switcher>
                  <uix:link textBinding="ADVANCED_SETTINGS@resourcesBundle@servletRequest"   onClick="submitForm('addResForm', true, {event:'add',pageNum:'4'})"  renderedBinding="resourceWizard@addRes@servletRequest"/>
                  <uix:switcher childNameBinding="requiredForDependencyTab@resource@addRes@servletRequest">
                      <uix:case name="true">
                          <uix:link textBinding="DEPENDENCIES_STAR@resourcesBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                          <uix:link textBinding="DEPENDENCIES@resourcesBundle@servletRequest"/>
                      </uix:case>
                  </uix:switcher>
</uix:subTabBar>
</uix:subTabs>

<uix:header textBinding="START_DEPENDENCIES@resourcesBundle@servletRequest">
<uix:spacer height="10"/>
<uix:flowLayout>
<%--<uix:submitButton textBinding="ADD_HARD_START_DEPENDENCY@resourcesBundle@servletRequest" name="event" value="addHardStartDependency"/>--%>
<%--<uix:submitButton textBinding="ADD_WEAK_START_DEPENDENCY@resourcesBundle@servletRequest" name="event" value="addWeakStartDependency"/>--%>
<%--<uix:submitButton textBinding="ADD_ATTRACTION_START_DEPENDENCY@resourcesBundle@servletRequest" name="event" value="addAttractionStartDependency"/>--%>
<%--<uix:submitButton textBinding="ADD_PULLUP_START_DEPENDENCY@resourcesBundle@servletRequest" name="event" value="addPullupStartDependency"/>--%>
<%--<uix:submitButton textBinding="ADD_DISPERSION_START_DEPENDENCY@resourcesBundle@servletRequest" name="event" value="addDispersionStartDependency"/>--%>
    <uix:messagePrompt promptBinding="ADD@resourcesBundle@servletRequest"  labeledNodeId="addStartDependencyType"
                       requiredBinding="startDependencyMandatory@addRes@servletRequest" styleClass="OraInstructionText"/>
    <uix:spacer width="10"/>
    <uix:list size="1" name="addStartDependencyType" id="addStartDependencyType">
        <uix:option textBinding="HARD_DEPENDENCY@resourcesBundle@servletRequest" value="addHardStartDependency" />
        <uix:option textBinding="WEAK_DEPENDENCY@resourcesBundle@servletRequest" value="addWeakStartDependency" />
        <uix:option textBinding="ATTRACTION_DEPENDENCY@resourcesBundle@servletRequest" value="addAttractionStartDependency" />
        <uix:option textBinding="PULLUP_DEPENDENCY@resourcesBundle@servletRequest" value="addPullupStartDependency" />
        <uix:option textBinding="DISPERSION_DEPENDENCY@resourcesBundle@servletRequest" value="addDispersionStartDependency" />
    </uix:list>
    <uix:spacer width="10"/>
    <uix:submitButton textBinding="GO_BUTTON@resourcesBundle@servletRequest" name="event" value="addStartDependency" disabledBinding="startDependencyReadOnly@addRes@servletRequest" />
</uix:flowLayout>
    
<uix:spacer height="10"/>
<uix:table name="startDependencies" width="100%" tableDataBinding="startDependencies@resource@addRes@servletRequest"
        summaryBinding="START_DEPENDENCY_TABLE_SUMMARY@resourcesBundle@servletRequest"
           alternateTextBinding="NO_START_DEP_MSG@resourcesBundle@servletRequest">
    <uix:tableSelection>
        <uix:singleSelection shortDescBinding="SELECT@hasBundle@servletRequest">
    <uix:submitButton textBinding="REMOVE@hasBundle@servletRequest" name="event" value="deleteStartDependency"
            disabledBinding="startDependencyReadOnly@addRes@servletRequest"/>
        </uix:singleSelection>
    </uix:tableSelection> 
          <uix:column>
            <uix:columnHeader> 
              <uix:styledText textBinding="DEPENDENCY_TYPE@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="type"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:styledText textBinding="DEPENDENT_ON@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="entityName"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:styledText textBinding="MODIFIERS@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="modifiers"/>
               </uix:contents>             
          </uix:column>
</uix:table>
</uix:header>

<uix:header textBinding="STOP_DEPENDENCIES@resourcesBundle@servletRequest">
<uix:spacer height="10"/>
<uix:flowLayout>
    <%--<uix:list size="1" name="addStopDependencyType" id="addStopDependencyType">--%>
        <uix:formValue name="addStopDependencyType" value="addHardStopDependency" />
    <%--</uix:list>--%>
    <uix:submitButton textBinding="ADD_HARD_STOP_DEPENDENCY@resourcesBundle@servletRequest" name="event" value="addStopDependency"
            disabledBinding="stopDependencyReadOnly@addRes@servletRequest"/>
</uix:flowLayout>
<uix:spacer height="10"/>
<uix:table name="stopDependencies" width="100%" tableDataBinding="stopDependencies@resource@addRes@servletRequest"
           summaryBinding="STOP_DEPENDENCY_TABLE_SUMMARY@resourcesBundle@servletRequest"
           alternateTextBinding="NO_STOP_DEP_MSG@resourcesBundle@servletRequest">
    <uix:tableSelection>
        <uix:singleSelection shortDescBinding="SELECT@hasBundle@servletRequest">
    <uix:submitButton textBinding="REMOVE@hasBundle@servletRequest" name="event" value="deleteStopDependency"
            disabledBinding="stopDependencyReadOnly@addRes@servletRequest"/>
        </uix:singleSelection>
    </uix:tableSelection>
          <uix:column>
            <uix:columnHeader> 
              <uix:styledText textBinding="DEPENDENCY_TYPE@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="type"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:styledText textBinding="DEPENDENT_ON@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="entityName"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:styledText textBinding="MODIFIERS@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="modifiers"/>
               </uix:contents>             
          </uix:column>
</uix:table>

</uix:header>


</uix:subTabLayout>
              </uix:header>
            </uix:contents>
          </uix:stackLayout>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
              <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                  name="event" value="reLoadAfterReset"/>
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                  name="event" value="finishAdd"/>
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
