<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <uix:body>
      <db:form name="addResForm" method="post"
               destinationBinding="addDestination@addRes@servletRequest"
               copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                            errorTableBinding="msgBox@servletRequest"
                            destTableBinding="msgUrls@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:formValue name="pageNum" valueBinding="pageNum@servletRequest"/>
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="addHeader@addRes@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="reLoadAfterReset"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="finishAdd"/>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
</uix:tableLayout>
                <uix:spacer width="5"/>

          <uix:subTabLayout>
            <uix:subTabs>
              <uix:subTabBar selectedIndex="1">
                <uix:link textBinding="GENERAL@resourcesBundle@servletRequest"   onClick="submitForm('addResForm', true, {event:'add',pageNum:'1'})"/>
                  <uix:switcher childNameBinding="requiredForParametersTab@resource@addRes@servletRequest">
                      <uix:case name="true">
                          <uix:link textBinding="PARAMETERS_STAR@resourcesBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                          <uix:link textBinding="PARAMETERS@resourcesBundle@servletRequest"/>
                      </uix:case>
                  </uix:switcher>
                  <uix:link textBinding="ADVANCED_SETTINGS@resourcesBundle@servletRequest"   onClick="submitForm('addResForm', true, {event:'add',pageNum:'4'})"  renderedBinding="resourceWizard@addRes@servletRequest"/>
                  <uix:switcher childNameBinding="requiredForDependencyTab@resource@addRes@servletRequest">
                      <uix:case name="true">
                          <uix:link textBinding="DEPENDENCIES_STAR@resourcesBundle@servletRequest"  onClick="submitForm('addResForm', true, {event:'add',pageNum:'3'})"/>
                      </uix:case>
                      <uix:case name="false">
                          <uix:link textBinding="DEPENDENCIES@resourcesBundle@servletRequest"  onClick="submitForm('addResForm', true, {event:'add',pageNum:'3'})"/>
                      </uix:case>
                  </uix:switcher>
</uix:subTabBar>
</uix:subTabs>

            <uix:tableLayout width="100%">
            <uix:rowLayout>
            <uix:header textBinding="START_PARAMETERS_HEADER@resourcesBundle@servletRequest">
            <uix:tableLayout width="95%">
            <uix:rowLayout>
                <uix:cellFormat columnSpan="5">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="START_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top">
                    <uix:messagePrompt requiredBinding="autoStartMandatory@addRes@servletRequest"
                                       promptBinding="AUTO_START@resourcesBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:stackLayout>
                        <uix:radioButton name="autoStart" value="restore" 
                                         disabledBinding="autoStartReadOnly@addRes@servletRequest"
                                         selectedValueBinding="stringValue@autoStart@resource@addRes@servletRequest"
                                         textBinding="RESTORE@resourcesBundle@servletRequest"/>
                        <uix:radioButton name="autoStart" value="never"
                                         disabledBinding="autoStartReadOnly@addRes@servletRequest"
                                         selectedValueBinding="stringValue@autoStart@resource@addRes@servletRequest"
                                         textBinding="NEVER@resourcesBundle@servletRequest"/>
                        <uix:radioButton name="autoStart" value="always"
                                         disabledBinding="autoStartReadOnly@addRes@servletRequest"
                                         selectedValueBinding="stringValue@autoStart@resource@addRes@servletRequest"
                                         textBinding="ALWAYS@resourcesBundle@servletRequest"/>
                    </uix:stackLayout>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="restartAttempts"
                                       requiredBinding="restartAttemptsMandatory@addRes@servletRequest"
                                       promptBinding="RESTART_ATTEMPTS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:messageTextInput name="restartAttempts" id="restartAttempts"
                                   disabledBinding="restartAttemptsReadOnly@addRes@servletRequest"
                                   textBinding="stringValue@restartAttempts@resource@addRes@servletRequest"
                                   shortDescBinding="RESTART_ATTEMPTS_HELP@resourcesBundle@servletRequest">
                        <uix:onBlurValidater>
                            <uix:decimal minValue="0"/>
                        </uix:onBlurValidater>
                        </uix:messageTextInput>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="startTimeout"
                                       requiredBinding="startTimeout@addRes@servletRequest"
                                       promptBinding="START_TIMEOUT@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:messageTextInput name="startTimeout" id="startTimeout"
                                   disabledBinding="startTimeoutReadOnly@addRes@servletRequest"
                                   textBinding="stringValue@startTimeout@resource@addRes@servletRequest"
                                   shortDescBinding="START_TIMEOUT_HELP@resourcesBundle@servletRequest">
                     <uix:onBlurValidater>
                         <uix:decimal minValue="0"/>
                     </uix:onBlurValidater>
                 </uix:messageTextInput>

                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="uptimeThreshold"
                                       requiredBinding="uptimeThresholdMandatory@addRes@servletRequest"
                                       promptBinding="UPTIME_THRESHOLD@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:flowLayout>
                        <uix:textInput name="uptimeThresholdData" id="uptimeThreshold"
                                       disabledBinding="uptimeThresholdReadOnly@addRes@servletRequest"
                                       textBinding="uptimeThresholdData@resource@addRes@servletRequest"
                                       shortDescBinding="UPTIME_THRESHOLD_HELP@resourcesBundle@servletRequest"
                                       columns="10">
                            <uix:onBlurValidater>
                                <uix:decimal minValue="0"/>
                            </uix:onBlurValidater>
                        </uix:textInput>

                        <uix:spacer width="5"/>
                        <uix:choice name="uptimeThresholdUnit"
                                    disabledBinding="uptimeThresholdReadOnly@addRes@servletRequest"
                                    selectedValueBinding="uptimeThresholdUnit@resource@addRes@servletRequest">
                            <uix:option textBinding="SECONDS@resourcesBundle@servletRequest" value="s"/>
                            <uix:option textBinding="MINUTES@resourcesBundle@servletRequest" value="m"/>
                            <uix:option textBinding="HOURS@resourcesBundle@servletRequest" value="h"/>
                            <uix:option textBinding="DAYS@resourcesBundle@servletRequest" value="d"/>
                            <uix:option textBinding="WEEKS@resourcesBundle@servletRequest" value="w"/>
                        </uix:choice>
                    </uix:flowLayout>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>
            </uix:tableLayout>
            </uix:header>
            </uix:rowLayout>

            <%-- Stop Parameters --%>
            <uix:rowLayout>
                <uix:header textBinding="STOP_PARAMETERS_HEADER@resourcesBundle@servletRequest">
                    <uix:tableLayout width="75%">
                        <uix:rowLayout>
                            <uix:cellFormat columnSpan="5">
                                <uix:styledText styleClass="OraInstructionText"
                                                textBinding="STOP_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="15"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:messagePrompt labeledNodeId="stopTimeout"
                                                   requiredBinding="stopTimeoutMandatory@addRes@servletRequest"
                                                   promptBinding="STOP_TIMEOUT@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                                <uix:messageTextInput name="stopTimeout" id="stopTimeout"
                                               disabledBinding="stopTimeoutReadOnly@addRes@servletRequest"
                                               textBinding="stringValue@stopTimeout@resource@addRes@servletRequest"
                                               shortDescBinding="STOP_TIMEOUT_HELP@resourcesBundle@servletRequest">
                                    <uix:onBlurValidater>
                                        <uix:decimal minValue="0"/>
                                    </uix:onBlurValidater>
                                </uix:messageTextInput>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout vAlign="top">
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                            </uix:cellFormat>
                        </uix:rowLayout>


                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="15"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                </uix:header>
            </uix:rowLayout>
            <%-- Status Parameters --%>
            <uix:rowLayout>
            <uix:header textBinding="STATUS_PARAMETERS_HEADER@resourcesBundle@servletRequest">
            <uix:tableLayout width="62%">
            <uix:rowLayout>
                <uix:cellFormat columnSpan="5">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="STATUS_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="checkInterval"
                                       requiredBinding="checkIntervalMandatory@addRes@servletRequest"
                                       promptBinding="CHECK_INTERVAL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:messageTextInput name="checkInterval" id="checkInterval"
                                   disabledBinding="checkIntervalReadOnly@addRes@servletRequest"
                                   textBinding="stringValue@checkInterval@resource@addRes@servletRequest"
                                   shortDescBinding="CHECK_INTERVAL_HELP@resourcesBundle@servletRequest">
                        <uix:onBlurValidater>
                            <uix:decimal minValue="0"/>
                        </uix:onBlurValidater>
                    </uix:messageTextInput>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="scriptTimeout"
                                       requiredBinding="scriptTimeoutMandatory@addRes@servletRequest"
                                       promptBinding="SCRIPT_TIMEOUT@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:messageTextInput name="scriptTimeout" id="scriptTimeout"
                                   disabledBinding="scriptTimeoutReadOnly@addRes@servletRequest"
                                   textBinding="stringValue@scriptTimeout@resource@addRes@servletRequest"
                                   shortDescBinding="SCRIPT_TIMEOUT_HELP@resourcesBundle@servletRequest">
                        <uix:onBlurValidater>
                            <uix:decimal minValue="0"/>
                        </uix:onBlurValidater>
                    </uix:messageTextInput>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
            </uix:rowLayout>


            <uix:rowLayout renderedBinding="global@addRes@servletRequest">
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout renderedBinding="global@addRes@servletRequest">
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="failureThreshold"
                                       requiredBinding="failureThresholdMandatory@addRes@servletRequest"
                                       promptBinding="FAILURE_THRESHOLD@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:messageTextInput name="failureThreshold" id="failureThreshold"
                                   disabledBinding="failureThresholdReadOnly@addRes@servletRequest"
                                   textBinding="stringValue@failureThreshold@resource@addRes@servletRequest"
                                   shortDescBinding="FAILURE_THRESHOLD_HELP@resourcesBundle@servletRequest">
                        <uix:onBlurValidater>
                            <uix:decimal minValue="0"/>
                        </uix:onBlurValidater>
                    </uix:messageTextInput>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top" renderedBinding="global@addRes@servletRequest">
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout renderedBinding="global@addRes@servletRequest">
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout renderedBinding="global@addRes@servletRequest">
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="failureInterval"
                                       requiredBinding="failureIntervalMandatory@addRes@servletRequest"
                                       promptBinding="FAILURE_INTERVAL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:messageTextInput name="failureInterval" id="failureInterval"
                                   disabledBinding="failureIntervalReadOnly@addRes@servletRequest"
                                   textBinding="stringValue@failureInterval@resource@addRes@servletRequest"
                                   shortDescBinding="FAILURE_INTERVAL_HELP@resourcesBundle@servletRequest">
                        <uix:onBlurValidater>
                            <uix:decimal minValue="0"/>
                        </uix:onBlurValidater>
                    </uix:messageTextInput>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top" renderedBinding="global@addRes@servletRequest">
                <uix:cellFormat hAlign="right">
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat>
                    <uix:spacer height="15"/>
                </uix:cellFormat>
            </uix:rowLayout>
            </uix:tableLayout>
            </uix:header>
            </uix:rowLayout>


            <%-- Offline Parameters --%>
            <uix:rowLayout>
                <uix:header textBinding="OFFLINE_MONITORING@resourcesBundle@servletRequest">
                    <uix:tableLayout width="55%">

                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="15"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                                <uix:messagePrompt labeledNodeId="offlineCheckMonitor"
                                                   requiredBinding="offlineCheckMonitorMandatory@addRes@servletRequest"
                                                   promptBinding="OFFLINE_CHECK_INTERVAL@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                                <uix:messageTextInput name="offlineCheckMonitor" id="offlineCheckMonitor"
                                               disabledBinding="offlineCheckMonitorReadOnly@addRes@servletRequest"
                                               textBinding="stringValue@offlineCheckInterval@resource@addRes@servletRequest"
                                               shortDescBinding="OFFLINE_CHECK_INTERVAL_TIP@resourcesBundle@servletRequest">
                                    <uix:onBlurValidater>
                                        <uix:decimal minValue="0"/>
                                    </uix:onBlurValidater>
                                </uix:messageTextInput>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout vAlign="top">
                            <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                                <uix:spacer width="5"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat>
                                <uix:spacer height="15"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                </uix:header>
            </uix:rowLayout>
            <uix:rowLayout >
                <uix:header textBinding="USER_DEFINED_ATTRIBUTES@resourcesBundle@servletRequest" renderedBinding="showUDParamSection@addRes@servletRequest">
                    <uix:stackLayout>
                    <uix:switcher childNameBinding="resourceWizard@addRes@servletRequest">
                        <uix:case name="true">
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="UDP_RES_INTRO@resourcesBundle@servletRequest"/>
                        </uix:case>
                        <uix:case name="false">
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="UDP_RT_INTRO@resourcesBundle@servletRequest"/>
                        </uix:case>
                    </uix:switcher>
                        <uix:spacer height="15"/>
                        <uix:switcher childNameBinding="resourceWizard@addRes@servletRequest">
                            <uix:case name="true">
                                <uix:table name="udParamTable" 
                                           tableDataBinding="allUserDefinedAttrs@resource@addRes@servletRequest"
                                           partialRenderMode="self" formSubmitted="false"
                                           summaryBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest"
                                           shortDescBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest">
                                    <uix:tableFormat tableBanding="rowBanding"/>
                                    <uix:column shortDescBinding="UDP_NAME_DESC@resourcesBundle@servletRequest">
                                        <uix:columnHeader >
                                            <uix:styledText textBinding="UDP_NAME@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <uix:styledText  textBinding="name"/>
                                            <uix:formValue name="udParamNameHidden" valueBinding="name"/>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:column shortDescBinding="UDP_TYPE_DESC@resourcesBundle@servletRequest">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_TYPE@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <%--<uix:radioButton name="udParamType" text="text" valueBinding="type" selectedValue="string"/>--%>
                                            <%--<uix:radioButton name="udParamType" text="number" valueBinding="type" selectedValue="int"/>--%>
                                            <uix:styledText textBinding="type"/>
                                            <uix:formValue name="udParamType" valueBinding="type"/>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:column
                                            shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_DEFAULT_VALUE@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <uix:switcher childNameBinding="editOperation@addRes@servletRequest">
                                                <uix:case name="false">
                                                    <uix:switcher childNameBinding="type" defaultCase="string">
                                                        <uix:case name="int">
                                                            <uix:messageTextInput name="udParamValue" textBinding="stringValue" requiredBinding="mandatoryBoolean"
                                                                    shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest">
                                                                <uix:onBlurValidater>
                                                                    <uix:regExp pattern="[-]?[0-9]*" />
                                                                </uix:onBlurValidater>
                                                            </uix:messageTextInput>
                                                        </uix:case>
                                                        <uix:case name="string">
                                                            <uix:messageTextInput name="udParamValue" textBinding="stringValue" requiredBinding="mandatoryBoolean"
                                                                    shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest"/>
                                                        </uix:case>
                                                    </uix:switcher>
                                                </uix:case>
                                                <uix:case name="true">
                                                    <uix:switcher childNameBinding="type" defaultCase="string">
                                                        <uix:case name="int">
                                                            <uix:messageTextInput name="udParamValue" textBinding="stringValue" requiredBinding="mandatoryBoolean"
                                                                           readOnlyBinding="readOnlyBoolean"
                                                                    shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest">
                                                                <uix:onBlurValidater>
                                                                    <uix:regExp pattern="[-]?[0-9]*" />
                                                                </uix:onBlurValidater>
                                                            </uix:messageTextInput>
                                                        </uix:case>
                                                        <uix:case name="string">
                                                            <uix:messageTextInput name="udParamValue" textBinding="stringValue" requiredBinding="mandatoryBoolean"
                                                                           readOnlyBinding="readOnlyBoolean"
                                                                    shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest"/>
                                                        </uix:case>
                                                    </uix:switcher>
                                                </uix:case>
                                            </uix:switcher>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:footer>
                                        <uix:tableFooter>
                                            <uix:contents>
                                            </uix:contents>
                                        </uix:tableFooter>
                                    </uix:footer>
                                </uix:table>
                            </uix:case>
                            <uix:case name="false">
                                <uix:table  name="udParamTable"
                                           tableDataBinding="userDefinedAttributes@addRes@servletRequest"
                                           partialRenderMode="self" formSubmitted="false"
                                           shortDescBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest"
                                           alternateTextBinding="UDP_EMPTY_TABLE_DESC@resourcesBundle@servletRequest"
                                            summaryBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest">
                                    <uix:tableFormat tableBanding="rowBanding"/>
                                    <uix:tableActions>
                                        <uix:submitButton textBinding="UDP_ADD_NEW_PARAM@resourcesBundle@servletRequest" name="event" value="addUDParam"/>
                                    </uix:tableActions>
                                    <uix:tableSelection >
                                        <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@hasBundle@servletRequest">
                                            <uix:submitButton textBinding="REMOVE@hasBundle@servletRequest" name="event"
                                                              value="deleteUDParam"/>
                                        </uix:singleSelection>
                                    </uix:tableSelection>
                                    <uix:column shortDescBinding="UDP_NAME_DESC@resourcesBundle@servletRequest">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_NAME@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <uix:messageTextInput name="udParamName" textBinding="name"
                                                           shortDescBinding="UDP_NAME_DESC@resourcesBundle@servletRequest"
                                                           disabledBinding="nameDisabled"/>
                                            <uix:formValue name="udParamNameHidden" valueBinding="name"/>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:column shortDescBinding="UDP_TYPE_DESC@resourcesBundle@servletRequest">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_TYPE@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <%--<uix:radioButton name="udParamType" text="text" valueBinding="type" selectedValue="string"/>--%>
                                            <%--<uix:radioButton name="udParamType" text="number" valueBinding="type" selectedValue="int"/>--%>
                                            <uix:choice name="udParamType" selectedValueBinding="type">
                                                <uix:contents>
                                                    <uix:option textBinding="UDP_TYPE_TEXT@resourcesBundle@servletRequest" value="string"/>
                                                    <uix:option textBinding="UDP_TYPE_NUMBER@resourcesBundle@servletRequest" value="int"/>
                                                </uix:contents>
                                            </uix:choice>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:column
                                            shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_DEFAULT_VALUE_WITH_STAR@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <uix:messageTextInput name="udParamValue" textBinding="stringValue"
                                                           shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest"/>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:column
                                            shortDescBinding="UDP_READONLY_DESC@resourcesBundle@servletRequest" rendered="true">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_READONLY@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <uix:checkBox name="udParamEditable" checkedBinding="readOnly"
                                                          shortDescBinding="UDP_READONLY_DESC@resourcesBundle@servletRequest"/>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:column
                                            shortDescBinding="UDP_REQUIRED_DESC@resourcesBundle@servletRequest" rendered="true">
                                        <uix:columnHeader>
                                            <uix:styledText textBinding="UDP_REQUIRED@resourcesBundle@servletRequest"/>
                                        </uix:columnHeader>
                                        <uix:contents>
                                            <uix:checkBox name="udParamRequired" checkedBinding="mandatory" 
                                                          shortDescBinding="UDP_REQUIRED_DESC@resourcesBundle@servletRequest"/>
                                        </uix:contents>
                                    </uix:column>
                                    <uix:footer>
                                        <uix:tableFooter>
                                            <uix:contents>
                                                <uix:styledText
                                                        textBinding="UDP_DEFAULT_TIP@resourcesBundle@servletRequest"/>
                                            </uix:contents>
                                        </uix:tableFooter>
                                    </uix:footer>
                                </uix:table>
                            </uix:case>
                        </uix:switcher>
                        <%--<uix:labeledFieldLayout labelWidth="19%">--%>
                            <%--<uix:contents childDataBinding="allUserDefinedAttrs@resource@addRes@servletRequest">--%>

                                <%--<uix:messageTextInput promptBinding="name" textBinding="value" nameBinding="name"--%>
                                                      <%--requiredBinding="requiredForGui"/>--%>

                            <%--</uix:contents>--%>
                        <%--</uix:labeledFieldLayout>--%>
                    </uix:stackLayout>
                </uix:header>
            </uix:rowLayout>


            </uix:tableLayout>
          </uix:subTabLayout>
              </uix:header>
            </uix:contents>
          </uix:stackLayout>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
              <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                  name="event" value="reLoadAfterReset"/>
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                  name="event" value="finishAdd"/>
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
