<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <uix:body>
      <db:form name="addResForm" method="post"
               destinationBinding="addDestination@addRes@servletRequest"
               copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                            errorTableBinding="msgBox@servletRequest"
                            destTableBinding="msgUrls@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="addHeader@addRes@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="reLoadAfterReset"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="finishAdd"/>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
</uix:tableLayout>
                <uix:spacer width="5"/>

                                <uix:subTabLayout>
                                    <uix:subTabs>
                                        <uix:subTabBar selectedIndex="2">
                                            <uix:link textBinding="GENERAL@resourcesBundle@servletRequest"
                                                      onClick="submitForm('addResForm', true, {event:'add',pageNum:'1'})"/>
                                            <uix:switcher childNameBinding="requiredForParametersTab@resource@addRes@servletRequest">
                                                <uix:case name="true">
                                                    <uix:link textBinding="PARAMETERS_STAR@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'2'})"/>
                                                </uix:case>
                                                <uix:case name="false">
                                                    <uix:link textBinding="PARAMETERS@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'2'})"/>
                                                </uix:case>
                                            </uix:switcher>
                                            <uix:link textBinding="ADVANCED_SETTINGS@resourcesBundle@servletRequest" />
                                            <uix:switcher childNameBinding="requiredForDependencyTab@resource@addRes@servletRequest">
                                                <uix:case name="true">
                                                    <uix:link textBinding="DEPENDENCIES_STAR@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'3'})"/>
                                                </uix:case>
                                                <uix:case name="false">
                                                    <uix:link textBinding="DEPENDENCIES@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'3'})"/>
                                                </uix:case>
                                            </uix:switcher>
                                        </uix:subTabBar>
                                    </uix:subTabs>
                                    <uix:spacer height="5"/>
                                        <uix:header textBinding="PERX_TABLE_HEADER@resourcesBundle@servletRequest">
                                            <uix:tableLayout width="100%">
                                                <uix:rowLayout>
                                                    <uix:cellFormat columnSpan="2">
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="PERX_TABLE_INTRO@resourcesBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                              <uix:rowLayout  >
                                                <uix:cellFormat hAlign="right" width="50%">
                                                  <uix:pageButtonBar>
                                                      <uix:submitButton textBinding="ADD@resourcesBundle@servletRequest" name="event" value="addIndexSpecificPerX"/>
                                                  </uix:pageButtonBar>
                                                </uix:cellFormat>
                                                  <uix:cellFormat width="50%">
                                                      
                                                  </uix:cellFormat>
                                              </uix:rowLayout>
                                            </uix:tableLayout>
                                            <uix:table width="50%" id="perXTable" name="perXTable" tableDataBinding="viewableInstancePerXList@resource@addRes@servletRequest"
                                                    detailDisclosureBinding="hideShowGenDataObjectList@resource@addRes@servletRequest" partialRenderMode="self"
                                                    formSubmitted="false" summaryBinding="PERX_TABLE_SUMMARY@resourcesBundle@servletRequest" alternateTextBinding="PERX_EMPTY_TABLE_SUMMARY@resourcesBundle@servletRequest"
                                                    allDetailsEnabled="false">
                                                <uix:tableSelection>
                                                    <uix:singleSelection shortDescBinding="SELECT@hasBundle@servletRequest">
                                                        <uix:submitButton textBinding="EDIT@resourcesBundle@servletRequest" name="event" value="editIndexSpecificPerX"/>
                                                        <uix:spacer width="5"/>
                                                        <uix:submitButton textBinding="DELETE@resourcesBundle@servletRequest" name="event" value="deleteIndexSpecificPerX"/>
                                                    </uix:singleSelection>
                                                </uix:tableSelection>
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:styledText textBinding="SERVER_NAME_CARDINALITYID@resourcesBundle@servletRequest"/>
                                                    </uix:columnHeader>
                                                    <uix:contents>
                                                        <uix:styledText styleClass="OraDataText" textBinding="cardinalityID"/>
                                                    </uix:contents>
                                                </uix:column>
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:styledText textBinding="SPECIFY_DEGREE_ID@resourcesBundle@servletRequest"/>
                                                    </uix:columnHeader>
                                                    <uix:contents>
                                                        <uix:styledText styleClass="OraDataText" textBinding="degreeID"/>
                                                    </uix:contents>
                                                </uix:column>
                                                <uix:detail>
                                                    <uix:stackLayout>
                                                        <uix:header textBinding="OVERRIDEN_PARAMETERS@resourcesBundle@servletRequest">

<uix:tableLayout  width="100%" cellSpacing="2">
<uix:contents childDataBinding="overridenParamsTable">
<uix:rowLayout>
<uix:cellFormat hAlign="right" width="30%" vAlign="top">
<uix:styledText styleClass="OraInstructionText"  textBinding="paramName"/>
</uix:cellFormat>
<uix:cellFormat hAlign="left" vAlign="top">
<uix:styledText styleClass="OraDataText" textBinding="paramValue"/>
</uix:cellFormat>
</uix:rowLayout>
</uix:contents>
</uix:tableLayout>
                                                        </uix:header>
                                                    </uix:stackLayout>
                                                </uix:detail>
                                            </uix:table>
                                        </uix:header>
                                </uix:subTabLayout>
                            </uix:header>
                        </uix:contents>
                    </uix:stackLayout>
                    <uix:contentFooter>
                        <uix:pageButtonBar>
                            <uix:spacer width="10"/>
                            <uix:flowLayout>
                                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                  name="event" value="reLoadAfterReset"/>
                                <uix:spacer width="10"/>
                                <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                                  name="event" value="finishAdd"/>
                            </uix:flowLayout>
                        </uix:pageButtonBar>
                    </uix:contentFooter>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
