<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <uix:body>
      <db:form name="addResForm" method="post"
               destinationBinding="addDestination@addRes@servletRequest"
               copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                            errorTableBinding="msgBox@servletRequest"
                            destTableBinding="msgUrls@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:stackLayout>
            <uix:contents>
              <uix:header textBinding="addHeader@addRes@servletRequest">
                <uix:tableLayout width="100%">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="reLoadAfterReset"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                          name="event"
                                          value="finishAdd"/>
                      </uix:flowLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
</uix:tableLayout>

                                <uix:subTabLayout>
                                    <uix:subTabs>
                                        <uix:subTabBar selectedIndex="2">
                                            <uix:link textBinding="GENERAL@resourcesBundle@servletRequest"
                                                      onClick="submitForm('addResForm', true, {event:'add',pageNum:'1'})"/>
                                            <uix:switcher childNameBinding="requiredForParametersTab@resource@addRes@servletRequest">
                                                <uix:case name="true">
                                                    <uix:link textBinding="PARAMETERS_STAR@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'2'})"/>
                                                </uix:case>
                                                <uix:case name="false">
                                                    <uix:link textBinding="PARAMETERS@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'2'})"/>
                                                </uix:case>
                                            </uix:switcher>
                                            <uix:link textBinding="ADVANCED_SETTINGS@resourcesBundle@servletRequest" />
                                            <uix:switcher childNameBinding="requiredForDependencyTab@resource@addRes@servletRequest">
                                                <uix:case name="true">
                                                    <uix:link textBinding="DEPENDENCIES_STAR@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'3'})"/>
                                                </uix:case>
                                                <uix:case name="false">
                                                    <uix:link textBinding="DEPENDENCIES@resourcesBundle@servletRequest"
                                                              onClick="submitForm('addResForm', true, {event:'add',pageNum:'3'})"/>
                                                </uix:case>
                                            </uix:switcher>
                                        </uix:subTabBar>
                                    </uix:subTabs>
                                    <uix:spacer height="5"/>
                                        <uix:header textBinding="PERMISSIONS@resourcesBundle@servletRequest">
                                            <uix:tableLayout width="100%">
                                                <uix:rowLayout>
                                                    <uix:cellFormat>
                                                        <uix:styledText styleClass="OraInstructionText" textBinding="PERM_TABLE_INTRO@resourcesBundle@servletRequest"/>
                                                    </uix:cellFormat>
                                                </uix:rowLayout>
                                            </uix:tableLayout>
                                            <uix:spacer height="5"/>
                                            <uix:table width="50%" id="permTable" name="permTable"
                                                       summaryBinding="PARAM_PERM_TABLE_DESC@resourcesBundle@servletRequest"
                                                       tableDataBinding="viewableParameterPermList@addRes@servletRequest">
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:styledText textBinding="PERX_PARAMETER_NAME@resourcesBundle@servletRequest"/>
                                                    </uix:columnHeader>
                                                    <uix:contents>
                                                        <uix:styledText styleClass="OraDataText" textBinding="name"/>
                                                    </uix:contents>
                                                </uix:column>
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:styledText textBinding="UDP_REQUIRED@resourcesBundle@servletRequest"/>
                                                    </uix:columnHeader>
                                                    <uix:contents>
                                                        <uix:checkBox name="permParamRequired" checkedBinding="mandatory"
                                                                shortDescBinding="UDP_REQUIRED_DESC@resourcesBundle@servletRequest"/>
                                                    </uix:contents>
                                                </uix:column>
                                                <uix:column>
                                                    <uix:columnHeader>
                                                        <uix:styledText textBinding="UDP_READONLY@resourcesBundle@servletRequest"/>
                                                    </uix:columnHeader>
                                                    <uix:contents>
                                                        <uix:checkBox name="permParamReadOnly" checkedBinding="readOnly"
                                                                shortDescBinding="UDP_READONLY_DESC@resourcesBundle@servletRequest"/>
                                                    </uix:contents>
                                                </uix:column>
                                            </uix:table>
                                        </uix:header>
                                </uix:subTabLayout>
                            </uix:header>
                        </uix:contents>
                    </uix:stackLayout>
                    <uix:contentFooter>
                        <uix:pageButtonBar>
                            <uix:spacer width="10"/>
                            <uix:flowLayout>
                                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                  name="event" value="reLoadAfterReset"/>
                                <uix:spacer width="10"/>
                                <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest"
                                                  name="event" value="finishAdd"/>
                            </uix:flowLayout>
                        </uix:pageButtonBar>
                    </uix:contentFooter>
                </uix:pageLayout>
            </db:form>
        </uix:body>
    </uix:document>
</uix:renderingContext>
