<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf"%>
    <uix:body>
      <db:form name="addPerXForm" method="post"
               destination="/console/has/resources"
               copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest"
                            errorTableBinding="msgBox@servletRequest"
                            destTableBinding="msgUrls@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:stackLayout>
          <uix:contents>
          <uix:tableLayout width="100%">
              <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                      <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                          name="event" value="cancelAddInstanceSpecificPerX"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="OK@hasBundle@servletRequest"
                                          name="event" value="finishAddInstanceSpecificPerX"/>
                      </uix:flowLayout>
                  </uix:cellFormat>
              </uix:rowLayout>
          </uix:tableLayout>
          <uix:header textBinding="addEditPerXHeader@servletRequest">
              <uix:formValue name="addEditPerXHeader" valueBinding="addEditPerXHeader@servletRequest"/>
          </uix:header>
          <uix:tableLayout>
          <uix:rowLayout>
              <uix:cellFormat columnSpan="5">
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="ADD_EDIT_PERX_INTRO@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:spacer height="15"/>

          <uix:tableLayout width="100%">
          <uix:rowLayout>
          <uix:tableLayout width="95%">
          <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="18.76%">
                  <uix:switcher childNameBinding="clusterAware@addRes@servletRequest" defaultCase="true">
                      <uix:case name="true">
                          <uix:messagePrompt promptBinding="CARDINALITY@resourcesBundle@servletRequest" labeledNodeId="cardinalityRadioPerX1"/>
                      </uix:case>
                      <uix:case name="false">
                          <uix:messagePrompt promptBinding="SERVER_NAME@resourcesBundle@servletRequest" labeledNodeId="cardinalityRadioPerX1"/>
                      </uix:case>
                  </uix:switcher>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:switcher childNameBinding="clusterAware@addRes@servletRequest" defaultCase="true">
                      <uix:case name="true">
                          <uix:stackLayout>
                              <uix:flowLayout>
                                  <uix:radioButton name="cardinalityRadioPerX" id="cardinalityRadioPerX1"
                                                   selectedValueBinding="cardinalityRadioPerX@addPerX@servletRequest"
                                                   value="byId" disabledBinding="editOperation@addPerX@servletRequest"/>
                                  <uix:spacer width="5"/>
                                  <uix:styledText textBinding="BY_ID@resourcesBundle@servletRequest" styleClass="OraInstructionText" labeledNodeId="cardinalityIDPerX"/>
                                  <uix:spacer width="5"/>
                                  <uix:textInput name="cardinalityIDPerX" id="cardinalityIDPerX" textBinding="cardinalityIDPerX@addPerX@servletRequest" shortDescBinding="PERX_CARDINALITY_ID_HELP@resourcesBundle@servletRequest"
                                                 disabledBinding="editOperation@addPerX@servletRequest"/>
                              </uix:flowLayout>
                              <uix:spacer height="15"/>
                              <uix:flowLayout>
                                  <uix:radioButton name="cardinalityRadioPerX" id="cardinalityRadioPerX2"
                                                   selectedValueBinding="cardinalityRadioPerX@addPerX@servletRequest"
                                                   value="byServerName" disabledBinding="editOperation@addPerX@servletRequest"/>
                                  <uix:spacer width="5"/>
                                  <uix:styledText textBinding="BY_SERVER@resourcesBundle@servletRequest" styleClass="OraInstructionText" labeledNodeId="cardinalityRadioPerX2"/>
                                  <uix:spacer width="5"/>
                                  <uix:styledText textBinding="NAME@resourcesBundle@servletRequest" styleClass="OraInstructionText" labeledNodeId="serverNamePerX"/>
                                  <uix:spacer width="5"/>
                                  <uix:textInput name="serverNamePerX" id="serverNamePerX" textBinding="serverNamePerX@addPerX@servletRequest" shortDescBinding="PERX_SERVER_NAME_HELP@resourcesBundle@servletRequest"
                                                 disabledBinding="editOperation@addPerX@servletRequest"/>
                              </uix:flowLayout>
                          </uix:stackLayout>
                      </uix:case>
                      <uix:case name="false">
                          <uix:stackLayout>
                              <uix:formValue name="cardinalityRadioPerX" value="byServerName" id="cardinalityRadioPerX1"/>
                                  <uix:textInput name="serverNamePerX" id="serverNamePerX"
                                                 textBinding="serverNamePerX@addPerX@servletRequest"
                                                 shortDescBinding="PERX_SERVER_NAME_HELP@resourcesBundle@servletRequest"
                                                 disabledBinding="editOperation@addPerX@servletRequest"/>
                          </uix:stackLayout>

                      </uix:case>
                  </uix:switcher>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="18.76%">
                  <uix:messagePrompt promptBinding="SPECIFY_DEGREE_ID@resourcesBundle@servletRequest" labeledNodeId="degreeIDPerX"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:textInput name="degreeIDPerX" id="degreeIDPerX"
                                 disabledBinding="editOperation@addPerX@servletRequest"
                                 textBinding="degreeIDPerX@addPerX@servletRequest"
                                 shortDescBinding="PERX_DEGREE_HELP@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
          </uix:rowLayout>

          </uix:tableLayout>
          </uix:rowLayout>


          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
          <uix:header textBinding="PLACEMENT_HEADER@resourcesBundle@servletRequest" renderedBinding="global@addRes@servletRequest">
          <uix:tableLayout width="65%">
              <uix:rowLayout>
                  <uix:cellFormat columnSpan="5">
                      <uix:styledText styleClass="OraInstructionText"
                                      textBinding="PLACEMENT_PERX_INTRO@resourcesBundle@servletRequest"/>
                  </uix:cellFormat>
              </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="27.4%">
                  <uix:messagePrompt labeledNodeId="loadPerX"
                                     promptBinding="LOAD@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="loadPerX" id="loadPerX"
                                     textBinding="value@loadPerX@addPerX@servletRequest"
                                     shortDescBinding="LOAD_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>

                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@loadPerX@addPerX@servletRequest"/>

                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
          </uix:rowLayout>
          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
          <uix:header textBinding="START_PARAMETERS_HEADER@resourcesBundle@servletRequest">
          <uix:tableLayout width="62.5%">
          <uix:rowLayout>
              <uix:cellFormat columnSpan="5">
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="START_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="restartAttemptsPerX"
                                     promptBinding="RESTART_ATTEMPTS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="restartAttemptsPerX" id="restartAttemptsPerX"
                                     textBinding="value@restartAttemptsPerX@addPerX@servletRequest"
                                     shortDescBinding="RESTART_ATTEMPTS_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@restartAttemptsPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>


          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="startTimeoutPerX"
                                     promptBinding="START_TIMEOUT@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="startTimeoutPerX" id="startTimeoutPerX"
                                     textBinding="value@startTimeoutPerX@addPerX@servletRequest"
                                     shortDescBinding="START_TIMEOUT_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@startTimeoutPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="uptimeThresholdPerX"
                                     promptBinding="UPTIME_THRESHOLD@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="uptimeThresholdDataPerX" id="uptimeThresholdPerX"
                                     textBinding="uptimeThresholdDataPerX@addPerX@servletRequest"
                                     shortDescBinding="UPTIME_THRESHOLD_HELP@resourcesBundle@servletRequest"
                                     columns="10">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:choice name="uptimeThresholdUnitPerX"
                                  selectedValueBinding="uptimeThresholdUnit@resource@addRes@servletRequest">
                          <uix:option textBinding="SECONDS@resourcesBundle@servletRequest" value="s"/>
                          <uix:option textBinding="MINUTES@resourcesBundle@servletRequest" value="m"/>
                          <uix:option textBinding="HOURS@resourcesBundle@servletRequest" value="h"/>
                          <uix:option textBinding="DAYS@resourcesBundle@servletRequest" value="d"/>
                          <uix:option textBinding="WEEKS@resourcesBundle@servletRequest" value="w"/>
                      </uix:choice>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@uptimeThresholdPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
          </uix:rowLayout>
          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <%-- Stop Parameters --%>
          <uix:rowLayout>
              <uix:header textBinding="STOP_PARAMETERS_HEADER@resourcesBundle@servletRequest">
                  <uix:tableLayout width="75%">
                      <uix:rowLayout>
                          <uix:cellFormat columnSpan="5">
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="STOP_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
                          </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout>
                          <uix:cellFormat>
                              <uix:spacer height="15"/>
                          </uix:cellFormat>
                      </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="stopTimeoutPerX"
                                     promptBinding="STOP_TIMEOUT@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="stopTimeoutPerX" id="stopTimeoutPerX"
                                     textBinding="value@stopTimeoutPerX@addPerX@servletRequest"
                                     shortDescBinding="STOP_TIMEOUT_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@stopTimeoutPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
          </uix:rowLayout>

            </uix:tableLayout>
          </uix:header>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <%-- Status Parameters --%>
          <uix:rowLayout>
          <uix:header textBinding="STATUS_PARAMETERS_HEADER@resourcesBundle@servletRequest">
          <uix:tableLayout width="62%">
          <uix:rowLayout>
              <uix:cellFormat columnSpan="5">
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="STATUS_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="checkIntervalPerX"
                                     promptBinding="CHECK_INTERVAL@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="checkIntervalPerX" id="checkIntervalPerX"
                                     textBinding="value@checkIntervalPerX@addPerX@servletRequest"
                                     shortDescBinding="CHECK_INTERVAL_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@checkIntervalPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="scriptTimeoutPerX"
                                     promptBinding="SCRIPT_TIMEOUT@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="scriptTimeoutPerX" id="scriptTimeoutPerX"
                                     textBinding="value@scriptTimeoutPerX@addPerX@servletRequest"
                                     shortDescBinding="SCRIPT_TIMEOUT_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@scriptTimeoutPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout vAlign="top">
              <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>


          <uix:rowLayout renderedBinding="global@addRes@servletRequest">
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="failureThresholdPerX"
                                     promptBinding="FAILURE_THRESHOLD@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="failureThresholdPerX" id="failureThresholdPerX"
                                     textBinding="value@failureThresholdPerX@addPerX@servletRequest"
                                     shortDescBinding="FAILURE_THRESHOLD_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@failureThresholdPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout vAlign="top" renderedBinding="global@addRes@servletRequest">
              <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout renderedBinding="global@addRes@servletRequest">
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout renderedBinding="global@addRes@servletRequest">
              <uix:cellFormat hAlign="right">
                  <uix:messagePrompt labeledNodeId="failureIntervalPerX"
                                     promptBinding="FAILURE_INTERVAL@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
                  <uix:flowLayout>
                      <uix:textInput name="failureIntervalPerX" id="failureIntervalPerX"
                                     textBinding="value@failureIntervalPerX@addPerX@servletRequest"
                                     shortDescBinding="FAILURE_INTERVAL_HELP@resourcesBundle@servletRequest">
                          <uix:onBlurValidater>
                              <uix:decimal minValue="0"/>
                          </uix:onBlurValidater>
                      </uix:textInput>
                      <uix:spacer width="5"/>
                      <uix:styledText styleClass="OraInstructionText" textBinding="viewableDefaultValue@failureIntervalPerX@addPerX@servletRequest"/>
                  </uix:flowLayout>
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout vAlign="top" renderedBinding="global@addRes@servletRequest">
              <uix:cellFormat hAlign="right">
                  <uix:styledText styleClass="OraInlineInfoText"
                                  textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                  <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat hAlign="left">
              </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout renderedBinding="global@addRes@servletRequest">
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
          </uix:header>
          </uix:rowLayout>
          <uix:rowLayout>
              <uix:cellFormat>
                  <uix:spacer height="15"/>
              </uix:cellFormat>
          </uix:rowLayout>

          <uix:spacer height="15"/>
          <uix:header textBinding="USER_DEFINED_PARAM@resourcesBundle@servletRequest"
                      renderedBinding="showUdParamPerXTable@addPerX@servletRequest">
              <uix:spacer height="15"/> 
              <uix:table id="udParamTablePerX" name="udParamTablePerX"
                         tableDataBinding="udParamPerXList@addPerX@servletRequest" width="50%"
                         summaryBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest"
                         partialRenderMode="self" formSubmitted="false"
                         shortDescBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest">
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:column shortDescBinding="UDP_NAME_DESC@resourcesBundle@servletRequest">
                      <uix:columnHeader>
                          <uix:styledText textBinding="UDP_NAME@resourcesBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:contents>
                          <uix:stackLayout>
                              <uix:formValue name="udParamNameHiddenPerX" valueBinding="attributeName"/>
                              <uix:styledText textBinding="attributeName"/>
                          </uix:stackLayout>
                      </uix:contents>
                  </uix:column>
                  <%--<uix:column shortDescBinding="UDP_TYPE_DESC@resourcesBundle@servletRequest">--%>
                  <%--<uix:columnHeader>--%>
                  <%--<uix:styledText textBinding="UDP_TYPE@resourcesBundle@servletRequest"/>--%>
                  <%--</uix:columnHeader>--%>
                  <%--<uix:contents>--%>
                  <%--<%--<uix:radioButton name="udParamType" text="text" valueBinding="type" selectedValue="string"/>--%>
                  <%--<%--<uix:radioButton name="udParamType" text="number" valueBinding="type" selectedValue="int"/>--%>
                  <%--<uix:styledText textBinding="type"/>--%>
                  <%--<uix:formValue name="udParamType" valueBinding="type"/>--%>
                  <%--</uix:contents>--%>
                  <%--</uix:column>--%>
                  <uix:column
                          shortDesc="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest">
                      <uix:columnHeader>
                          <uix:styledText textBinding="UDP_DEFAULT_VALUE@resourcesBundle@servletRequest"/>
                      </uix:columnHeader>
                      <uix:contents>
                          <uix:textInput name="udParamValuePerX" textBinding="value" shortDescBinding="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest"/>
                      </uix:contents>
                  </uix:column>
                  <uix:footer>
                      <uix:tableFooter>
                          <uix:contents>
                          </uix:contents>
                      </uix:tableFooter>
                  </uix:footer>
              </uix:table>
          </uix:header>
          </uix:tableLayout>

          </uix:tableLayout>
          </uix:contents>
          </uix:stackLayout>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:spacer width="10"/>
              <uix:flowLayout>
                <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                  name="event" value="cancelAddInstanceSpecificPerX"/>
                <uix:spacer width="10"/>
                <uix:submitButton textBinding="OK@hasBundle@servletRequest"
                                  name="event" value="finishAddInstanceSpecificPerX"/>
              </uix:flowLayout>
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
