<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

<%@ include file="/enablePPR.jspf" %>
<%@ include file="/oemTitle.jspf" %>
<uix:body>
    <db:form name="addVip" method="POST" destination="/em/console/has/resources" copyParams="target,type,isRepDown">

        <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
                <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                errorTableBinding="msgBox@servletRequest"
                                destTableBinding="msgUrls@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:stackLayout>
                <uix:contents>
                    <uix:header textBinding="ADD_VIP_RESOURCE@resourcesBundle@servletRequest">
                        <uix:tableLayout width="100%">
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="left">
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="right">
                                    <uix:flowLayout>
                                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                          name="event" value="reLoadAfterReset"/>
                                        <uix:spacer width="10"/>
                                        <uix:submitButton textBinding="CONTINUE_BUTTON@hasBundle@servletRequest"
                                                          name="event" value="finishAddVip"/>
                                    </uix:flowLayout>
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat columnSpan="2">
                                    <uix:spacer height="5"/>
                                </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="left" columnSpan="2">
                                    <uix:styledText styleClass="OraInstructionText"
                                                    textBinding="ADD_APPLICATION_VIP_INTRO_MSG@resourcesBundle@servletRequest"/>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:spacer height="15"/>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:tableLayout width="75%">
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt required="yes" labeledNodeId="entityName" 
                                                               promptBinding="RESOURCE_NAME@resourcesBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer width="5"/>
                                        </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                            <uix:textInput name="entityName" id="entityName" shortDescBinding="VIP_RES_NAME_TIP@resourcesBundle@servletRequest" textBinding="entityName@vipResource@servletRequest"/>
                                       </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="15"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt required="yes" labeledNodeId="network"
                                                               promptBinding="NETWORK_NUMBER@resourcesBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer width="5"/>
                                        </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                            <uix:textInput name="networkNumber" id="network" shortDescBinding="NETWORK_NUMBER_TIP@resourcesBundle@servletRequest" textBinding="networkNumber@vipResource@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="15"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt required="yes" labeledNodeId="ipAdd"
                                                               promptBinding="IP_ADDRESS@resourcesBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer width="5"/>
                                        </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                            <uix:textInput name="ipAddress" id="ipAdd" shortDescBinding="VIP_RES_IP_TIP@resourcesBundle@servletRequest" textBinding="ipAddress@vipResource@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="15"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt required="yes" labeledNodeId="userName"
                                                               promptBinding="OWNER_USER@resourcesBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer width="5"/>
                                        </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                            <uix:textInput name="userName" id="userName" shortDescBinding="VIP_OWNER_USER_TIP@resourcesBundle@servletRequest" textBinding="userName@vipResource@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="15"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>


                      <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                          </uix:cellFormat>
                          <uix:cellFormat>
                              <uix:spacer width="5"/>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="left">
                              <uix:checkBox textBinding="START_AFTER_CREATION@resourcesBundle@servletRequest"
                                            name="startResource"/>
                          </uix:cellFormat>
                      </uix:rowLayout>

                                </uix:tableLayout>
                            </uix:rowLayout>
                        </uix:tableLayout>


                    </uix:header>
                </uix:contents>
            </uix:stackLayout>

            <uix:contentFooter>
                <uix:pageButtonBar>
                    <uix:spacer width="10"/>
                    <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event"
                                          value="reLoadAfterReset"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="CONTINUE_BUTTON@hasBundle@servletRequest" name="event"
                                          value="finishAddVip"/>
                    </uix:flowLayout>
                </uix:pageButtonBar>
            </uix:contentFooter>


        </uix:pageLayout>
    </db:form>

</uix:body>
</uix:document>
</uix:renderingContext>
