<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

<%@ include file="/enablePPR.jspf" %>
<%@ include file="/oemTitle.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:body>
    <db:form name="relocate" method="POST" destination="/em/console/has/resources" copyParams="target,type,isRepDown">

        <uix:pageLayout>
            <%@ include file="/oemGlobal.jspf" %>

            <uix:messages>
                <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                errorTableBinding="msgBox@servletRequest"
                                destTableBinding="msgUrls@servletRequest"
                                titleTextKey="titleText" mainTextKey="mainText"/>
            </uix:messages>

            <uix:stackLayout>
                <uix:contents>
                    <uix:header textBinding="pageHeader@servletRequest">
                        <uix:tableLayout width="100%">
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraInstructionText"
                                                    textBinding="RESOURCES_RELOCATE_MSG@resourcesBundle@servletRequest"/>
                                </uix:cellFormat>

                                <uix:cellFormat hAlign="right">
                                    <uix:flowLayout>
                                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest"
                                                          name="event" value="reLoadAfterReset"/>
                                        <uix:spacer width="10"/>
                                        <uix:submitButton textBinding="CONTINUE_BUTTON@hasBundle@servletRequest"
                                                          name="event" value="continueRelocate"/>
                                    </uix:flowLayout>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:cellFormat>
                                    <uix:spacer height="15"/>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <uix:rowLayout>
                                <uix:tableLayout width="75%">
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt labeledNodeId="fromHost" required="yes"
                                                               promptBinding="RESOURCES_RELOCATE_FROM@resourcesBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer width="5"/>
                                        </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                            <oem:choice name="fromHost" id="fromHost"
                                                        shortDescBinding="RESOURCES_RELOCATE_FROM@resourcesBundle@servletRequest"
                                                        optionsBinding="runningHostsArray@resForRelocate@defaultBean@servletRequest"
                                                        selectedValueBinding="fromHost@defaultBean@servletRequest"
                                                        onChange="submitForm('relocate', true, {'event':'updateFromServer'})"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat>
                                            <uix:spacer height="15"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>

                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt required="yes" labeledNodeId="toHost"
                                                               promptBinding="RESOURCES_RELOCATE_TO@resourcesBundle@servletRequest"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat>
                                            <uix:spacer width="5"/>
                                        </uix:cellFormat>

                                        <uix:cellFormat hAlign="left">
                                            <uix:lovInput name="toHost" id="toHost" partialRenderMode="self"
                                                          columns="20"
                                                          shortDescBinding="RESOURCES_RELOCATE_TO@resourcesBundle@servletRequest"
                                                          destination="/em/console/has/resources"
                                                          textBinding="toHost@defaultBean@servletRequest"/>
                                        </uix:cellFormat>
                                    </uix:rowLayout>
                                </uix:tableLayout>
                            </uix:rowLayout>
                        </uix:tableLayout>


                    </uix:header>
                </uix:contents>
            </uix:stackLayout>

            <uix:contentFooter>
                <uix:pageButtonBar>
                    <uix:spacer width="10"/>
                    <uix:flowLayout>
                        <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event"
                                          value="reLoadAfterReset"/>
                        <uix:spacer width="10"/>
                        <uix:submitButton textBinding="CONTINUE_BUTTON@hasBundle@servletRequest" name="event"
                                          value="continueRelocate"/>
                    </uix:flowLayout>
                </uix:pageButtonBar>
            </uix:contentFooter>


        </uix:pageLayout>
    </db:form>

</uix:body>
</uix:document>
</uix:renderingContext>
