<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
<db:form name="viewResForm" destination="/em/console/has/resources" method="post" copyParams="target,type,cancelURL,isRepDown,rowIndex">
<uix:pageLayout>
<%@ include file="/database/global.jspf" %>
<uix:messages>
    <oem:messageBox messageTypeBinding="messageType@servletRequest" errorTableBinding="msgBox@servletRequest"
                    destTableBinding="msgUrls@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
<uix:formValue name="resName" valueBinding="name@selectedRes@servletRequest"/>
<uix:header textBinding="resHeader@servletRequest">
<%-- page refresh time / refresh button --%>
<uix:tableLayout width="100%">
<uix:rowLayout>

  <uix:cellFormat hAlign="right" vAlign="top" width="35%">
   <uix:flowLayout>
     <uix:styledText styleClass="OraTipText"
          textBinding="PAGE_REFRESHED@hasBundle@servletRequest"/>
     <uix:spacer width="5" />

     <uix:styledText styleClass="OraTipLabel"
          textBinding="refreshTime@defaultBean@servletRequest"/>

     <uix:spacer width="5" />
        <uix:submitButton textBinding="REFRESH_BUTTON@hasBundle@servletRequest" name="event" value="doLoadView"/>

  </uix:flowLayout>
    </uix:cellFormat>
</uix:rowLayout>
  </uix:tableLayout>

<uix:stackLayout>
<uix:contents>
        <uix:tableLayout width="50%">
            <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" width="10%">
                    <uix:image sourceBinding="statusImage@selectedRes@servletRequest" shortDescBinding="statusImageDesc@selectedRes@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat>
                    <uix:tableLayout hAlign="left" cellSpacing="5">
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right" width="35%">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="RESOURCE_NAME@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="2"/>
                            <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="name@selectedRes@servletRequest"/>
                                <uix:formValue name="resName" valueBinding="name@selectedRes@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right" width="35%">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="RESOURCE_TYPE@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="2"/>
                            <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="type@selectedRes@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right" width="35%">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="RESOURCE_CURRENT_STATE@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="2"/>
                            <uix:cellFormat hAlign="left">
                                <uix:include nodeBinding="viewableCurrentState@selectedRes@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right" width="35%">
                                <uix:styledText styleClass="OraPromptText" textBinding="OWNER@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="2"/>
                            <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="owner@selectedRes@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>


                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right" width="35%">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="DESCRIPTION@resourcesBundle@servletRequest"/>
                            </uix:cellFormat>
                            <uix:spacer width="2"/>
                            <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="viewableDescription@selectedRes@servletRequest"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                            <uix:cellFormat hAlign="right" width="35%">
                                <uix:styledText styleClass="OraPromptText"
                                                textBinding="UP_SINCE@resourcesBundle@servletRequest" rendered="false"/>
                            </uix:cellFormat>
                            <uix:spacer width="2"/>
                            <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="viewableUpSince@selectedRes@servletRequest" rendered="false"/>
                            </uix:cellFormat>
                        </uix:rowLayout>
                    </uix:tableLayout>
                </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>
<uix:spacer height="20"/>
<uix:subTabLayout>
<uix:subTabs>
    <uix:subTabBar selectedIndexBinding="tabToShow@servletRequest">
        <uix:link textBinding="GENERAL@resourcesBundle@servletRequest" destinationBinding="generalDest@servletRequest"/>
        <uix:link textBinding="PARAMETERS@resourcesBundle@servletRequest"
                  destinationBinding="parametersDest@servletRequest"/>
        <uix:link textBinding="ADVANCED_SETTINGS@resourcesBundle@servletRequest"
                  destinationBinding="perXDest@servletRequest"/>
        <uix:link textBinding="DEPENDENCIES@resourcesBundle@servletRequest"
                  destinationBinding="dependencyDest@servletRequest"/>
    </uix:subTabBar>
</uix:subTabs>
<uix:stackLayout>
<uix:switcher childNameBinding="tabToShow@servletRequest" >
<uix:case name="0">
    <uix:stackLayout>
        <uix:header textBinding="PLACEMENT_HEADER@resourcesBundle@servletRequest">
            <uix:tableLayout hAlign="left" width="100%" cellSpacing="2">
                <uix:rowLayout>
          <uix:cellFormat columnSpan="5">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="CLUSTER_RESOURCE_PLACEMENT_INTRO@resourcesBundle@servletRequest"/>
          </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="CARDINALITY@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="viewableCardinality@selectedRes@servletRequest" defaultCase="defaultCase">
                            <uix:case name="n/a">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="RES_DETAILS_CARDINALITY_NA@resourcesBundle@servletRequest"/>
                            </uix:case>
                            <uix:case name="defaultCase">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="viewableCardinality@selectedRes@servletRequest"/>
                            </uix:case>
                        </uix:switcher>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="CARDINALITY_HELP@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="DEGREE@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableValue@degree@selectedRes@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="DEGREE_HELP@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="SERVER_GROUPS@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="viewableValue@serverGroups@selectedRes@servletRequest" defaultCase="default">
                            <uix:case name="*">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="ALL_SERVER_GROUPS@resourcesBundle@servletRequest"/>
                            </uix:case>
                            <uix:case name="default">
                                <uix:styledText styleClass="OraDataText"
                                                textBinding="viewableValue@serverGroups@selectedRes@servletRequest"/>
                            </uix:case>
                        </uix:switcher>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="SERVER_GROUP_PLACEMENT_HELP@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="HOSTING_MEMBERS@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableValue@hostingMembers@selectedRes@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="HOSTING_MEMBERS_PLACEMENT_HELP@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="PLACEMENT_POLICY@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableValue@placementPolicy@selectedRes@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="viewableValue@placementPolicy@selectedRes@servletRequest" defaultCase="na">
                            <uix:case name="balanced">
                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="PLACEMENT_POLICY_BALANCED@resourcesBundle@servletRequest"/>
                            </uix:case>
                            <uix:case name="restricted">
                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="PLACEMENT_POLICY_RESTRICTED@resourcesBundle@servletRequest"/>
                            </uix:case>
                            <uix:case name="favored">
                                <uix:styledText styleClass="OraInlineInfoText"
                                                textBinding="PLACEMENT_POLICY_FAVORED@resourcesBundle@servletRequest"/>
                            </uix:case>
                        </uix:switcher>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText" textBinding="LOAD@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableValue@load@selectedRes@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="LOAD_VIEW_HELP@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="ACTIVE_PLACEMENT_LABEL@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableActivePlacement@selectedRes@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="ACTIVE_PLACEMENT@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>


            </uix:tableLayout>
        </uix:header>
        <uix:header textBinding="SCRIPT_HEADER@resourcesBundle@servletRequest">
            <uix:tableLayout hAlign="center" width="100%" cellSpacing="2">
                <uix:rowLayout>
          <uix:cellFormat columnSpan="5">
              <uix:styledText styleClass="OraInstructionText"
                              textBinding="SCRIPT_INTRO_VIEW@resourcesBundle@servletRequest"/>
          </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="10"/>
                  </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="AGENT_FILENAME@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left" >
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableValue@agentFilename@selectedRes@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout vAlign="top">
                    <uix:cellFormat hAlign="right" width="25%">
                        <uix:styledText styleClass="OraPromptText"
                                        textBinding="ACTION_SCRIPT@resourcesBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat width="2%"/>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="hasValue@actionScript@selectedRes@servletRequest" defaultCase="false">
                            <uix:case name="true">
                                <uix:flowLayout>
                                    <uix:link  onClick="submitForm('viewResForm',true,{event:'viewActionScript'})"
                                                    textBinding="viewableValue@actionScript@selectedRes@servletRequest" />
                                        <uix:spacer width="10"/>
                                    <%--<uix:submitButton textBinding="VIEW@resourcesBundle@servletRequest" name="event" value="viewActionScript"/>--%>
                                    <uix:formValue name="actionScriptFileName" valueBinding="viewableValue@actionScript@selectedRes@servletRequest"/>
                                </uix:flowLayout>
                            </uix:case>
                            <uix:case name="false">
                                <uix:styledText styleClass="OraDataText"
                                        textBinding="viewableValue@actionScript@selectedRes@servletRequest" />
                            </uix:case>
                        </uix:switcher>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
        </uix:header>
    </uix:stackLayout>
</uix:case>
<uix:case name="1">
<!--Parameters Tab-->
<uix:stackLayout>
<uix:header textBinding="START_PARAMETERS_HEADER@resourcesBundle@servletRequest">
    <uix:tableLayout hAlign="left" width="100%" cellSpacing="2" >
        <uix:rowLayout>
  <uix:cellFormat columnSpan="5">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="START_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
  </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat>
            <uix:spacer height="10"/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="AUTO_START@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:switcher childNameBinding="viewableValue@autoStart@selectedRes@servletRequest" defaultCase="na">
                    <uix:case name="restore">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="RESTORE@resourcesBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="never">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="NEVER@resourcesBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="always">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="ALWAYS@resourcesBundle@servletRequest"/>
                    </uix:case>
                    <uix:case name="na">
                        <uix:styledText styleClass="OraDataText"
                                        textBinding="NOT_APPLICABLE@resourcesBundle@servletRequest"/>
                    </uix:case>
                </uix:switcher>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
        </uix:rowLayout>
        <!--Restart Attempts Begin-->
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="RESTART_ATTEMPTS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@restartAttempts@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="RESTART_ATTEMPTS_HELP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <!--Restart Attempts End-->
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="START_TIMEOUT@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@startTimeout@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="UPTIME_THRESHOLD@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@uptimeThreshold@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="UPTIME_THRESHOLD_HELP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
    </uix:tableLayout>
</uix:header>
<uix:header textBinding="STOP_PARAMETERS_HEADER@resourcesBundle@servletRequest">
    <uix:tableLayout hAlign="left" width="100%" cellSpacing="2">
        <uix:rowLayout>
  <uix:cellFormat columnSpan="5">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="STOP_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
  </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat>
            <uix:spacer height="10"/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="STOP_TIMEOUT@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@stopTimeout@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
            </uix:cellFormat>
        </uix:rowLayout>
    </uix:tableLayout>
</uix:header>
<uix:header textBinding="STATUS_PARAMETERS_HEADER@resourcesBundle@servletRequest">
    <uix:tableLayout hAlign="left" width="100%" cellSpacing="2" >
        <uix:rowLayout>
  <uix:cellFormat columnSpan="5">
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="STATUS_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
  </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat>
            <uix:spacer height="10"/>
          </uix:cellFormat>
        </uix:rowLayout>

        <!--Script Timeout Begin-->
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="SCRIPT_TIMEOUT@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@scriptTimeout@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="SCRIPT_TIMEOUT_HELP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <!--Script Timeout End-->

        <!--check Interval Begin-->
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="CHECK_INTERVAL@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@checkInterval@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%">
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="CHECK_INTERVAL_VIEW_HELP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <!--check Inteval End-->


        <!--Failure Interval Begin-->
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="FAILURE_INTERVAL@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@failureInterval@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="FAILURE_INTERVAL_HELP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <!--Failure Interval End-->

        <!--Failure Threshold Begin-->
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="FAILURE_THRESHOLD@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@failureThreshold@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="FAILURE_THRESHOLD_HELP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <!--Failure Threshold End-->


    </uix:tableLayout>
</uix:header>
<uix:header textBinding="OFFLINE_MONITORING@resourcesBundle@servletRequest">
    <uix:tableLayout hAlign="left" width="100%" cellSpacing="2" >
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraPromptText"
                                textBinding="OFFLINE_CHECK_INTERVAL@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText"
                                textBinding="viewableValue@offlineCheckInterval@selectedRes@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout vAlign="top">
            <uix:cellFormat hAlign="right" width="25%">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat width="2%"/>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraInlineInfoText"
                                textBinding="OFFLINE_CHECK_INTERVAL_TIP@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
    </uix:tableLayout>
</uix:header>
<uix:header textBinding="USER_DEFINED_ATTRIBUTES@resourcesBundle@servletRequest">
    <uix:stackLayout>
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="UDP_VIEW_RES_INTRO@resourcesBundle@servletRequest"/>
        <uix:spacer height="10"/>
        <uix:table id="udParamTable" name="udParamTable" tableDataBinding="allUserDefinedAttrs@selectedRes@servletRequest"
                alternateTextBinding="UDP_EMPTY_TABLE_DESC@resourcesBundle@servletRequest"
                summaryBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest"
                           partialRenderMode="self" width="50%" formSubmitted="false" >
                       <uix:tableFormat tableBanding="rowBanding" />
                       <uix:column>
                           <uix:columnHeader>
                               <uix:styledText textBinding="UDP_NAME@resourcesBundle@servletRequest"/>
                           </uix:columnHeader>
                           <uix:contents>
                               <uix:styledText textBinding="name"  />
                           </uix:contents>
                       </uix:column>
                       <uix:column>
                           <uix:columnHeader>
                               <uix:styledText textBinding="UDP_VALUE@resourcesBundle@servletRequest"/>
                           </uix:columnHeader>
                           <uix:contents>
                               <uix:styledText textBinding="stringValue"/>
                           </uix:contents>
                       </uix:column>
                   </uix:table>
    </uix:stackLayout>
           </uix:header>
</uix:stackLayout>
</uix:case>
<uix:case name="2">
<uix:stackLayout>
    <uix:header textBinding="PERX_TABLE_HEADER@resourcesBundle@servletRequest">
        <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_PERX_TABLE_INTRO@resourcesBundle@servletRequest"/>
        <uix:spacer height="10"/>
        <uix:table name="perXTableView"  width="50%" tableDataBinding="viewableInstancePerXList@selectedRes@servletRequest"
        detailDisclosureBinding="hideShowGenDataObjectList@selectedRes@servletRequest"
        alternateTextBinding="PERX_EMPTY_TABLE_SUMMARY@resourcesBundle@servletRequest"
        formSubmitted="true" partialRenderMode="self" summaryBinding="PERX_TABLE_SUMMARY@resourcesBundle@servletRequest"
        allDetailsEnabled="false">
            <uix:column>
                <uix:columnHeader>
                    <uix:styledText textBinding="SERVER_NAME_CARDINALITYID@resourcesBundle@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                    <uix:styledText styleClass="OraDataText" textBinding="cardinalityID"/>
                </uix:contents>
            </uix:column>
            <uix:column>
                <uix:columnHeader>
                    <uix:styledText textBinding="SPECIFY_DEGREE_ID@resourcesBundle@servletRequest"/>
                </uix:columnHeader>
                <uix:contents>
                    <uix:styledText styleClass="OraDataText" textBinding="degreeID"/>
                </uix:contents>
            </uix:column>
            <uix:detail>
                <uix:stackLayout>
                    <uix:header textBinding="OVERRIDEN_PARAMETERS@resourcesBundle@servletRequest">

<uix:tableLayout  width="100%" cellSpacing="2">
<uix:contents childDataBinding="overridenParamsTable">
<uix:rowLayout>
<uix:cellFormat hAlign="right" width="30%" vAlign="top">
<uix:styledText styleClass="OraInstructionText"  textBinding="paramName"/>
</uix:cellFormat>
<uix:cellFormat hAlign="left" vAlign="top">
<uix:styledText styleClass="OraDataText" textBinding="paramValue"/>
</uix:cellFormat>
</uix:rowLayout>
</uix:contents>
</uix:tableLayout>

                    </uix:header>
                </uix:stackLayout>
            </uix:detail>
        </uix:table>
    </uix:header>
</uix:stackLayout>
</uix:case>
<uix:case name="3">
<!--Dependencies Tab-->
<uix:stackLayout>
    <uix:header textBinding="START_DEPENDENCIES@resourcesBundle@servletRequest">
        <uix:tableLayout hAlign="left" width="100%" cellSpacing="2">
        <uix:rowLayout>
  <uix:cellFormat columnSpan="5">
      <uix:styledText styleClass="OraInstructionText"
                      textBinding="START_DEPENDENCIES_INTRO@resourcesBundle@servletRequest"/>
  </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat>
            <uix:spacer height="10"/>
          </uix:cellFormat>
        </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="HARD_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableHardStartDependency@selectedRes@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="HARD_START_DEPENDENCY_DESC@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="WEAK_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableWeakStartDependency@selectedRes@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat width="25%"/>
              <uix:cellFormat width="2%"/>
              <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="WEAK_START_DEPENDENCY_DESC@resourcesBundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="ATTRACTION_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableAttractionStartDependency@selectedRes@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat width="25%"/>
              <uix:cellFormat width="2%"/>
              <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="ATTRACTION_START_DEPENDENCY_DESC@resourcesBundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="PULLUP_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewablePullupStartDependency@selectedRes@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat width="25%"/>
              <uix:cellFormat width="2%"/>
              <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="PULLUP_START_DEPENDENCY_DESC@resourcesBundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="DISPERSION_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableDispersionStartDependency@selectedRes@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat width="25%"/>
              <uix:cellFormat width="2%"/>
              <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="DISPERSION_START_DEPENDENCY_DESC@resourcesBundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>
    </uix:header>
    <uix:header textBinding="STOP_DEPENDENCIES@resourcesBundle@servletRequest">
        <uix:tableLayout hAlign="left" width="100%" cellSpacing="2">
            <uix:rowLayout>
      <uix:cellFormat columnSpan="5">
          <uix:styledText styleClass="OraInstructionText"
                          textBinding="STOP_DEPENDENCIES_INTRO@resourcesBundle@servletRequest"/>
      </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat>
                <uix:spacer height="10"/>
              </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="HARD_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat width="2%"/>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableHardStopDependency@selectedRes@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
            <uix:rowLayout vAlign="top">
              <uix:cellFormat width="25%"/>
              <uix:cellFormat width="2%"/>
              <uix:cellFormat hAlign="left">
              <uix:styledText styleClass="OraInlineInfoText"
                              textBinding="HARD_STOP_DEPENDENCY_DESC@resourcesBundle@servletRequest" />
              </uix:cellFormat>
            </uix:rowLayout>
            <%--<uix:rowLayout vAlign="top">--%>
                <%--<uix:cellFormat hAlign="right" width="25%">--%>
                    <%--<uix:styledText styleClass="OraPromptText"--%>
                                    <%--textBinding="EXCLUSION_DEPENDENCY_LABEL@resourcesBundle@servletRequest"/>--%>
                <%--</uix:cellFormat>--%>
                <%--<uix:cellFormat width="2%"/>--%>
                <%--<uix:cellFormat hAlign="left">--%>
                    <%--<uix:styledText styleClass="OraDataText"--%>
                                    <%--textBinding="viewableExclusionStopDependency@selectedRes@servletRequest"/>--%>
                <%--</uix:cellFormat>--%>
            <%--</uix:rowLayout>--%>
            <%--<uix:rowLayout vAlign="top">--%>
              <%--<uix:cellFormat width="25%"/>--%>
              <%--<uix:cellFormat width="2%"/>--%>
              <%--<uix:cellFormat hAlign="left">--%>
              <%--<uix:styledText styleClass="OraInlineInfoText" --%>
                              <%--textBinding="EXCLUSION_STOP_DEPENDENCY_DESC@resourcesBundle@servletRequest" />--%>
              <%--</uix:cellFormat>--%>
            <%--</uix:rowLayout>--%>
        </uix:tableLayout>
    </uix:header>
</uix:stackLayout>
</uix:case>
</uix:switcher>
</uix:stackLayout>
</uix:subTabLayout>
<uix:spacer height="20"/>
<uix:styledText styleClass="OraPromptText"
                textBinding="RES_SIMPLE_STATUS_TREE_SUMMARY@resourcesBundle@servletRequest"/>
<uix:spacer height="10"/>
        <oem:table name="resourceStatusTable"
                   width="70%" blockSize="50"
                   dataSourceProp="resourceStatusTable"
                   beanKey="selectedRes"
                   formSubmitted="true"
                   summaryBinding="RES_STATUS_TABLE_SUMMARY@resourcesBundle@servletRequest">
            <uix:tableSelection>
                <uix:singleSelection shortDescBinding="SELECT@hasBundle@servletRequest">
                    <uix:submitButton textBinding="RESOURCES_START@resourcesBundle@servletRequest" name="event" value="cardinalStart" disabledBinding="internalResource@selectedRes@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="RESOURCES_STOP@resourcesBundle@servletRequest" name="event" value="cardinalStop"  disabledBinding="internalResource@selectedRes@servletRequest"/>
                </uix:singleSelection>
            </uix:tableSelection>
        </oem:table>
    <uix:spacer height="20"/>
<%-- Return Button --%>
<uix:tableLayout width="100%">
    <uix:rowLayout hAlign="right">
        <uix:cellFormat hAlign="right">
            <uix:submitButton textBinding="RETURN@hasBundle@servletRequest"
                        name="event" value="reload"/>
        </uix:cellFormat>
    </uix:rowLayout>
</uix:tableLayout>

</uix:contents>
</uix:stackLayout>
</uix:header>
</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
