<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_RESOURCE_TITLE@resourcesBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        --%>
          <uix:listOfValues
              titleBinding="SELECT_RESOURCE_OBJECT@resourcesBundle@servletRequest"
              shortDescBinding="SELECT_RESOURCE_OBJECT@resourcesBundle@servletRequest"
              searchTextBinding="searchCriteria@defaultBean@servletRequest">

    <uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
                      errorTableBinding="remoteOpResults@defaultBean@servletRequest"
                      destTableBinding="msgUrls@servletRequest"/>
    </uix:messages>

            <uix:formValue
                name="pageName"
                value="/has/resources/selectResource.jsp"/>
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_RESOURCE_SEARCH_ITEM@resourcesBundle@servletRequest"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                  beanKey="defaultResBean"
                  alternateTextBinding="MSG_NO_RESOURCES_FOUND@resourcesBundle@servletRequest"
                  name="resourceDS"
                  dataSourceProp="resourceDS"
                  summaryBinding="SELECT_RESOURCE_TABLE_SUMMARY@resourcesBundle@servletRequest"
                  width="100%"
                  blockSize="50"
                  formSubmitted="true"
                  proxied="true">

                <uix:tableSelection>
                  <uix:singleSelection shortDescBinding="SELECT@hasBundle@servletRequest"
                      selectedIndex="0"/>
                </uix:tableSelection>
              </oem:table>
            </uix:contents>
          </uix:listOfValues>
      </uix:contents>
    </uix:body>

  </uix:document>
</uix:renderingContext>
