<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_SERVER_TITLE@resourcesBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <uix:contents>
          <%--<uix:form name="selectServerForm" destinationBinding="lovDestination@servletRequest">--%>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        --%>
          <uix:listOfValues
              titleBinding="SELECT_SERVER_OBJECT@resourcesBundle@servletRequest"
              shortDescBinding="SELECT_SERVER_OBJECT@resourcesBundle@servletRequest"
              searchTextBinding="searchCriteria@defaultBean@servletRequest">

    <uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                      errorTableBinding="remoteOpResults@defaultBean@servletRequest"
                      destTableBinding="msgUrls@servletRequest"/>
    </uix:messages>

            <uix:formValue
                name="pageName"
                value="/has/resources/selectServer.jsp"/>
              <uix:formValue name="sourcePage" valueBinding="sourcePage@servletRequest"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_SERVER_SEARCH_ITEM@resourcesBundle@servletRequest"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                  beanKey="defaultBean"
                  alternateTextBinding="MSG_NO_HOSTS_FOUND@resourcesBundle@servletRequest"
                  name="dataSource"
                  summaryBinding="SELECT_SERVER_TABLE_SUMMARY@resourcesBundle@servletRequest"
                  dataSourceProp="dataSource"
                  width="100%"
                  blockSize="50"
                  formSubmitted="true"
                  proxied="true">

                <uix:tableSelection>
                    <uix:switcher childNameBinding="sourcePage@servletRequest" defaultCase="default">
                        <uix:case name="/has/resources/addEditBegin.jsp" >
                            <uix:multipleSelection selectionBinding="viewableSelectedHostIndexes@addRes@servletRequest" selectedBinding="isSelected" shortDescBinding="SELECT@hasBundle@servletRequest"/>
                        </uix:case>
                        <uix:case name="default">
                            <uix:singleSelection shortDescBinding="SELECT@hasBundle@servletRequest"
                                selectedIndex="0"/>
                        </uix:case>
                    </uix:switcher>
                </uix:tableSelection>
              </oem:table>
            </uix:contents>
          </uix:listOfValues>
          <%--</uix:form>--%>
      </uix:contents>
    </uix:body>

  </uix:document>
</uix:renderingContext>
