<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/enablePPR.jspf" %>
<%@ include file="/oemTitle.jspf" %>
<%@ include file="/oemNoscript.jspf"%>
<uix:body>
<db:form name="viewPerXForm" method="post"
         destination="/console/has/resources"
         copyParams="target,type,isRepDown">
<uix:formValue name="vipOperation" valueBinding="vipOperation@servletRequest"/>
<uix:formValue name="resName" valueBinding="resName@servletRequest"/>
<uix:formValue name="pageNum" value="4"/>
<uix:pageLayout>
<%@ include file="/oemGlobal.jspf" %>
<uix:messages>
    <oem:messageBox messageTypeBinding="messageType@servletRequest"
                    errorTableBinding="msgBox@servletRequest"
                    destTableBinding="msgUrls@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
<uix:stackLayout>
<uix:contents>
<uix:header textBinding="VIEW_PERX_HEADER@resourcesBundle@servletRequest">
<uix:tableLayout width="100%" >
<uix:rowLayout>
    <uix:tableLayout width="95%" cellSpacing="15">
        <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="25%">
                <uix:messagePrompt promptBinding="CARDINALITY@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="cardinalityIDPerX@addPerX@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
            <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="SERVER_NAME@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="serverNamePerX@addPerX@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
            <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="SPECIFY_DEGREE_ID@resourcesBundle@servletRequest" labeledNodeId="degreeIDPerX"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                <uix:styledText styleClass="OraDataText" textBinding="degreeIDPerX@addPerX@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>


        <uix:rowLayout>
            <uix:cellFormat hAlign="right">
                <uix:messagePrompt labeledNodeId="loadPerX"
                                   promptBinding="LOAD@resourcesBundle@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left" columnSpan="3">
                <uix:styledText styleClass="OraDataText" textBinding="viewableValue@loadPerX@addPerX@servletRequest"/>
            </uix:cellFormat>
        </uix:rowLayout>
    </uix:tableLayout>
</uix:rowLayout>


<uix:rowLayout>
    <uix:header textBinding="START_PARAMETERS_HEADER@resourcesBundle@servletRequest">
        <uix:tableLayout width="95%" cellSpacing="15">
            <uix:rowLayout>
                <uix:cellFormat columnSpan="4">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="START_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>


            <uix:rowLayout>
                <uix:cellFormat hAlign="right" columnSpan="1" width="25%">
                    <uix:messagePrompt labeledNodeId="startAttemptsPerX"
                                       promptBinding="START_ATTEMPTS@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableValue@startAttemptsPerX@addPerX@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>


            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:stackLayout>
                        <uix:messagePrompt labeledNodeId="startTimeoutPerX"
                                           promptBinding="START_TIMEOUT@resourcesBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                    </uix:stackLayout>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableValue@startTimeoutPerX@addPerX@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                    <uix:messagePrompt labeledNodeId="uptimeThresholdPerX"
                                       promptBinding="UPTIME_THRESHOLD@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableValue@uptimeThresholdPerX@addPerX@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>
    </uix:header>
</uix:rowLayout>

<%-- Stop Parameters --%>
<uix:rowLayout>
    <uix:header textBinding="STOP_PARAMETERS_HEADER@resourcesBundle@servletRequest">
        <uix:tableLayout width="95%" cellSpacing="15">
            <uix:rowLayout>
                <uix:cellFormat columnSpan="4">
                    <uix:styledText styleClass="OraInstructionText"
                                    textBinding="STOP_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
                <uix:cellFormat hAlign="right" width="25%">
                    <uix:stackLayout>
                        <uix:messagePrompt labeledNodeId="stopTimeoutPerX"
                                           promptBinding="STOP_TIMEOUT@resourcesBundle@servletRequest"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
                    </uix:stackLayout>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="viewableValue@stopTimeoutPerX@addPerX@servletRequest"/>
                </uix:cellFormat>
            </uix:rowLayout>
        </uix:tableLayout>
    </uix:header>
</uix:rowLayout>


<%-- Status Parameters --%>
<uix:rowLayout>
<uix:header textBinding="STATUS_PARAMETERS_HEADER@resourcesBundle@servletRequest">
<uix:tableLayout width="95%" cellSpacing="15">
<uix:rowLayout>
    <uix:cellFormat columnSpan="4">
        <uix:styledText styleClass="OraInstructionText"
                        textBinding="STATUS_PARAMETERS_INTRO@resourcesBundle@servletRequest"/>
    </uix:cellFormat>
</uix:rowLayout>

<uix:rowLayout>
    <uix:cellFormat hAlign="right" width="25%">
        <uix:stackLayout>
            <uix:messagePrompt labeledNodeId="checkIntervalPerX"
                               promptBinding="CHECK_INTERVAL@resourcesBundle@servletRequest"/>
            <uix:styledText styleClass="OraInlineInfoText"
                            textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
        </uix:stackLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="viewableValue@checkIntervalPerX@addPerX@servletRequest"/>
    </uix:cellFormat>
</uix:rowLayout>

<uix:rowLayout>
    <uix:cellFormat hAlign="right">
        <uix:stackLayout>
            <uix:messagePrompt labeledNodeId="scriptTimeoutPerX"
                               promptBinding="SCRIPT_TIMEOUT@resourcesBundle@servletRequest"/>
            <uix:styledText styleClass="OraInlineInfoText"
                            textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
        </uix:stackLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="viewableValue@scriptTimeoutPerX@addPerX@servletRequest"/>
    </uix:cellFormat>
</uix:rowLayout>

<uix:rowLayout>
    <uix:cellFormat hAlign="right">
        <uix:messagePrompt labeledNodeId="restartAttemptsPerX"
                           promptBinding="RESTART_ATTEMPTS@resourcesBundle@servletRequest"/>
    </uix:cellFormat>
    <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="viewableValue@restartAttemptsPerX@addPerX@servletRequest"/>
    </uix:cellFormat>
</uix:rowLayout>

<uix:rowLayout>
    <uix:cellFormat hAlign="right">
        <uix:stackLayout>
            <uix:messagePrompt labeledNodeId="failureThresholdPerX"
                               promptBinding="FAILURE_THRESHOLD@resourcesBundle@servletRequest"/>
            <uix:styledText styleClass="OraInlineInfoText"
                            textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
        </uix:stackLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="viewableValue@failureThresholdPerX@addPerX@servletRequest"/>
    </uix:cellFormat>
</uix:rowLayout>

<uix:rowLayout>
    <uix:cellFormat hAlign="right">
        <uix:stackLayout>
            <uix:messagePrompt labeledNodeId="failureIntervalPerX"
                               promptBinding="FAILURE_INTERVAL@resourcesBundle@servletRequest"/>
            <uix:styledText styleClass="OraInlineInfoText"
                            textBinding="IN_SECONDS@resourcesBundle@servletRequest"/>
        </uix:stackLayout>
    </uix:cellFormat>
    <uix:cellFormat hAlign="left">
        <uix:styledText styleClass="OraDataText" textBinding="viewableValue@failureIntervalPerX@addPerX@servletRequest"/>
    </uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>
</uix:header>
</uix:rowLayout>

<uix:header textBinding="UD_PERX_HEADER@resourcesBundle@servletRequest"
            renderedBinding="showUdParamPerXTable@addPerX@servletRequest">
    <uix:spacer height="15"/>
    <uix:table id="udParamTablePerX" name="udParamTablePerX" width="40%"
               tableDataBinding="udParamPerXList@addPerX@servletRequest"
               shortDescBinding="UDP_TABLE_DESC@resourcesBundle@servletRequest">
        <uix:tableFormat tableBanding="rowBanding"/>
        <uix:column shortDescBinding="UDP_NAME_DESC@resourcesBundle@servletRequest">
            <uix:columnHeader>
                <uix:styledText textBinding="UDP_NAME@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
            <uix:contents>
                <uix:styledText textBinding="attributeName"/>
            </uix:contents>
        </uix:column>
        <%--<uix:column shortDescBinding="UDP_TYPE_DESC@resourcesBundle@servletRequest">--%>
        <%--<uix:columnHeader>--%>
        <%--<uix:styledText textBinding="UDP_TYPE@resourcesBundle@servletRequest"/>--%>
        <%--</uix:columnHeader>--%>
        <%--<uix:contents>--%>
        <%--<%--<uix:radioButton name="udParamType" text="text" valueBinding="type" selectedValue="string"/>--%>
        <%--<%--<uix:radioButton name="udParamType" text="number" valueBinding="type" selectedValue="int"/>--%>
        <%--<uix:styledText textBinding="type"/>--%>
        <%--<uix:formValue name="udParamType" valueBinding="type"/>--%>
        <%--</uix:contents>--%>
        <%--</uix:column>--%>
        <uix:column
                shortDesc="UDP_DEFAULT_VALUE_DESC@resourcesBundle@servletRequest">
            <uix:columnHeader>
                <uix:styledText textBinding="UDP_DEFAULT_VALUE@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
            <uix:contents>
                <uix:styledText styleClass="OraDataText" textBinding="value"/>
            </uix:contents>
        </uix:column>
        <uix:footer>
            <uix:tableFooter>
                <uix:contents>
                </uix:contents>
            </uix:tableFooter>
        </uix:footer>
    </uix:table>
</uix:header>
</uix:tableLayout>
</uix:header>
</uix:contents>
</uix:stackLayout>
<uix:contentFooter>
    <uix:pageButtonBar>
        <uix:spacer width="10"/>
        <uix:flowLayout>
            <uix:submitButton textBinding="RETURN@hasBundle@servletRequest"
                              name="event" value="viewRes"/>
        </uix:flowLayout>
    </uix:pageButtonBar>
</uix:contentFooter>
</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
