<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

  <%@ include file="/oemTitle.jspf" %>
  <%@ include file="/oemNoscript.jspf"%>
  
  <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
    <db:form name="foo" destination="/em/console/has/resources" method="post" 
      copyParams="target,type,isRepDown">
<%-- this is required for refresh event.  --%>
<uix:formValue name="filterByHost" valueBinding="filterByHost@defaultBean@servletRequest"/>
<uix:formValue name="returnURL" valueBinding="returnURL@defaultBean@servletRequest"/>
  <uix:pageLayout>
  <%@ include file="/database/global.jspf" %>

<uix:messages>
    <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                       errorTableBinding="msgBox@servletRequest"
                       destTableBinding="msgUrls@servletRequest"
                       titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>

      <uix:header textBinding="MANAGE_RESOURCES@resourcesBundle@servletRequest">

	    <%-- page refresh time / refresh button --%>
	    <uix:tableLayout width="100%">
	    <uix:rowLayout>

  	    <uix:cellFormat hAlign="right" vAlign="top" width="35%">
	       <uix:flowLayout>
	         <uix:styledText styleClass="OraTipText" 
	              textBinding="PAGE_REFRESHED@hasBundle@servletRequest"/>
	         <uix:spacer width="5" />  

	         <uix:styledText styleClass="OraTipLabel" 
	              textBinding="refreshTime@defaultBean@servletRequest"/>

	         <uix:spacer width="5" />  
   	         <uix:submitButton textBinding="REFRESH_BUTTON@hasBundle@servletRequest" name="event" value="doLoad"/>

	      </uix:flowLayout>
            </uix:cellFormat> 	    
	    </uix:rowLayout> 	    
	  </uix:tableLayout>	    


        <uix:stackLayout>
          <uix:contents>
          
          <uix:tableLayout width="100%" cellSpacing="2">

              <%-- Intro --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="3">
                  <uix:styledText textBinding="RESOURCES_INTRO@resourcesBundle@servletRequest" 
                    styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>

<uix:rowLayout>
<uix:spacer height="10"/>
</uix:rowLayout>

<uix:rowLayout>
                    <uix:tableLayout>

                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" 
                                        textBinding="RESOURCE_COUNT@resourcesBundle@servletRequest"/>
                      </uix:cellFormat>
<uix:cellFormat>
<uix:tableLayout>
<uix:rowLayout>
                      <uix:cellFormat>
                      <uix:spacer width="10"/>
                      <uix:styledText styleClass="OraDataText"
                                textBinding="resourcesCount@defaultBean@servletRequest"/>
                      </uix:cellFormat>
<uix:spacer width="10"/>
                      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">
                      <uix:styledText styleClass="OraDataText" text="("/>
<uix:spacer width="5"/>
                      </uix:cellFormat>

                      <uix:cellFormat renderedBinding="showUpCount@defaultBean@servletRequest">
                      <uix:image sourceBinding="upIconPath@defaultBean@servletRequest"
                                 shortDescBinding="UP@resourcesBundle@servletRequest"           />

                      <uix:styledText styleClass="OraDataText"
                                textBinding="upResCount@defaultBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      </uix:cellFormat>

                      <uix:cellFormat renderedBinding="showPartiallyUpCount@defaultBean@servletRequest">
                      <uix:image sourceBinding="partiallyUpIconPath@defaultBean@servletRequest" shortDescBinding="PARTIALLY_UP@resourcesBundle@servletRequest"/>

                      <uix:styledText styleClass="OraDataText"
                                textBinding="partiallyUpResCount@defaultBean@servletRequest"/>
                      <uix:spacer width="5"/>
</uix:cellFormat>

                      <uix:cellFormat renderedBinding="showQuandaryCount@defaultBean@servletRequest">
                      <uix:image sourceBinding="intermediateIconPath@defaultBean@servletRequest"
                                 shortDescBinding="QUANDARY@resourcesBundle@servletRequest"           />

                      <uix:styledText styleClass="OraDataText"
                                textBinding="quandaryResCount@defaultBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      </uix:cellFormat>


                      <uix:cellFormat renderedBinding="showDownCount@defaultBean@servletRequest">
                      <uix:image sourceBinding="downIconPath@defaultBean@servletRequest" shortDescBinding="DOWN@resourcesBundle@servletRequest"/>

                      <uix:styledText styleClass="OraDataText"
                                textBinding="downResCount@defaultBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      </uix:cellFormat>

                      <uix:cellFormat renderedBinding="showUnknownCount@defaultBean@servletRequest">
                      <uix:image sourceBinding="unknownIconPath@defaultBean@servletRequest" shortDescBinding="UNKNOWN@resourcesBundle@servletRequest"/>

                      <uix:styledText styleClass="OraDataText"
                                textBinding="unknownrescount@defaultBean@servletRequest"/>
                      <uix:spacer width="5"/>
                      </uix:cellFormat>

<uix:cellFormat>

                      <uix:styledText styleClass="OraDataText" text=")"/>
                      </uix:cellFormat>
</uix:rowLayout>
</uix:tableLayout>
</uix:cellFormat>
                    </uix:rowLayout>
<uix:rowLayout>
                      <uix:cellFormat hAlign="right"  vAlign="top"  wrappingDisabled="true">

                      </uix:cellFormat>

<uix:cellFormat hAlign="right" columnSpan="20">
<uix:spacer width="10"/>
<uix:styledText textBinding="RESOURCE_COUNT_TIP@resourcesBundle@servletRequest" styleClass="OraInlineInfoText"/>
</uix:cellFormat>
</uix:rowLayout>
                  </uix:tableLayout>
</uix:rowLayout>


<uix:rowLayout>
<uix:spacer height="5"/>
</uix:rowLayout>
              <uix:rowLayout>
                  <uix:cellFormat columnSpan="3">
                      <uix:switcher childNameBinding="showSimpleFilter@defaultBean@servletRequest" defaultCase="true">
                          <uix:case name="true">
                              <uix:flowLayout>
                                  <uix:styledText styleClass="OraInstructionText" textBinding="SEARCH_DIALOG@resourcesBundle@servletRequest" labeledNodeId="filterText"/>
                                  <uix:spacer width="5"/>
                                  <uix:textInput id="filterText" name="filterText" textBinding="filterText@defaultBean@servletRequest"/>
                                  <uix:spacer width="5"/>
                                  <uix:submitButton textBinding="GO@hasBundle@servletRequest" name="event" value="resourceTableFilter"/>
                                  <uix:spacer width="5"/>
                                  <uix:link textBinding="ADVANCED_SEARCH@hasBundle@servletRequest" styleClass="OraInstructionText" onClick="submitForm('foo', true, {event:'switchResSearch'})"/>
                              </uix:flowLayout>
                          </uix:case>
                          <uix:case name="false">
                              <uix:header textBinding="ADVANCED_SEARCH@hasBundle@servletRequest">
                                  <uix:labeledFieldLayout width="50%" fieldWidth="25%" labelWidth="25%" columns="2">
                                      <uix:messageTextInput name="advSearchName" promptBinding="RESOURCE_NAME@resourcesBundle@servletRequest" textBinding="filterText@defaultBean@servletRequest"/>
                                      <uix:messageTextInput name="advSearchType" promptBinding="RESOURCE_TYPE@resourcesBundle@servletRequest" textBinding="advSearchType@defaultBean@servletRequest"/>
                                      <uix:spacer width="5"/>
                                      <uix:messageTextInput name="advSearchSPName" promptBinding="SERVER_GROUP@resourcesBundle@servletRequest" textBinding="advSearchSPName@defaultBean@servletRequest"/>
                                  </uix:labeledFieldLayout>
                                  <uix:flowLayout>
                                      <uix:spacer width="10"/>
                                      <uix:submitButton textBinding="GO@hasBundle@servletRequest" name="event" value="advancedSearch"/>
                                      <uix:spacer width="5"/>
                                      <uix:link textBinding="SIMPLE_SEARCH@hasBundle@servletRequest" styleClass="OraInstructionText" onClick="submitForm('foo', true, {event:'switchResSearch'})"/>
                                  </uix:flowLayout>

                              </uix:header>
                          </uix:case>

                      </uix:switcher>
                  </uix:cellFormat>
              </uix:rowLayout>

<uix:rowLayout>
<uix:spacer height="10"/>
</uix:rowLayout>
              <%-- Show Internal Resources Check Box --%>
              <uix:rowLayout>
                <uix:cellFormat columnSpan="3">
                  <uix:checkBox textBinding="SHOW_INTERNAL_RESOURCES@resourcesBundle@servletRequest" name="showInternalResources" checkedBinding="showInternalResources@defaultBean@servletRequest" shortDescBinding="SHOW_INTERNAL_RESOURCES@resourcesBundle@servletRequest" onClick="submitForm(document.forms[0], true, {'event':'toggleInternalResources'})"/>
                </uix:cellFormat>
              </uix:rowLayout>



                  <uix:rowLayout>
                    <uix:tableLayout width="100%">
                      <uix:rowLayout hAlign="right">
                        <uix:cellFormat hAlign="right">
                          <uix:pageButtonBar>
                            <uix:submitButton textBinding="ADD_RESOURCE@resourcesBundle@servletRequest" name="event" value="add"/>
                            <uix:submitButton textBinding="ADD_APPLICATION_VIP@resourcesBundle@servletRequest" name="event" value="addVip"/>
                          </uix:pageButtonBar>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:rowLayout>

              <%-- Resources Table --%>
<%-- --%>
<%-- 
              <uix:rowLayout>
              <oem:table name="resourcesTable"
                   width="100%" blockSize="50"
                   dataSourceProp="resourcesTable"
                   beanKey="defaultBean"
                   alternateTextBinding="NO_RESOURCES@resourcesBundle@servletRequest"
                   formSubmitted="true"
		               summaryBinding="RESOURCES_LIST@resourcesBundle@servletRequest" detailDisclosureBinding="expansionDetails@defaultBean@servletRequest" valueBinding="resourcesList@resourcesTable@defaultBean@servletRequest">
                   <uix:tableSelection>
                      <uix:multipleSelection shortDescBinding="SELECT@commonBundle@servletRequest" selectionBinding="selectedIndexes@defaultBean@servletRequest" selectedBinding="isSelected">
      
                          <uix:submitButton textBinding="RESOURCES_VIEW@resourcesBundle@servletRequest" name="event" value="view"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="EDIT@hasBundle@servletRequest" name="event" value="edit" rendered="true"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="DELETE@resourcesBundle@servletRequest" name="event" value="delete"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="RESOURCES_START@resourcesBundle@servletRequest" name="event" value="start" />
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="RESOURCES_STOP@resourcesBundle@servletRequest" name="event" value="stop" />
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="RESOURCES_RELOCATE@resourcesBundle@servletRequest" name="event" value="relocate"/>
                     </uix:multipleSelection>
                  </uix:tableSelection>
              </oem:table>
              </uix:rowLayout>
--%>
              <%-- New Resources Table --%>

<uix:rowLayout>
              <uix:table allDetailsEnabled="true" name="resourcesTable"
                   width="100%" blockSize="50"
                   alternateTextBinding="emptyTableMessage@resourcesTable@defaultBean@servletRequest"
                   formSubmitted="true"
		               summaryBinding="RESOURCES_LIST@resourcesBundle@servletRequest"
                   detailDisclosureBinding="expansionDetails@defaultBean@servletRequest" tableDataBinding="resourcesListUIXTable@resourcesTable@defaultBean@servletRequest" minValue="1" maxValueBinding="maxSize@resourcesTable@defaultBean@servletRequest">
                   <uix:tableSelection>
                      <uix:multipleSelection shortDescBinding="SELECT@hasBundle@servletRequest" selectionBinding="selectedIndexes@defaultBean@servletRequest" selectedBinding="isSelected">
      
                          <uix:submitButton textBinding="RESOURCES_VIEW@resourcesBundle@servletRequest" name="event" value="view"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="EDIT@hasBundle@servletRequest" name="event" value="edit" rendered="true"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="REMOVE@hasBundle@servletRequest" name="event" value="delete"/>
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="RESOURCES_START@resourcesBundle@servletRequest" name="event" value="start" />
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="RESOURCES_STOP@resourcesBundle@servletRequest" name="event" value="stop" />
                          <uix:spacer width="5"/>
                          <uix:submitButton textBinding="RESOURCES_RELOCATE@resourcesBundle@servletRequest" name="event" value="relocate"/>
                     </uix:multipleSelection>
                  </uix:tableSelection>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader textBinding="RESOURCE_NAME@resourcesBundle@servletRequest" sortableBinding="nameColSort@resourcesTable@defaultBean@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:link  textBinding="name" destinationBinding="nameLink"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader sortableBinding="cardinalityColSort@resourcesTable@defaultBean@servletRequest" textBinding="CARDINALITY@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:link  textBinding="cardinality" destinationBinding="cardinalityLink"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader sortableBinding="currentStateColSort@resourcesTable@defaultBean@servletRequest" textBinding="RESOURCE_CURRENT_STATE@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
<uix:flowLayout>
                   <uix:image sourceBinding="currentStateImage" shortDescBinding="currentStateImageDesc"/>
<uix:spacer width="5"/>
<uix:include nodeBinding="currentStateDetails"/>
</uix:flowLayout>

               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader sortableBinding="targetStateColSort@resourcesTable@defaultBean@servletRequest" textBinding="RESOURCE_TARGET_STATE@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
<uix:flowLayout>
                   <uix:image sourceBinding="targetStateImage"  shortDescBinding="targetStateImageDesc"/>
<uix:spacer width="5"/>
<uix:include nodeBinding="targetStateDetails"/>
</uix:flowLayout>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader sortableBinding="runningHostsColSort@resourcesTable@defaultBean@servletRequest" textBinding="RUNNING_HOSTS@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="runningHosts"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader sortableBinding="resourceTypeColSort@resourcesTable@defaultBean@servletRequest" textBinding="RESOURCE_TYPE@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="type"/>
               </uix:contents>             
          </uix:column>
          <uix:column>
            <uix:columnHeader> 
              <uix:sortableHeader sortableBinding="ownerColSort@resourcesTable@defaultBean@servletRequest" textBinding="OWNER@resourcesBundle@servletRequest"/>
            </uix:columnHeader>
               <uix:contents>
                   <uix:styledText  textBinding="owner"/>
               </uix:contents>             
          </uix:column>
<uix:detail>
<uix:stackLayout>
<uix:spacer height="10"/>


<uix:tableLayout  width="100%" cellSpacing="2">
<uix:contents childDataBinding="myDependentsTable">
<uix:rowLayout>
<uix:cellFormat hAlign="right" width="30%" vAlign="top">
<uix:styledText styleClass="OraInstructionText"  textBinding="resName"/>
</uix:cellFormat>
<uix:cellFormat hAlign="left" vAlign="top">
<uix:include nodeBinding="resMyDepsValue"/>
</uix:cellFormat>
</uix:rowLayout>
</uix:contents>
</uix:tableLayout>

<uix:spacer height="10"/>

<uix:tableLayout  width="100%" cellSpacing="2">
<uix:contents childDataBinding="iDependOnTable">
<uix:rowLayout>
<uix:cellFormat hAlign="right" width="30%" vAlign="top">
<uix:styledText styleClass="OraInstructionText"  textBinding="resName"/>
</uix:cellFormat>
<uix:cellFormat hAlign="left" vAlign="top">
<uix:include nodeBinding="resDepValue"/>
</uix:cellFormat>
</uix:rowLayout>
</uix:contents>
</uix:tableLayout>

<uix:spacer height="5"/>
<uix:link textBinding="viewDetailsLabel" destinationBinding="nameLink"/>
<uix:spacer height="10"/>


</uix:stackLayout>
</uix:detail>
              </uix:table>
              </uix:rowLayout>


<%-- --%>


            <uix:rowLayout>
                <uix:spacer height="20" />
            </uix:rowLayout>
          <%-- Return Button --%>
          <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right">
          <uix:button textBinding="RETURN@hasBundle@servletRequest" destinationBinding="returnURL@defaultBean@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>
                                                                            
             </uix:tableLayout>
          </uix:contents>
        </uix:stackLayout>
        </uix:header> 


      </uix:pageLayout>
    </db:form>
  </uix:body>
  </uix:document>
</uix:renderingContext>
