<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<uix:body>
<db:form name="sg" method="POST" destination="/em/console/has/serverGroups" copyParams="target,type,isRepDown">
<uix:formValue name="originalEvent" valueBinding="originalEvent@servletRequest"/>

<uix:switcher childNameBinding="return2dbPage@servletRequest" defaultCase="false">
    <uix:case name="true">
        <uix:formValue name="return2dbPage" value="true"/>
    </uix:case>
    <uix:case name="false">
        <uix:formValue name="return2dbPage" value="false"/>
    </uix:case>
</uix:switcher>

<uix:switcher childNameBinding="showAdvanced@servletRequest" defaultCase="false">
    <uix:case name="true">
        <uix:formValue name="showAdvanced" value="true"/>
    </uix:case>
    <uix:case name="false">
        <uix:formValue name="showAdvanced" value="false"/>
    </uix:case>
</uix:switcher>
<uix:pageLayout>
<%@ include file="/oemGlobal.jspf" %>
<uix:messages>
    <oem:messageBox messageTypeBinding="messageType@servletRequest" errorTableBinding="msgBox@servletRequest"
                    destTableBinding="msgUrls@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
<uix:stackLayout>
<uix:contents>
<uix:tableLayout width="100%">
    <uix:rowLayout hAlign="right">
        <uix:cellFormat columnSpan="2" hAlign="right">
            <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event" value="addEditCancel"/>
            <uix:spacer width="10"/>
            <uix:switcher childNameBinding="isAddOperation@servletRequest" defaultCase="true">
                <uix:case name="true">
                    <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest" name="event"
                                      value="addFinish"/>
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest" name="event"
                                      value="editFinish"/>
                </uix:case>
            </uix:switcher>
        </uix:cellFormat>
    </uix:rowLayout>
</uix:tableLayout>
<uix:header textBinding="title@servletRequest">
<uix:contents>
    <uix:tableLayout width="100%" cellSpacing="5" cellPadding="5">
        <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="30%">
                <uix:messagePrompt promptBinding="SG_NAME@sgBundle@servletRequest" labeledNodeId="serverGroupName"
                                   renderedBinding="isAddOperation@servletRequest" required="uiOnly"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                <uix:flowLayout>
                    <uix:messagePrompt prompt="ora." renderedBinding="showOra@addSGBean@servletRequest"/>
                    <uix:textInput name="serverGroupName" id="serverGroupName"
                                   textBinding="serverGroupName@addSGBean@servletRequest" columns="30"
                                   renderedBinding="isAddOperation@servletRequest"
                            />
                    <!--tipBinding="NAME_TIP@sgBundle@servletRequest"/>-->
                </uix:flowLayout>
            </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout renderedBinding="serverPoolOperation@addSGBean@servletRequest">
            <uix:cellFormat hAlign="right" width="30%">
                <uix:messagePrompt promptBinding="CONTAINER_FOR@sgBundle@servletRequest" labeledNodeId="orclSPRadio"
                                   renderedBinding="showForWhatResources@addSGBean@servletRequest"/>
            </uix:cellFormat>
            <uix:cellFormat>
                <uix:tableLayout cellSpacing="5" cellPadding="0">
                    <uix:rowLayout hAlign="left">
                        <uix:cellFormat hAlign="left">
                            <uix:radioButton name="orclSPRadio" value="orclSPRadio" id="orclSPRadio"
                                             selectedValueBinding="forWhatResources@addSGBean@servletRequest"
                                             renderedBinding="showForWhatResources@addSGBean@servletRequest"
                                             onChange="submitForm(document.forms[0], true, {'event':'toggleSPContainerSelection'})"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                            <uix:messagePrompt promptBinding="ORCL_SP@sgBundle@servletRequest" renderedBinding="showForWhatResources@addSGBean@servletRequest"/>
                        </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout hAlign="left">
                        <uix:cellFormat hAlign="left">
                            <uix:radioButton name="orclSPRadio" value="NonOrcleSPRadio" id="NonOrcleSPRadio"
                                                    selectedValueBinding="forWhatResources@addSGBean@servletRequest"
                                                    renderedBinding="showForWhatResources@addSGBean@servletRequest"
                                                    onChange="submitForm(document.forms[0], true, {'event':'toggleSPContainerSelection'})"
                                                    />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messagePrompt promptBinding="NON_ORCL_SP@sgBundle@servletRequest" renderedBinding="showForWhatResources@addSGBean@servletRequest" labeledNodeId="NonOrcleSPRadio"/>
                        </uix:cellFormat>
                    </uix:rowLayout>
                </uix:tableLayout>
            </uix:cellFormat>
        </uix:rowLayout>

        <%--<uix:rowLayout renderedBinding="serverPoolOperation@addSGBean@servletRequest">--%>
            <%--<uix:cellFormat hAlign="right" width="31.8%">--%>
            <%--</uix:cellFormat>--%>
            <%--<uix:cellFormat>--%>
            <%--</uix:cellFormat>--%>
        <%--</uix:rowLayout>--%>

        <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="30%">
                <uix:messagePrompt promptBinding="MAX_SIZE@sgBundle@servletRequest" labeledNodeId="specify_max_size"/>
            </uix:cellFormat>
            <uix:cellFormat hAlign="left">
                <uix:tableLayout cellSpacing="5" cellPadding="0">
                    <uix:rowLayout hAlign="left">
                        <uix:cellFormat hAlign="left">
                            <uix:radioButton name="maximumSizeType" value="enitre_cluster"
                                             selectedValueBinding="maximumSizeType@addSGBean@servletRequest"
                                             readOnlyBinding="maxReadOnly@addSGBean@servletRequest" id="entire_cluster"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:messagePrompt promptBinding="ENTIRE_CLUSTER@sgBundle@servletRequest" labeledNodeId="entire_cluster"/>
                        </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                        <uix:cellFormat hAlign="left">
                            <uix:radioButton name="maximumSizeType" value="specify_max_size" id="specify_max_size"
                                             selectedValueBinding="maximumSizeType@addSGBean@servletRequest"
                                             readOnlyBinding="maxReadOnly@addSGBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                            <uix:switcher childNameBinding="maxSize@addSGBean@servletRequest">
                                <uix:case name="-1">
                                    <uix:messageTextInput name="maxSize" columns="8" labeledNodeId="specify_max_size"
                                                          promptBinding="SPECIFY_MAX_SIZE@sgBundle@servletRequest"
                                                          readOnlyBinding="maxReadOnly@addSGBean@servletRequest">
                                        <uix:onBlurValidater>
                                            <!--min can be zero also -->
                                            <uix:decimal maxScale="0" minValue="0"/>
                                        </uix:onBlurValidater>
                                    </uix:messageTextInput>
                                </uix:case>
                                <uix:default>
                                    <uix:messageTextInput name="maxSize" columns="8" labeledNodeId="specify_max_size"
                                                          promptBinding="SPECIFY_MAX_SIZE@sgBundle@servletRequest"
                                                          textBinding="maxSize@addSGBean@servletRequest"
                                                          readOnlyBinding="maxReadOnly@addSGBean@servletRequest">
                                        <uix:onBlurValidater>
                                            <!--min can be zero also -->
                                            <uix:decimal maxScale="0" minValue="0"/>
                                        </uix:onBlurValidater>
                                    </uix:messageTextInput>
                                </uix:default>
                            </uix:switcher>
                        </uix:cellFormat>
                    </uix:rowLayout>
                </uix:tableLayout>
            </uix:cellFormat>
        </uix:rowLayout>
    </uix:tableLayout>


</uix:contents>
</uix:header>
<%-- Advanced Section --%>
<uix:hideShowHeader size="1" textBinding="ADVANCED@sgBundle@servletRequest"
                    disclosedBinding="showAdvanced@servletRequest" id="advancedAddEdit" formSubmitted="true">
<uix:contents>
<uix:tableLayout width="100%" cellPadding="5" cellSpacing="5">
    <uix:rowLayout>
        <uix:cellFormat hAlign="right" width="30%">
            <uix:messagePrompt promptBinding="MIN_SIZE@sgBundle@servletRequest" labeledNodeId="minSize"/>
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
            <uix:messageTextInput name="minSize" id="minSize"
                                  textBinding="minSize@addSGBean@servletRequest" columns="8"
                                  readOnlyBinding="minReadOnly@addSGBean@servletRequest"
                                  tipBinding="MIN_SIZE_TIP@sgBundle@servletRequest">
                <uix:onBlurValidater>
                    <!--min can be zero also -->
                    <uix:decimal maxScale="0" minValue="0"/>
                </uix:onBlurValidater>
            </uix:messageTextInput>
        </uix:cellFormat>
    </uix:rowLayout>
    <uix:rowLayout>
        <uix:cellFormat hAlign="right" width="30%">
            <uix:messagePrompt promptBinding="IMPORTANCE@sgBundle@servletRequest" labeledNodeId="importance"/>
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
            <uix:messageTextInput name="importance" id="importance"
                                  textBinding="importance@addSGBean@servletRequest" columns="8" required="no"
                                  tipBinding="IMPORTANCE_TIP@sgBundle@servletRequest">
                <uix:onBlurValidater>
                    <uix:decimal maxScale="0" minValue="0"/>
                </uix:onBlurValidater>
            </uix:messageTextInput>
        </uix:cellFormat>
    </uix:rowLayout>
    <uix:rowLayout renderedBinding="showParentServerPools@addSGBean@servletRequest">
        <uix:cellFormat hAlign="right" width="30%">
            <uix:messagePrompt promptBinding="PARENT_SERVER_GROUP@sgBundle@servletRequest"/>
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
            <uix:tableLayout>
                <uix:rowLayout hAlign="left">
                    <uix:cellFormat hAlign="left">
                        <uix:include nodeBinding="parentServerGroupsCB@addSGBean@servletRequest"/>
                    </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                    <uix:cellFormat>
                        <uix:styledText textBinding="PARENT_GROUPS_TIP@sgBundle@servletRequest" styleClass="OraInlineInfoText"/>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
        </uix:cellFormat>
    </uix:rowLayout>

</uix:tableLayout>
<uix:spacer height="15"/>
<%-- parent groups --%>
<%--<uix:header size="2" textBinding="PARENT_SERVER_GROUPS@sgBundle@servletRequest"--%>
            <%--renderedBinding="showParentServerPools@addSGBean@servletRequest">--%>
    <%--<uix:stackLayout>--%>
        <%--<uix:contents>--%>
            <%--<uix:styledText styleClass="OraInstructionText"--%>
                            <%--textBinding="PARENT_GROUPS_INTRO@sgBundle@servletRequest"/>--%>
            <%--<uix:spacer height="5"/>--%>
            <%--<%--<uix:shuttle name="pg" leadingHeaderBinding="AVAILABLE_SGS@sgBundle@servletRequest"  disabledBinding="readOnly@addSGBean@servletRequest"--%>
            <%--<%--reorderable="false" trailingHeaderBinding="SELECTED_SGS@sgBundle@servletRequest">--%>
            <%--<%--<uix:leading>--%>
            <%--<%--<oem:list name="availableSGs"--%>
            <%--<%--shortDescBinding="AVAILABLE_SGS@sgBundle@servletRequest" multiple="true">--%>
            <%--<%--<uix:contents childDataBinding="availableServerGroups@addSGBean@servletRequest">--%>
            <%--<%--<uix:option textBinding="."/>--%>
            <%--<%--</uix:contents>--%>
            <%--<%--</oem:list>--%>
            <%--<%--</uix:leading>--%>
            <%--<%--<uix:trailing>--%>
            <%--<%--<oem:list name="selectedSGs"--%>
            <%--<%--shortDescBinding="SELECTED_SGS@sgBundle@servletRequest" multiple="true">--%>
            <%--<%--<uix:contents childDataBinding="selectedServerGroups@addSGBean@servletRequest">--%>
            <%--<%--<uix:option textBinding="."/>--%>
            <%--<%--</uix:contents>--%>
            <%--<%--</oem:list>--%>

            <%--<%--</uix:trailing>--%>
            <%--<%--</uix:shuttle>--%>
            <%--<%--<uix:choice name="pg" disabledBinding="readOnly@addSGBean@servletRequest" selectedValueBinding="selectedParentServerGroup@addSGBean@servletRequest">--%>
            <%--<%--<uix:contents childDataBinding="availableServerGroupsMap@addSGBean@servletRequest">--%>
            <%--<%--<uix:option textBinding="text" valueBinding="val" />--%>
            <%--<%--</uix:contents>--%>
            <%--<%--</uix:choice>--%>

        <%--</uix:contents>--%>
    <%--</uix:stackLayout>--%>
<%--</uix:header>--%>
<%-- End of Parent Groups --%>
<%--<uix:styledText styleClass="OraInstructionText"--%>
<%--textBinding="ADD_SG_SERVERS_SELECTION_INTRO@sgBundle@servletRequest"/>--%>
<uix:spacer height="15"/>
<%-- Servers --%>
<uix:header size="2" textBinding="SERVERS@sgBundle@servletRequest">
    <uix:stackLayout >
        <uix:contents >
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="ADD_SG_SERVERS_SELECTION_INTRO@sgBundle@servletRequest"/>
            <uix:spacer height="5"/>
            <uix:shuttle name="servers" leadingHeaderBinding="AVAILABLE_SERVERS@sgBundle@servletRequest"
                         disabledBinding="configureServersReadOnly@addSGBean@servletRequest"
                         reorderable="false" trailingHeaderBinding="SELECTED_SERVERS@sgBundle@servletRequest">
                <uix:leading>
                    <oem:list name="availableServers"
                              shortDescBinding="AVAILABLE_SERVERS@sgBundle@servletRequest" multiple="true">
                        <uix:contents childDataBinding="availableServers@addSGBean@servletRequest">
                            <uix:option textBinding="."/>
                        </uix:contents>
                    </oem:list>

                </uix:leading>
                <uix:trailing>
                    <oem:list name="selectedServerss"
                              shortDescBinding="SELECTED_SERVERS@sgBundle@servletRequest" multiple="true">
                        <uix:contents childDataBinding="selectedServers@addSGBean@servletRequest">
                            <uix:option textBinding="."/>
                        </uix:contents>
                    </oem:list>

                </uix:trailing>
            </uix:shuttle>
            <uix:spacer height="15"/>
            <uix:messageTextInput name="additionalServers"  renderedBinding="showParentServerPools@addSGBean@servletRequest"
                                  textBinding="additionalServers@addSGBean@servletRequest" columns="60"
                                  required="no" promptBinding="ADDITIONAL_SERVERS@sgBundle@servletRequest"
                                  tipBinding="ADDITIONAL_SERVERS_TIP@sgBundle@servletRequest"
                                  disabledBinding="configureServersReadOnly@addSGBean@servletRequest"/>
        </uix:contents>
    </uix:stackLayout>
</uix:header>
<%-- End of Servers --%>
<uix:spacer height="15"/>
<%-- Begin Overlapping Groups
<uix:header size="2" textBinding="OVERLAPPING_GROUPS@sgBundle@servletRequest">
 <uix:stackLayout>
     <uix:contents>
         <uix:styledText styleClass="OraInstructionText"
                         textBinding="OVERLAPPING_GROUPS_INTRO@sgBundle@servletRequest"/>
         <uix:spacer height="5"/>
         <uix:tableLayout cellSpacing="5">
             <uix:rowLayout>
                 <uix:cellFormat hAlign="left">
                     <uix:radioButton name="overlappingGroupsType" id="overlappingGroupsType"
                                      selectedValueBinding="overlappingGroupsType@addSGBean@servletRequest"
                                      value="from_available"
                                      disabledBinding="disableOverlappingGroups@defaultBean@servletRequest"/>
                 </uix:cellFormat>
                 <uix:cellFormat hAlign="left">
                     <uix:messagePrompt labeledNodeId="overlappingGroupsType"
                                        promptBinding="CHOOSE_FROM_EXISTING@sgBundle@servletRequest"/>
                     <uix:spacer width="5"/>
                     <uix:include nodeBinding="overlappingGroupsCB@defaultBean@servletRequest"/>
                 </uix:cellFormat>
             </uix:rowLayout>
             <uix:rowLayout>
                 <uix:radioButton name="overlappingGroupsType" id="new_selection"
                                  selectedValueBinding="overlappingGroupsType@addSGBean@servletRequest"
                                  value="new_selection"/>
                 <uix:messageTextInput name="newOverlappingGroups" labeledNodeId="new_selection"
                                       promptBinding="NEW_VALUE@sgBundle@servletRequest"
                                       textBinding="newOverlappingGroups@addSGBean@servletRequest"
                                       columns="40" required="no"/>
             </uix:rowLayout>
         </uix:tableLayout>
     </uix:contents>
 </uix:stackLayout>
</uix:header>
End Overlapping Groups --%>
<uix:spacer height="15"/>


<%-- Begin Exclusive Groups  --%>
<uix:header size="2" textBinding="EXCLUSIVE_GROUPS@sgBundle@servletRequest"
            renderedBinding="showExclusiveServerGroups@addSGBean@servletRequest">
    <uix:stackLayout>
        <uix:contents>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="EXCLUSIVE_GROUPS_INTRO@sgBundle@servletRequest"/>
            <uix:spacer height="5"/>
            <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                        <uix:radioButton name="exclusiveGroupsType" id="exclusiveGroupsTypefa"
                                         selectedValueBinding="exclusiveGroupsType@addSGBean@servletRequest"
                                         value="from_available"
                                         disabledBinding="disableExclusiveGroups@defaultBean@servletRequest"
                                         readOnlyBinding="readOnly@addSGBean@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                        <uix:messagePrompt labeledNodeId="exclusiveGroupsTypefa"
                                           promptBinding="CHOOSE_FROM_EXISTING@sgBundle@servletRequest"/>
                        <uix:spacer width="5"/>
                        <uix:include nodeBinding="exclusiveGroupsCB@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="left">
                    <uix:messageRadioButton name="exclusiveGroupsType" id="exclusiveGroupsTypenv"
                                     selectedValueBinding="exclusiveGroupsType@addSGBean@servletRequest"
                                     readOnlyBinding="readOnly@addSGBean@servletRequest"
                                     value="new_selection"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                    <uix:messageTextInput labeledNodeId="exclusiveGroupsTypenv newexclusiveGroupsTypetb" promptBinding="CREATE_NEW@sgBundle@servletRequest" name="newExclusiveGroups" id="newexclusiveGroupsTypetb"
                                          readOnlyBinding="readOnly@addSGBean@servletRequest"
                                          textBinding="newExclusiveGroups@adSGBean@servletRequest" columns="40"
                                          required="no"/>
                    </uix:cellFormat>
                </uix:rowLayout>
            </uix:tableLayout>
        </uix:contents>
    </uix:stackLayout>
</uix:header>
<%-- End Exclusive Groups --%>
</uix:contents>
</uix:hideShowHeader>
</uix:contents>
</uix:stackLayout>
<uix:contentFooter>
    <uix:pageButtonBar>
        <uix:spacer width="10"/>
        <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event" value="addEditCancel"/>
            <uix:spacer width="10"/>
            <uix:switcher childNameBinding="isAddOperation@servletRequest" defaultCase="true">
                <uix:case name="true">
                    <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest" name="event"
                                      value="addFinish"/>
                </uix:case>
                <uix:case name="false">
                    <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest" name="event"
                                      value="editFinish"/>
                </uix:case>
            </uix:switcher>
        </uix:flowLayout>
    </uix:pageButtonBar>
</uix:contentFooter>
</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
