<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
      <db:form name="foo" destination="/em/console/has/serverGroups" method="post" copyParams="target,type,isRepDown">
        <uix:pageLayout>
          <%@ include file="/database/global.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest" errorTableBinding="msgBox@servletRequest" destTableBinding="msgUrls@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:header textBinding="SERVER_GROUPS_LIST@sgBundle@servletRequest">
            <%-- page refresh time / refresh button --%>
            <uix:tableLayout width="100%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" width="35%">
                  <uix:flowLayout>
                    <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@hasBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraTipLabel" textBinding="refreshTime@defaultBean@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:submitButton textBinding="REFRESH_BUTTON@hasBundle@servletRequest" name="event" value="doLoad"/>
                  </uix:flowLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:stackLayout>
              <uix:contents>
                <uix:tableLayout width="100%" cellSpacing="2">
                  <%-- Intro --%>
                  <uix:rowLayout>
                    <uix:cellFormat columnSpan="3">
                      <uix:styledText textBinding="SG_INTRO@sgBundle@servletRequest" styleClass="OraInstructionText"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:tableLayout width="100%">
<uix:rowLayout>
<uix:spacer height="10"/>
</uix:rowLayout>

              <%-- Show Internal Resources Check Box --%>
              <%--<uix:rowLayout>--%>
              <%--</uix:rowLayout>--%>

<%--<uix:rowLayout>--%>
<%--<uix:spacer height="5"/>--%>
<%--</uix:rowLayout>--%>

                      <uix:rowLayout hAlign="right">
                          <uix:cellFormat columnSpan="3" hAlign="left" vAlign="top">
                            <uix:checkBox textBinding="SHOW_INTERNAL_POOLS@sgBundle@servletRequest" name="showInternalPools" checkedBinding="showInternalPools@defaultBean@servletRequest" shortDescBinding="SHOW_INTERNAL_POOLS@sgBundle@servletRequest" onClick="submitForm(document.forms[0], true, {'event':'toggleInternalPools'})"/>
                          </uix:cellFormat>

                        <uix:cellFormat hAlign="right">
                          <uix:pageButtonBar>
<%--
                            <uix:submitButton textBinding="ADD_SG@sgBundle@servletRequest" name="event" value="add"/>
--%>
                            <uix:submitButton textBinding="ADD_SP@sgBundle@servletRequest" name="event" value="addSP"/>
                          </uix:pageButtonBar>

                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <%--<oem:table name="serverGroupsTable" width="100%" blockSize="50" dataSourceProp="serverGroupsTable" beanKey="defaultBean" alternateTextBinding="NO_SG_DATA@sgBundle@servletRequest" formSubmitted="true" summaryBinding="SERVER_GROUPS_LIST@sgBundle@servletRequest">--%>
                      <%--<uix:tableSelection>--%>
                        <%--<uix:multipleSelection shortDescBinding="SELECT@commonBundle@servletRequest" selectionBinding="selectedIndexes@defaultBean@servletRequest" selectedBinding="isSelected">--%>
                          <%--<uix:submitButton textBinding="VIEW@sgBundle@servletRequest" name="event" value="view"/>--%>
                          <%--<uix:submitButton textBinding="EDIT@sgBundle@servletRequest" name="event" value="edit"/>--%>
                          <%--<uix:submitButton textBinding="REMOVE@sgBundle@servletRequest" name="event" value="remove"/>--%>
                        <%--</uix:multipleSelection>--%>
                      <%--</uix:tableSelection>--%>
                    <%--</oem:table>--%>
                      <uix:hGrid id="serverGroupsTable"
                           width="100%"
			   alternateTextBinding="noConsumersText@SGTreeBean@servletRequest"
			   columnHeaderDataBinding="columnHeaderData@SGTreeBean@servletRequest"
			   columnFormatsBinding="columnFormatData@SGTreeBean@servletRequest"
			   treeDataBinding="treeData@SGTreeBean@servletRequest"
			   formSubmitted="true"
			   proxyBinding="proxy@SGTreeBean@servletRequest"
                           summaryBinding="header@dataSourceBean@servletRequest">
                          <uix:tableSelection>

                                <uix:multipleSelection selectedBinding="selected" disabledBinding="disabled" >
                                    <uix:submitButton textBinding="VIEW@sgBundle@servletRequest" name="event" value="view"/>
                                    <uix:spacer width="5"/>
                                    <uix:submitButton textBinding="EDIT@sgBundle@servletRequest" name="event" value="edit"/>
                                    <uix:spacer width="5"/>
                                    <uix:submitButton textBinding="REMOVE@sgBundle@servletRequest" name="event" value="remove"/>
                                    <uix:spacer width="5"/>
                                    <uix:submitButton textBinding="RELOCATE_SERVERS@sgBundle@servletRequest" name="event" value="relocateServers"/>
                                </uix:multipleSelection>

                          </uix:tableSelection>

                          <!-- set first hgrid column header -->
                          <uix:nodeStamp>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:header textBinding="SG_NAME@sgBundle@servletRequest"/>
                                     <!--sortableBinding="firstHGridColumnSort@dataSourceBean@servletRequest"-->
                                 <!--valueBinding="firstHGridColKey@dataSourceBean@servletRequest"/>-->
                              </uix:columnHeader>

                              <uix:rowLayout>
                             <uix:spacer width="5" />
                                <uix:styledText textBinding="name"
                                             destinationBinding="nameDest"
                                             styleClass="OraFieldText" />

                                      </uix:rowLayout>
                            </uix:column>
                          </uix:nodeStamp>

                          <!-- set rest of hgrid column headers -->
                          <uix:columnHeaderStamp>
                            <uix:header textBinding="headerName" />
                                 <!--sortableBinding="sort"-->
                             <!--valueBinding="sortIndex"-->
                          </uix:columnHeaderStamp>

                          <!-- set hgrid column data -->
                          <uix:styledText textBinding="curSize"   />
                          <uix:styledText textBinding="minSize" />
                          <uix:styledText textBinding="maxSize"/>
                          <uix:styledText textBinding="importance"/>
                          <uix:styledText textBinding="owner"/>

                                      <%--<uix:formValue name="uniqueID" valueBinding="uid" />--%>

                       </uix:hGrid>


                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="showInternalPools@defaultBean@servletRequest">
                    <uix:styledText textBinding="FREE_SP_INTRO@sgBundle@servletRequest" styleClass="OraTipText"/>
                  </uix:rowLayout>

                  <uix:rowLayout >
                    <uix:styledText textBinding="DEFAULT_TIP@sgBundle@servletRequest" styleClass="OraTipText"/>
                  </uix:rowLayout>

	  <uix:spacer height="20" />
          <%-- Return Button --%>
          <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right">
          <uix:button textBinding="RETURN@hasBundle@servletRequest" destinationBinding="returnURL@defaultBean@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

                </uix:tableLayout>
              </uix:contents>
            </uix:stackLayout>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
