<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<uix:body>
<db:form name="sg" method="POST" destination="/em/console/has/serverGroups" copyParams="target,type,isRepDown">
<uix:pageLayout>
<%@ include file="/oemGlobal.jspf" %>
<uix:messages>
    <oem:messageBox messageTypeBinding="messageType@servletRequest" errorTableBinding="msgBox@servletRequest"
                    destTableBinding="msgUrls@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
</uix:messages>
<uix:stackLayout>
<uix:contents>
<uix:tableLayout width="100%">
    <uix:rowLayout hAlign="right">
        <uix:cellFormat columnSpan="2" hAlign="right">
            <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event" value="cancelRelocateServer"/>
            <uix:spacer width="10"/>
                <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest" name="event"
                                  value="confirmRelocateServer"/>
        </uix:cellFormat>
    </uix:rowLayout>
</uix:tableLayout>
<uix:header textBinding="relocateTitle@servletRequest">
<uix:styledText styleClass="OraInstructionText" textBinding="RELOCATE_SERVER_INTRO@sgBundle@servletRequest"/>
<uix:contents>
    <uix:tableLayout width="100%" cellSpacing="5" cellPadding="5">
        <uix:rowLayout>
            <uix:cellFormat>
                <uix:stackLayout>
                    <uix:shuttle name="servers" leadingHeaderBinding="AVAILABLE_SERVERS@sgBundle@servletRequest"
                                 reorderable="false" trailingHeaderBinding="SELECTED_SERVERS@sgBundle@servletRequest" >
                        <uix:leading>
                            <oem:list name="availableServers"
                                      shortDescBinding="AVAILABLE_SERVERS@sgBundle@servletRequest" multiple="true">
                                <uix:contents childDataBinding="displayableServerList@relocateServerBean@servletRequest">
                                    <uix:option textBinding="text" valueBinding="value"/>
                                </uix:contents>
                            </oem:list>

                        </uix:leading>
                        <uix:trailing>
                            <oem:list name="selectedServers"
                                      shortDescBinding="SELECTED_SERVERS@sgBundle@servletRequest" multiple="true">
                                <uix:contents childDataBinding="displayableSelectedServerList@relocateServerBean@servletRequest">
                                    <uix:option textBinding="text" valueBinding="value"/>
                                </uix:contents>
                            </oem:list>
                        </uix:trailing>
                    </uix:shuttle>
                    <uix:tip styleClass="OraInlineInfoText" textBinding="RELOCATE_SERVER_TIP1@sgBundle@servletRequest"/>
                    <uix:tip styleClass="OraInlineInfoText" textBinding="RELOCATE_SERVER_TIP2@sgBundle@servletRequest"/>
                </uix:stackLayout>
            </uix:cellFormat>
        </uix:rowLayout>
    </uix:tableLayout>


</uix:contents>
</uix:header>
<%-- Advanced Section --%>
</uix:contents>
</uix:stackLayout>
<uix:contentFooter>
    <uix:pageButtonBar>
        <uix:spacer width="10"/>
        <uix:flowLayout>
            <uix:submitButton textBinding="CANCEL_BUTTON@hasBundle@servletRequest" name="event" value="cancelRelocateServer"/>
            <uix:spacer width="10"/>
                    <uix:submitButton textBinding="SUBMIT_BUTTON@hasBundle@servletRequest" name="event"
                                      value="confirmRelocateServer"/>
        </uix:flowLayout>
    </uix:pageButtonBar>
</uix:contentFooter>
</uix:pageLayout>
</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
