<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
    <%--<uix:bundle name="sgBundle" class="oracle.sysman.has.rsc.ServerGroupsMsg"/>--%>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_SERVER_GROUP_OBJECT@resourcesBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        --%>
          <uix:listOfValues
              titleBinding="SELECT_SERVER_GROUP_OBJECT@resourcesBundle@servletRequest"
              shortDescBinding="SELECT_SERVER_GROUP_OBJECT@resourcesBundle@servletRequest"
              searchTextBinding="searchCriteria@defaultSGBean@servletRequest">

    <uix:messages>
      <oem:messageBox messageTypeBinding="messageType@servletRequest"
                      errorTableBinding="remoteOpResults@defaultSGBean@servletRequest"
                      destTableBinding="msgUrls@servletRequest"/>
    </uix:messages>

            <uix:formValue
                name="pageName"
                value="/has/serverGroups/selectSG.jsp"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_SERVER_GROUP_SEARCH_ITEM@resourcesBundle@servletRequest"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                  beanKey="defaultSGBean"
                  alternateTextBinding="MSG_NO_SERVER_GROUPS_FOUND@resourcesBundle@servletRequest"
                  name="selectSGDS"
                  dataSourceProp="selectSGDS"
                  width="100%"
                  blockSize="50"
                  formSubmitted="true"
                  proxied="true">

                <uix:tableSelection>
                  <uix:multipleSelection selectionBinding="viewableSelectedSGIndexes@addRes@servletRequest" selectedBinding="isSelected" />
                </uix:tableSelection>
              </oem:table>
                  <%--<uix:styledText textBinding="FREE_SP_INTRO@sgBundle@servletRequest" styleClass="OraTipText"/>--%>
                <uix:stackLayout>
                    <uix:spacer height="5"/>
                    <uix:styledText textBinding="FREE_SP_INTRO@sgBundle@servletRequest" styleClass="OraTipText"/>
                    <uix:styledText textBinding="DEFAULT_TIP@sgBundle@servletRequest" styleClass="OraTipText"/>
                </uix:stackLayout>

            </uix:contents>
          </uix:listOfValues>
      </uix:contents>
    </uix:body>

  </uix:document>
</uix:renderingContext>
