<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf"%>
    <uix:body onLoad="document.forms[0].setAttribute('autocomplete','OFF');">
      <db:form name="foo" destination="/em/console/has/serverGroups" method="post" copyParams="target,type,cancelURL,isRepDown">
        <uix:pageLayout>
          <%@ include file="/database/global.jspf"%>
          <uix:messages>
            <oem:messageBox messageTypeBinding="messageType@servletRequest" errorTableBinding="msgBox@servletRequest" destTableBinding="msgUrls@servletRequest" titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
          <uix:header textBinding="sgHeader@servletRequest">
            <uix:stackLayout>
              <uix:contents>
                <uix:tableLayout cellSpacing="5">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="SG_NAME@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="name@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="OWNER@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="owner@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="MIN_SIZE@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="minSize@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="MAX_SIZE@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                        <uix:switcher childNameBinding="maxSize@selectedSG@servletRequest">
                            <uix:case name="-1">
                                <uix:styledText styleClass="OraDataText" textBinding="ENTIRE_CLUSTER@sgBundle@servletRequest"/>
                            </uix:case>
                            <uix:default>
                                <uix:styledText styleClass="OraDataText" textBinding="maxSize@selectedSG@servletRequest"/>
                            </uix:default>
                        </uix:switcher>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="IMPORTANCE@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="importance@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="PARENT_SERVER_GROUPS@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:contents>
                        <uix:include nodeBinding="parentGroupWithLinks@selectedSG@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="MEMBERS@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="membersForDisplay@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="ACTIVE_SERVERS@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="activeServersForDisplay@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>

<%--
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="OVERLAPPING_GROUPS@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="overlappingGroups@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
--%>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="35%">
                      <uix:styledText styleClass="OraPromptText" textBinding="EXCLUSIVE_GROUPS@sgBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:spacer width="2"/>
                    <uix:cellFormat hAlign="left">
                      <uix:styledText styleClass="OraDataText" textBinding="exclusiveGroupsForDisplay@selectedSG@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                <uix:tableLayout width="100%">
                  <uix:rowLayout hAlign="right">
                    <uix:cellFormat hAlign="right">
                      <uix:submitButton textBinding="RETURN@hasBundle@servletRequest" name="event" value="reload"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:contents>
            </uix:stackLayout>
          </uix:header>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
