<%@ include file="/sdk/oemTop.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
     <uix:pageLayout>
      <%@ include file="/database/global.jspf" %> 

      <db:form name="status" method="POST" destination="/em/console/has/stateChange" copyParams="target,type,isRepDown">
<uix:formValue name="returnURL" valueBinding="returnURL@defaultBean@servletRequst"/>
              <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                              errorTableBinding="msgBox@servletRequest"
                              titleTextKey="titleText" mainTextKey="mainText"/>

          <!-- ===========================  Status Table ================== -->

          <uix:stackLayout>              

            <uix:header textBinding="CRS_STATE_CHANGE_HEADER@scBundle@servletRequest" />   
	    <!-- page refresh time / refresh button -->
	    <uix:tableLayout width="100%">
	    <uix:rowLayout>

  	    <uix:cellFormat hAlign="right" vAlign="top" width="35%">
	       <uix:flowLayout>
	         <uix:styledText styleClass="OraTipText" 
	              textBinding="PAGE_REFRESHED@hasBundle@servletRequest"/>
	         <uix:spacer width="5" />  

	         <uix:styledText styleClass="OraTipLabel" 
	              textBinding="refreshTime@defaultBean@servletRequest"/>

	         <uix:spacer width="5" />  
   	         <uix:submitButton textBinding="REFRESH_BUTTON@hasBundle@servletRequest" name="event" value="doLoad"/>

	      </uix:flowLayout>
            </uix:cellFormat> 	    
	    </uix:rowLayout> 	    
	  </uix:tableLayout>	    


	    <uix:spacer height="5"/>
               <uix:styledText styleClass="OraInstructionText" textBinding="CRS_STATE_CHANGE_INTRO@scBundle@servletRequest" />   


	    <uix:spacer height="20"/>

	    <!-- db level operations -->
	    <uix:tableLayout width="100%">
	    <uix:rowLayout hAlign="right">
	    <uix:cellFormat hAlign="right"> 

	    <uix:pageButtonBar>
              <uix:submitButton textBinding="CRS_STATE_CHANGE_STARTUP_ALL@scBundle@servletRequest" name="event" value="StartupAll"/>
              <uix:submitButton textBinding="CRS_STATE_CHANGE_SHUTDOWN_ALL@scBundle@servletRequest" name="event" value="ShutdownAll" renderedBinding="shutdownAll@servletRequest"/>
	    </uix:pageButtonBar>

	    </uix:cellFormat> 
	    </uix:rowLayout> 	    
	    </uix:tableLayout>	    

	    <uix:spacer height="10"/>


                <oem:table name="stateChangeTable" width="100%"                          
                           formSubmitted="true"
                           summaryBinding="CRS_STATE_CHANGE_HEADER@scBundle@servletRequest" 
                           destination="/console/has/stateChange" 
                           beanKey="defaultBean"                           
                           blockSize="50"
                           dataSourceProp="stateChangeTable"    
                           alternateTextBinding="NO_COMPS_ALT@scBundle@servletRequest">                

		       <uix:tableSelection>
		         <uix:multipleSelection shortDescBinding="SELECT@commonBundle@servletRequest">
			   
                              <uix:submitButton textBinding="CRS_STATE_CHANGE_STARTUP@scBundle@servletRequest" name="event" value="Startup"/>
			      <uix:spacer width="5"/>
                              <uix:submitButton textBinding="CRS_STATE_CHANGE_SHUTDOWN@scBundle@servletRequest" name="event" value="Shutdown"/>

<%--                              <uix:submitButton textBinding="RESTART_BUTTON@scBundle@servletRequest" name="event" value="Restart"/>  --%>

			 </uix:multipleSelection>
		       </uix:tableSelection>

            </oem:table>            


	  <uix:spacer height="20" />

          <uix:tableLayout width="100%">
          <uix:rowLayout hAlign="right">
          <uix:cellFormat hAlign="right">
          <uix:button textBinding="RETURN@hasBundle@servletRequest" destinationBinding="returnURL@defaultBean@servletRequest" />
          </uix:cellFormat>
          </uix:rowLayout>
          </uix:tableLayout>

          </uix:stackLayout>          

      </db:form>
      </uix:pageLayout>

      </uix:body>

    </uix:document> 
  </uix:renderingContext>
