<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.DBObjectMsg" %>
<%@page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request )));
%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>
    <uix:body>
      <uix:form name="foo" method="POST" destinationBinding="defaultControllerURL@defaultBean@servletRequest">
      <uix:formValue name="pageName" value="/net/listener/actionConfirm"/>
	
	<uix:pageLayout titleBinding="header@defaultBean@servletRequest">
	  <%@ include file="/oemGlobal.jspf" %> 
	
              <uix:switcher childNameBinding ="currentState@defaultBean@servletRequest" >
        	<uix:case name="true">
		        <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="75%">
			  <uix:messagePrompt promptBinding="CURRENT_STATUS@ListenerBundle@servletRequest" />
			  <uix:styledText  styleClass="OraDataText"
				  textBinding="currentStateMsg@defaultBean@servletRequest"/>
		        </uix:labeledFieldLayout>
                  </uix:case>
                  </uix:switcher>
			<uix:spacer width="10"/>
	      <uix:switcher childNameBinding="inConsistentState@defaultBean@pageContext">
		<uix:case name="true">
		        <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="75%">
			      <uix:messagePrompt prompt=""/>
			      <uix:styledText textBinding="inConsistentStateMsg@defaultBean@servletRequest" styleClass="OraInlineInfoText" />
		        </uix:labeledFieldLayout>
		</uix:case>
	      </uix:switcher>


             <uix:switcher childNameBinding ="tracingAction@defaultBean@servletRequest" >
	     <uix:case name="false">
	          <uix:switcher childNameBinding ="makeTargetAction@defaultBean@servletRequest" >
	          <uix:case name="true">
				<uix:stackLayout>
 	              <uix:messagePrompt promptBinding="LSN_TARGET_NAME_HDR@ListenerBundle@servletRequest"/>

				  <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="75%">
	 	                <uix:messagePrompt promptBinding="LSN_TARGET_NAME@ListenerBundle@servletRequest" 
								labeledNodeId="targetName" required="yes" />
 	 			        <uix:stackLayout>
		        	       <uix:textInput name="targetName" id="targetName"
						   		shortDescBinding="LSN_TARGET_NAME@ListenerBundle@servletRequest" 
								textBinding="targetName@defaultBean@servletRequest"/>
					       <uix:formValue name="id" valueBinding="objectName@defaultBean@servletRequest" />
					       <uix:messageText messageType="error" messageBinding="LSN_TARGET_NAME@errors@servletRequest"/>
		 			    </uix:stackLayout>
				  </uix:labeledFieldLayout>
 			       </uix:stackLayout>
	          </uix:case>

	          <uix:case name="false">
				  <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="75%">
					  <uix:messagePrompt promptBinding="OPERATION@ListenerBundle@servletRequest" />
					  <uix:styledText  styleClass="OraDataText"
						  textBinding="operationMsg@defaultBean@servletRequest"/>
				  </uix:labeledFieldLayout>
	          </uix:case>
                  </uix:switcher>

             </uix:case>
             <uix:case name="true">
			  <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="75%">
			  <uix:messagePrompt promptBinding="SET_TRACE_OP@ListenerBundle@servletRequest" />
 		                 <uix:styledText styleClass=""  />

	 		                 <uix:styledText styleClass=""  />
				<uix:tableLayout cellSpacing="5">

		                  <uix:rowLayout>
		                    <oem:radioButton name="traceLevel" 
		                         disabledBinding="offTraceLevelDisabled@defaultBean@servletRequest"
		                         textBinding="TRACE_LEVEL_OFF@ListenerBundle@servletRequest"
								 shortDescBinding="SET_TRACE_OP@ListenerBundle@servletRequest"
		                         valueBinding="TRACE_LEVEL_OFF@ListenerBundle@servletRequest"
		                         selectedValueBinding="traceLevel@defaultBean@servletRequest"/>
		                  </uix:rowLayout>

		                  <uix:rowLayout>
 		                  <uix:stackLayout>
		                    <oem:radioButton name="traceLevel"
		                         disabledBinding="userTraceLevelDisabled@defaultBean@servletRequest"
		                         textBinding="TRACE_LEVEL_USER@ListenerBundle@servletRequest"
								 shortDescBinding="SET_TRACE_OP@ListenerBundle@servletRequest"
		                         valueBinding="TRACE_LEVEL_USER@ListenerBundle@servletRequest"
		                         selectedValueBinding="traceLevel@defaultBean@servletRequest"/>
		                    <uix:messageText messageType="info" messageBinding="TRACE_LEVEL_DESC_USER@ListenerBundle@servletRequest"/>
 		                  </uix:stackLayout>
		                  </uix:rowLayout>

		                  <uix:rowLayout>
 		                  <uix:stackLayout>
		                    <oem:radioButton name="traceLevel"
		                         disabledBinding="adminTraceLevelDisabled@defaultBean@servletRequest"
		                         textBinding="TRACE_LEVEL_ADMIN@ListenerBundle@servletRequest"
								 shortDescBinding="SET_TRACE_OP@ListenerBundle@servletRequest"
		                         valueBinding="TRACE_LEVEL_ADMIN@ListenerBundle@servletRequest"
		                         selectedValueBinding="traceLevel@defaultBean@servletRequest"/>
		                    <uix:messageText messageType="info" messageBinding="TRACE_LEVEL_DESC_ADMIN@ListenerBundle@servletRequest"/>
 		                  </uix:stackLayout>
		                  </uix:rowLayout>

		                  <uix:rowLayout>
 		                  <uix:stackLayout>
		                    <oem:radioButton name="traceLevel"
		                         disabledBinding="supportTraceLevelDisabled@defaultBean@servletRequest"
		                         textBinding="TRACE_LEVEL_SUPPORT@ListenerBundle@servletRequest"
								 shortDescBinding="SET_TRACE_OP@ListenerBundle@servletRequest"
		                         valueBinding="TRACE_LEVEL_SUPPORT@ListenerBundle@servletRequest"
		                         selectedValueBinding="traceLevel@defaultBean@servletRequest"/>
		                    <uix:messageText messageType="info" messageBinding="TRACE_LEVEL_DESC_SUPPORT@ListenerBundle@servletRequest"/>
 		                  </uix:stackLayout>
		                  </uix:rowLayout>

		                </uix:tableLayout>

			  </uix:labeledFieldLayout>
            </uix:case>
            </uix:switcher>

  
 	  <uix:pageButtons>
		    <uix:pageButtonBar>
	              <uix:switcher childNameBinding ="operationPossible@defaultBean@servletRequest" >
        		<uix:case name="true">
			    <uix:pageButtonBar>
			      <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
			      <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  		name="event" value="doAction" shortDescBinding="OK@netBundle@servletRequest"/> 
			    </uix:pageButtonBar>
	                </uix:case>
        		<uix:case name="false">
			      <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="OK@netBundle@servletRequest"/> 
        	        </uix:case>
                	</uix:switcher>
		    </uix:pageButtonBar>
	  </uix:pageButtons>
	</uix:pageLayout>

      </uix:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext> 
