<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.emSDK.util.jdk.NLSUtil" %>
<%@ page import="oracle.sysman.db.rsc.net.NetMsg" %>
<%@ page import="oracle.cabo.ui.data.BundleDataObject" %>
<%
  request.setAttribute("netBundle", new BundleDataObject(NLSUtil.getBundle(NetMsg.class.getName(), request)));
%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="TITLE@servletRequest"/>
    </uix:metaContainer>

  <uix:body>
      <uix:form name="protocolForm" method="post" destinationBinding="defaultControllerURL@controllerIDBean@servletRequest">
          <uix:pageLayout titleBinding="pageHeader@servletRequest">
	    <%@ include file="/oemGlobal.jspf" %>
	    <uix:formValue name="pageName" value="/net/listener/addressPage"/>

	    <uix:pageButtons>
              <uix:pageButtonBar>
	    	      <uix:submitButton textBinding="CANCEL@defaultMsgBundle@servletRequest" 
				  		name="event" value="cancel" shortDescBinding="CANCEL@netBundle@servletRequest"/>
	    	      <uix:submitButton textBinding="OK@defaultMsgBundle@servletRequest" 
				  		name="event" value="createAddress" shortDescBinding="OK@netBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

           <oem:messageBox messageType = "error" msgBundleBinding="CommonMsg@servletRequest" errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
	
	    <uix:switcher childNameBinding="mode@servletRequest">
	    <uix:case name="create">
	        <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="80%">
                <uix:messagePrompt promptBinding="PROTOCOL_FIELD@defaultMsgBundle@servletRequest"
						labeledNodeId="selectedProtocolID"/>
                <uix:choice name="selectedProtocolID" id="selectedProtocolID"
						selectedValueBinding="selectedProtocolID@mainNetBean@servletRequest"
						shortDescBinding="PROTOCOL_FIELD@defaultMsgBundle@servletRequest"
						onChange="submitForm('protocolForm', true,{'event':'changeProtocol'})" >
                  <uix:contents childDataBinding="protocolsChoiceInfo@mainNetBean@servletRequest">
                    <uix:option textBinding="netTextKey"
                                valueBinding="netValueKey"/>
                  </uix:contents>
			</uix:choice>
	        </uix:labeledFieldLayout>
	    </uix:case>
	    <uix:case name="edit">
            <uix:labeledFieldLayout labelWidth="25%" fieldWidth="100%" width="80%">
              <uix:messagePrompt promptBinding="PROTOCOL_FIELD@defaultMsgBundle@servletRequest"/>
		    <uix:switcher childNameBinding="protocol@defaultBean@servletRequest">
			    <uix:case name="TCP">
			            <uix:styledText styleClass="OraDataText" textBinding="TCP@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="TCPS">
			            <uix:styledText styleClass="OraDataText" textBinding="TCPS@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="SDP">
			            <uix:styledText styleClass="OraDataText" textBinding="SDP@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="IPC">
			            <uix:styledText styleClass="OraDataText" textBinding="IPC@CommonBundle@servletRequest"/>
			    </uix:case>
			    <uix:case name="NMP">
			            <uix:styledText styleClass="OraDataText" textBinding="NAMED_PIPES@CommonBundle@servletRequest"/>
			    </uix:case>
		    </uix:switcher>
	        </uix:labeledFieldLayout>
	    </uix:case>
	    </uix:switcher>
	
	<uix:switcher childNameBinding="protocol@defaultBean@servletRequest">
		    <uix:case name="TCPS">
			  <%@ include file="../addr/addressTCP.jsp" %>
		    </uix:case>
		    <uix:case name="TCP">
			  <%@ include file="../addr/addressTCP.jsp" %>
		    </uix:case>
		    <uix:case name="IPC">
			  <%@ include file="../addr/addressIPC.jsp" %>
		    </uix:case>
		    <uix:case name="NMP">
			  <%@ include file="../addr/addressNMP.jsp" %>
		    </uix:case>
		    <uix:case name="SDP">
			  <%@ include file="../addr/addressTCP.jsp" %>
		    </uix:case>
	    </uix:switcher>

	    <%--    This section is for PRESENTATION attributes --%>
	    <%--
	    <uix:header textBinding="PRESENTATION@ListenerBundle@servletRequest">
                 <uix:tableLayout>
   		   <uix:rowLayout>
		     <uix:cellFormat hAlign="left">
                         <uix:contents />
                     </uix:cellFormat>
                     <uix:cellFormat hAlign="right">
		        <uix:stackLayout>
                    <uix:checkBox name="presentation" 
							textBinding="PRESENTATION@ListenerBundle@servletRequest"
							shortDescBinding="PRESENTATION@ListenerBundle@servletRequest"
		          			checkedBinding = "presentation@mainNetBean@servletRequest"
		          			onClick="submitForm('protocolForm', true,{'event':'changePresentation'})" />
				<uix:switcher childNameBinding="presentation@mainNetBean@servletRequest">
		   			<uix:case name="true">
		   			   <uix:rowLayout>
					      <uix:cellFormat hAlign="right">
                    	       <uix:checkBox name="imap" textBinding="IMAP@ListenerBundle@servletRequest"
			       				checkedBinding = "IMAP@mainNetBean@servletRequest"
								shortDescBinding="IMAP@ListenerBundle@servletRequest"
			       				onClick="submitForm('protocolForm', true,{'event':'changeIMAP'})"   />
						</uix:cellFormat>
                    			   </uix:rowLayout>
		    			</uix:case>
		    		</uix:switcher>
			  </uix:stackLayout>
                      </uix:cellFormat>
		     </uix:rowLayout>
                 </uix:tableLayout>
              </uix:header>
	      --%>
	      <%--    This section is for PRESENTATION attributes --%>

          </uix:pageLayout>
  </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>


